/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.ctm;

import com.falsepattern.mcpatcher.internal.modules.common.CommonParser;
import com.falsepattern.mcpatcher.internal.modules.common.IntRange;
import com.falsepattern.mcpatcher.internal.modules.common.ResourceScanner;
import com.falsepattern.mcpatcher.internal.modules.common.WeightedRandom;
import com.falsepattern.mcpatcher.internal.modules.ctm.CTMEngine;
import com.falsepattern.mcpatcher.internal.modules.ctm.CTMParser;
import com.falsepattern.mcpatcher.internal.modules.ctm.CompactCTMDecoder;
import com.falsepattern.mcpatcher.internal.modules.ctm.Connect;
import com.falsepattern.mcpatcher.internal.modules.ctm.Method;
import com.falsepattern.mcpatcher.internal.modules.ctm.Side;
import com.falsepattern.mcpatcher.internal.modules.ctm.Symmetry;
import com.falsepattern.mcpatcher.internal.modules.ctm.TextureMapExtension;
import com.falsepattern.mcpatcher.internal.modules.overlay.ResourceGenerator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CTMInfo {
    @NotNull
    private final String name;
    @NotNull
    private final String basePath;
    @NotNull
    private final Method method;
    private final int facesMask;
    @Nullable
    private final @Unmodifiable IntList metadatas;
    @Nullable
    private final @Unmodifiable ObjectList<BiomeGenBase> biomes;
    private final @Nullable @Unmodifiable IntRange.List heights;
    private final int renderPass;
    private final boolean innerSeams;
    private final int width;
    private final int height;
    @NotNull
    private final Symmetry symmetry;
    public boolean linked;
    public IIcon[] matchTileIcons;
    public IIcon[] tileIcons;
    private @Nullable @Unmodifiable ObjectList<@NotNull Block> matchBlocks;
    @Nullable
    private @Unmodifiable ObjectList<String> matchTiles;
    @Nullable
    private @Unmodifiable ObjectList<String> tiles;
    @NotNull
    private Connect connect;
    @Nullable
    private WeightedRandom weights;

    public CTMInfo(@NotNull Properties props, @NotNull String path) {
        this.name = CTMParser.parseName(path);
        this.basePath = CTMParser.parseBasePath(path);
        this.matchBlocks = CTMParser.parseBlockIds(props.getProperty("matchBlocks"));
        this.matchTiles = CTMParser.parseMatchTiles(props.getProperty("matchTiles"), this.basePath);
        this.method = CTMParser.parseMethod(props.getProperty("method"));
        this.tiles = CTMParser.parseTileNames(props.getProperty("tiles"), this.basePath);
        this.connect = CTMParser.parseConnect(props.getProperty("connect"));
        this.facesMask = CTMParser.parseFacesMask(props.getProperty("faces"));
        this.metadatas = CommonParser.parseInts(props.getProperty("metadata"), 0, 65535);
        this.biomes = CommonParser.parseBiomes(props.getProperty("biomes"));
        IntRange.List heights = CommonParser.parseIntRanges(props.getProperty("heights"));
        if (heights == null) {
            int minHeight = CommonParser.parseInt(props.getProperty("minHeight"), Integer.MIN_VALUE);
            int maxHeight = CommonParser.parseInt(props.getProperty("maxHeight"), Integer.MAX_VALUE);
            if (minHeight != Integer.MIN_VALUE || maxHeight != Integer.MAX_VALUE) {
                heights = new IntRange.List();
                heights.add(new IntRange(minHeight, maxHeight));
            }
        }
        this.heights = heights;
        this.renderPass = CommonParser.parseInt(props.getProperty("renderPass"));
        this.innerSeams = CommonParser.parseBoolean(props.getProperty("innerSeams"));
        this.width = CommonParser.parseInt(props.getProperty("width"));
        this.height = CommonParser.parseInt(props.getProperty("height"));
        IntList weights = CommonParser.parseInts(props.getProperty("weights"), 0, 65535);
        if (weights != null) {
            this.weights = new WeightedRandom(weights);
        }
        this.symmetry = CTMParser.parseSymmetry(props.getProperty("symmetry"));
    }

    public static String toFileName(String iconName) {
        String fullName = !iconName.contains("/") ? "textures/blocks/" + iconName : iconName;
        return fullName + ".png";
    }

    @Nullable
    private static IIcon getIcon(String iconName) {
        TextureMap map = TextureMapExtension.textureMapBlocks;
        if (map == null) {
            return null;
        }
        return map.getTextureExtry(iconName);
    }

    private static void warnTilesNotDefined(String path) {
        CTMEngine.LOG.warn("Tiles not defined: {}", new Object[]{path});
    }

    private static void warnInvalidTilesExact(int expected, String path) {
        CTMEngine.LOG.warn("Invalid tiles, must be exactly {}: {}", new Object[]{expected, path});
    }

    @Contract(value="!null, _, _-> !null; null, _, _ -> null")
    @Nullable
    private IIcon[] registerIcons(@Nullable ObjectList<String> tileNames, @NotNull TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay) {
        if (tileNames == null) {
            return null;
        }
        if (this.method == Method.Compact) {
            if (overlay == null) {
                throw new RuntimeException("Resource overlay is disabled, cannot load compact CTMs!");
            }
            return CompactCTMDecoder.decode(tileNames, textureMap, overlay);
        }
        ObjectArrayList icons = new ObjectArrayList();
        for (String iconName : tileNames) {
            String fileName = CTMInfo.toFileName(iconName);
            ResourceLocation loc = new ResourceLocation(fileName);
            boolean exists = ResourceScanner.hasResource(loc);
            if (!exists) {
                CTMEngine.LOG.warn("File not found: {}", new Object[]{fileName});
            }
            IIcon icon = textureMap.func_94245_a(iconName);
            icons.add((Object)icon);
        }
        return (IIcon[])icons.toArray((Object[])new IIcon[0]);
    }

    public boolean isValid(String path) {
        if (this.name.isEmpty()) {
            CTMEngine.LOG.warn("No name found: {}", new Object[]{path});
            return false;
        }
        if (this.matchBlocks == null) {
            this.matchBlocks = this.detectMatchBlocks();
        }
        if (this.matchTiles == null && this.matchBlocks == null) {
            this.matchTiles = this.detectMatchTiles();
        }
        if (this.matchBlocks == null && this.matchTiles == null) {
            CTMEngine.LOG.warn("No matchBlocks or matchTiles specified: {}", new Object[]{path});
            return false;
        }
        if (this.method == Method.None) {
            CTMEngine.LOG.warn("No method: {}", new Object[]{path});
            return false;
        }
        if (this.tiles == null || this.tiles.isEmpty()) {
            CTMEngine.LOG.warn("No tiles specified: {}", new Object[]{path});
            return false;
        }
        if (this.connect == Connect.None) {
            this.connect = this.detectConnect();
        }
        if (this.connect == Connect.Unknown) {
            CTMEngine.LOG.warn("Invalid connect in: {}", new Object[]{path});
            return false;
        }
        if (this.renderPass > 0) {
            CTMEngine.LOG.warn("Render pass not supported: {}", new Object[]{this.renderPass});
            return false;
        }
        if (Side.matches(128, this.facesMask)) {
            CTMEngine.LOG.warn("Invalid faces in: {}", new Object[]{path});
            return false;
        }
        if (this.symmetry == Symmetry.Unknown) {
            CTMEngine.LOG.warn("Invalid symmetry in: {}", new Object[]{path});
            return false;
        }
        switch (this.method) {
            case Ctm: {
                return this.isValidCtm(path);
            }
            case Compact: {
                return this.isValidCompact(path);
            }
            case Horizontal: {
                return this.isValidHorizontal(path);
            }
            case Top: {
                return this.isValidTop(path);
            }
            case Random: {
                return this.isValidRandom(path);
            }
            case Repeat: {
                return this.isValidRepeat(path);
            }
            case Vertical: {
                return this.isValidVertical(path);
            }
            case Fixed: {
                return this.isValidFixed(path);
            }
            case HorizontalVertical: {
                return this.isValidHorizontalVertical(path);
            }
            case VerticalHorizontal: {
                return this.isValidVerticalHorizontal(path);
            }
        }
        CTMEngine.LOG.warn("Unknown method: {}", new Object[]{path});
        return false;
    }

    public void updateIcons(TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay) {
        this.matchTileIcons = this.registerIcons(this.matchTiles, textureMap, overlay);
        this.tileIcons = this.registerIcons(this.tiles, textureMap, overlay);
    }

    private Connect detectConnect() {
        if (this.matchBlocks != null) {
            return Connect.Block;
        }
        if (this.matchTiles != null) {
            return Connect.Tile;
        }
        return Connect.Unknown;
    }

    @Nullable
    private ObjectList<Block> detectMatchBlocks() {
        int startPos;
        char ch;
        int pos;
        if (!this.name.startsWith("block")) {
            return null;
        }
        for (pos = startPos = "block".length(); pos < this.name.length() && (ch = this.name.charAt(pos)) >= '0' && ch <= '9'; ++pos) {
        }
        if (pos == startPos) {
            return null;
        }
        String idStr = this.name.substring(startPos, pos);
        int id = CommonParser.parseInt(idStr, -1);
        if (id < 0) {
            return null;
        }
        Block block = Block.func_149729_e((int)id);
        if (block == null) {
            return null;
        }
        return ObjectLists.singleton((Object)block);
    }

    private ObjectList<String> detectMatchTiles() {
        IIcon icon = CTMInfo.getIcon(this.name);
        return icon == null ? null : ObjectLists.singleton((Object)this.name);
    }

    private boolean isValidCtm(String path) {
        if (this.tiles == null) {
            this.tiles = CTMParser.parseTileNames("0-11 16-27 32-43 48-58", this.basePath);
        }
        if (this.tiles.size() < 47) {
            CTMEngine.LOG.warn("Invalid tiles, must be at least 47: {}", new Object[]{path});
            return false;
        }
        return true;
    }

    private boolean isValidCompact(String path) {
        if (this.tiles == null) {
            this.tiles = CTMParser.parseTileNames("0-4", this.basePath);
        }
        if (this.tiles.size() < 5) {
            CTMEngine.LOG.warn("Invalid tiles, must be at least 5: {}", new Object[]{path});
            return false;
        }
        return true;
    }

    private boolean isValidHorizontal(String path) {
        if (this.tiles == null) {
            this.tiles = CTMParser.parseTileNames("12-15", this.basePath);
        }
        if (this.tiles.size() != 4) {
            CTMInfo.warnInvalidTilesExact(4, path);
            return false;
        }
        return true;
    }

    private boolean isValidVertical(String path) {
        if (this.tiles == null) {
            CTMEngine.LOG.warn("No tiles defined for vertical: {}", new Object[]{path});
            return false;
        }
        if (this.tiles.size() != 4) {
            CTMInfo.warnInvalidTilesExact(4, path);
            return false;
        }
        return true;
    }

    private boolean isValidHorizontalVertical(String path) {
        if (this.tiles == null) {
            CTMEngine.LOG.warn("No tiles defined for horizontal+vertical: {}", new Object[]{path});
            return false;
        }
        if (this.tiles.size() != 7) {
            CTMInfo.warnInvalidTilesExact(7, path);
            return false;
        }
        return true;
    }

    private boolean isValidVerticalHorizontal(String path) {
        if (this.tiles == null) {
            CTMEngine.LOG.warn("No tiles defined for vertical+horizontal: {}", new Object[]{path});
            return false;
        }
        if (this.tiles.size() != 7) {
            CTMInfo.warnInvalidTilesExact(7, path);
            return false;
        }
        return true;
    }

    private boolean isValidRandom(String path) {
        if (this.tiles == null || this.tiles.isEmpty()) {
            CTMInfo.warnTilesNotDefined(path);
            return false;
        }
        if (this.weights == null) {
            return true;
        }
        if (this.weights.size() > this.tiles.size()) {
            CTMEngine.LOG.warn("More weights defined than tiles, trimming weights: {}", new Object[]{path});
            this.weights = this.weights.resize(this.tiles.size());
        }
        if (this.weights.size() < this.tiles.size()) {
            CTMEngine.LOG.warn("Less weights defined than tiles, expanding weights: {}", new Object[]{path});
            this.weights = this.weights.resize(this.tiles.size());
        }
        return true;
    }

    private boolean isValidRepeat(String path) {
        if (this.tiles == null) {
            CTMInfo.warnTilesNotDefined(path);
            return false;
        }
        if (this.width <= 0 || this.width > 16) {
            CTMEngine.LOG.warn("Invalid width: {}", new Object[]{path});
            return false;
        }
        if (this.height <= 0 || this.height > 16) {
            CTMEngine.LOG.warn("Invalid height: {}", new Object[]{path});
            return false;
        }
        if (this.tiles.size() != this.width * this.height) {
            CTMEngine.LOG.warn("Number of tiles does not equal width x height: {}", new Object[]{path});
            return false;
        }
        return true;
    }

    private boolean isValidFixed(String path) {
        if (this.tiles == null) {
            CTMInfo.warnTilesNotDefined(path);
            return false;
        }
        if (this.tiles.size() != 1) {
            CTMEngine.LOG.warn("Number of tiles should be 1 for method: fixed.");
            return false;
        }
        return true;
    }

    private boolean isValidTop(String path) {
        if (this.tiles == null) {
            this.tiles = CTMParser.parseTileNames("66", this.basePath);
        }
        if (this.tiles.size() != 1) {
            CTMEngine.LOG.warn("Invalid tiles, must be exactly 1: {}", new Object[]{path});
            return false;
        }
        return true;
    }

    @NotNull
    @Generated
    public String name() {
        return this.name;
    }

    @NotNull
    @Generated
    public String basePath() {
        return this.basePath;
    }

    @NotNull
    @Generated
    public Method method() {
        return this.method;
    }

    @Generated
    public int facesMask() {
        return this.facesMask;
    }

    @Nullable
    @Generated
    public IntList metadatas() {
        return this.metadatas;
    }

    @Nullable
    @Generated
    public ObjectList<BiomeGenBase> biomes() {
        return this.biomes;
    }

    @Generated
    public @Nullable @Unmodifiable IntRange.List heights() {
        return this.heights;
    }

    @Generated
    public int renderPass() {
        return this.renderPass;
    }

    @Generated
    public boolean innerSeams() {
        return this.innerSeams;
    }

    @Generated
    public int width() {
        return this.width;
    }

    @Generated
    public int height() {
        return this.height;
    }

    @NotNull
    @Generated
    public Symmetry symmetry() {
        return this.symmetry;
    }

    @Generated
    public boolean linked() {
        return this.linked;
    }

    @Generated
    public IIcon[] matchTileIcons() {
        return this.matchTileIcons;
    }

    @Generated
    public IIcon[] tileIcons() {
        return this.tileIcons;
    }

    @Nullable
    @Generated
    public @Nullable ObjectList<@NotNull Block> matchBlocks() {
        return this.matchBlocks;
    }

    @Nullable
    @Generated
    public ObjectList<String> matchTiles() {
        return this.matchTiles;
    }

    @Nullable
    @Generated
    public ObjectList<String> tiles() {
        return this.tiles;
    }

    @NotNull
    @Generated
    public Connect connect() {
        return this.connect;
    }

    @Nullable
    @Generated
    public WeightedRandom weights() {
        return this.weights;
    }
}

