/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.ctm;

import com.falsepattern.mcpatcher.internal.modules.common.Identity2ObjectHashMap;
import com.falsepattern.mcpatcher.internal.modules.common.MCPMath;
import com.falsepattern.mcpatcher.internal.modules.common.ResourceScanner;
import com.falsepattern.mcpatcher.internal.modules.ctm.Axis;
import com.falsepattern.mcpatcher.internal.modules.ctm.CTMInfo;
import com.falsepattern.mcpatcher.internal.modules.ctm.Connect;
import com.falsepattern.mcpatcher.internal.modules.ctm.ICTMSprite;
import com.falsepattern.mcpatcher.internal.modules.ctm.Side;
import com.falsepattern.mcpatcher.internal.modules.overlay.ResourceGenerator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.block.Block;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTMEngine {
    static final Logger LOG = LogManager.getLogger((String)"Right Proper MCPatcher CTM");
    private static final Object2ObjectMap<Block, ObjectList<CTMInfo>> blockProperties = new Identity2ObjectHashMap();
    private static final ObjectList<ObjectList<CTMInfo>> tileProperties = new ObjectArrayList();
    private static boolean multipass = false;

    public static IIcon getCTMIconMultiPass(IBlockAccess blockAccess, Block block, int x, int y, int z, @Nullable Side side, IIcon icon) {
        IIcon newMpIcon;
        if (blockAccess == null) {
            return icon;
        }
        IIcon newIcon = CTMEngine.getCTMIconSinglePass(blockAccess, block, x, y, z, side, icon, true);
        if (!multipass) {
            return newIcon;
        }
        if (newIcon == icon) {
            return newIcon;
        }
        IIcon mpIcon = newIcon;
        for (int i = 0; i < 3 && (newMpIcon = CTMEngine.getCTMIconSinglePass(blockAccess, block, x, y, z, side, mpIcon, false)) != mpIcon; ++i) {
            mpIcon = newMpIcon;
        }
        return mpIcon;
    }

    public static IIcon getCTMIconSinglePass(IBlockAccess blockAccess, Block block, int x, int y, int z, @Nullable Side side, IIcon icon, boolean checkBlocks) {
        IIcon newIcon;
        ObjectList infos;
        if (!(icon instanceof TextureAtlasSprite)) {
            return icon;
        }
        TextureAtlasSprite ts = (TextureAtlasSprite)icon;
        int iconId = ((ICTMSprite)ts).mcp$indexInMap();
        int metadata = -1;
        if (Tessellator.field_78398_a.defaultTexture && iconId >= 0 && iconId < tileProperties.size() && (infos = (ObjectList)tileProperties.get(iconId)) != null && (newIcon = CTMEngine.getCTMIcon((ObjectList<CTMInfo>)infos, blockAccess, block, x, y, z, side, (IIcon)ts, metadata = blockAccess.func_72805_g(x, y, z))) != null) {
            return newIcon;
        }
        if (checkBlocks && (infos = (ObjectList)blockProperties.get((Object)block)) != null) {
            if (metadata < 0) {
                metadata = blockAccess.func_72805_g(x, y, z);
            }
            if ((newIcon = CTMEngine.getCTMIcon((ObjectList<CTMInfo>)infos, blockAccess, block, x, y, z, side, (IIcon)ts, metadata)) != null) {
                return newIcon;
            }
        }
        return icon;
    }

    @Nullable
    private static IIcon getCTMIcon(ObjectList<CTMInfo> infos, IBlockAccess blockAccess, Block block, int x, int y, int z, @Nullable Side side, IIcon icon, int metadata) {
        for (CTMInfo info : infos) {
            IIcon newIcon;
            if (info == null || (newIcon = CTMEngine.getCTMIcon(info, blockAccess, block, x, y, z, side, icon, metadata)) == null) continue;
            return newIcon;
        }
        return null;
    }

    private static IIcon getCTMIcon(CTMInfo info, IBlockAccess blockAccess, Block block, int x, int y, int z, @Nullable Side side, IIcon icon, int metadata) {
        if (info.heights() != null && !info.heights().isInRange(y)) {
            return null;
        }
        if (info.biomes() != null) {
            BiomeGenBase blockBiome = blockAccess.func_72807_a(x, z);
            boolean biomeOk = false;
            for (BiomeGenBase biome : info.biomes()) {
                if (blockBiome != biome) continue;
                biomeOk = true;
                break;
            }
            if (!biomeOk) {
                return null;
            }
        }
        Axis vertAxis = Axis.Y;
        int metadataCheck = metadata;
        if (block instanceof BlockRotatedPillar) {
            vertAxis = CTMEngine.getWoodAxis(side, metadata);
            metadataCheck = metadata & 3;
        }
        if (block instanceof BlockQuartz) {
            vertAxis = CTMEngine.getQuartzAxis(side, metadata);
            if (metadataCheck > 2) {
                metadataCheck = 2;
            }
        }
        if (side != null && !Side.matches(Side.MASK_ALL, info.facesMask())) {
            Side sideCheck = side;
            if (vertAxis != Axis.Y) {
                sideCheck = CTMEngine.fixSideByAxis(side, vertAxis);
            }
            if (!sideCheck.matches(info.facesMask())) {
                return null;
            }
        }
        if (info.metadatas() != null) {
            IntList mds = info.metadatas();
            boolean metadataFound = false;
            int len = mds.size();
            for (int i = 0; i < len; ++i) {
                if (mds.getInt(i) != metadataCheck) continue;
                metadataFound = true;
                break;
            }
            if (!metadataFound) {
                return null;
            }
        }
        switch (info.method()) {
            case Ctm: 
            case Compact: {
                return CTMEngine.getConnectedTextureCtm(info, blockAccess, block, x, y, z, side, icon, metadata);
            }
            case Horizontal: {
                return CTMEngine.getConnectedTextureHorizontal(info, blockAccess, block, x, y, z, vertAxis, side, icon, metadata);
            }
            case Top: {
                return CTMEngine.getConnectedTextureTop(info, blockAccess, block, x, y, z, vertAxis, side, icon, metadata);
            }
            case Random: {
                return CTMEngine.getConnectedTextureRandom(info, blockAccess, block, x, y, z, side);
            }
            case Repeat: {
                return CTMEngine.getConnectedTextureRepeat(info, x, y, z, side);
            }
            case Vertical: {
                return CTMEngine.getConnectedTextureVertical(info, blockAccess, block, x, y, z, vertAxis, side, icon, metadata);
            }
            case Fixed: {
                return CTMEngine.getConnectedTextureFixed(info);
            }
            case HorizontalVertical: {
                return CTMEngine.getConnectedTextureHorizontalVertical(info, blockAccess, block, x, y, z, vertAxis, side, icon, metadata);
            }
            case VerticalHorizontal: {
                return CTMEngine.getConnectedTextureVerticalHorizontal(info, blockAccess, block, x, y, z, vertAxis, side, icon, metadata);
            }
        }
        return null;
    }

    private static Side fixSideByAxis(Side side, Axis vertAxis) {
        switch (vertAxis) {
            case Z: {
                switch (side) {
                    case YNeg: {
                        return Side.ZNeg;
                    }
                    case YPos: {
                        return Side.ZPos;
                    }
                    case ZNeg: {
                        return Side.YPos;
                    }
                    case ZPos: {
                        return Side.YNeg;
                    }
                }
                return side;
            }
            case X: {
                switch (side) {
                    case YNeg: {
                        return Side.XNeg;
                    }
                    case YPos: {
                        return Side.XPos;
                    }
                    case XNeg: {
                        return Side.YPos;
                    }
                    case XPos: {
                        return Side.YNeg;
                    }
                }
                return side;
            }
        }
        return side;
    }

    private static Axis getWoodAxis(Side side, int metadata) {
        int orient = (metadata & 0xC) >> 2;
        switch (orient) {
            case 1: {
                return Axis.X;
            }
            case 2: {
                return Axis.Z;
            }
        }
        return Axis.Y;
    }

    private static Axis getQuartzAxis(Side side, int metadata) {
        switch (metadata) {
            case 3: {
                return Axis.X;
            }
            case 4: {
                return Axis.Z;
            }
        }
        return Axis.Y;
    }

    private static IIcon getConnectedTextureRandom(CTMInfo info, IBlockAccess blockAccess, Block block, int x, int y, int z, @Nullable Side side) {
        if (info.tileIcons.length == 1) {
            return info.tileIcons[0];
        }
        Side face = info.symmetry().apply(side);
        if (info.linked) {
            int yDown = y - 1;
            Block blockDown = blockAccess.func_147439_a(x, yDown, z);
            while (blockDown == block) {
                y = yDown--;
                if (yDown < 0) break;
                blockDown = blockAccess.func_147439_a(x, yDown, z);
            }
        }
        int rand = CTMEngine.getRandom(x, y, z, face) & Integer.MAX_VALUE;
        int index = 0;
        index = info.weights() == null ? rand % info.tileIcons.length : info.weights().getIndex(rand) % info.tileIcons.length;
        return info.tileIcons[index];
    }

    private static int getRandom(int x, int y, int z, @NotNull Side face) {
        int rand = MCPMath.intHash(face.ordinal() + 37);
        rand = MCPMath.intHash(rand + x);
        rand = MCPMath.intHash(rand + z);
        return MCPMath.intHash(rand + y);
    }

    private static IIcon getConnectedTextureFixed(CTMInfo info) {
        return info.tileIcons[0];
    }

    private static IIcon getConnectedTextureRepeat(CTMInfo info, int x, int y, int z, @Nullable Side side) {
        if (info.tileIcons.length == 1) {
            return info.tileIcons[0];
        }
        int nx = 0;
        int ny = 0;
        if (side != null) {
            switch (side) {
                case YNeg: 
                case YPos: {
                    nx = x;
                    ny = z;
                    break;
                }
                case ZNeg: {
                    nx = -x - 1;
                    ny = -y;
                    break;
                }
                case ZPos: {
                    nx = x;
                    ny = -y;
                    break;
                }
                case XNeg: {
                    nx = z;
                    ny = -y;
                    break;
                }
                case XPos: {
                    nx = -z - 1;
                    ny = -y;
                }
            }
        }
        ny %= info.height();
        if ((nx %= info.width()) < 0) {
            nx += info.width();
        }
        if (ny < 0) {
            ny += info.height();
        }
        int index = ny * info.width() + nx;
        return info.tileIcons[index];
    }

    private static IIcon getConnectedTextureCtm(CTMInfo info, IBlockAccess blockAccess, Block block, int x, int y, int z, @Nullable Side side, IIcon icon, int metadata) {
        boolean[] borders = new boolean[6];
        if (side != null) {
            switch (side) {
                case YNeg: 
                case YPos: {
                    borders[0] = CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z, side, icon, metadata);
                    borders[1] = CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z, side, icon, metadata);
                    borders[2] = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z + 1, side, icon, metadata);
                    borders[3] = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z - 1, side, icon, metadata);
                    break;
                }
                case ZNeg: {
                    borders[0] = CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z, side, icon, metadata);
                    borders[1] = CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z, side, icon, metadata);
                    borders[2] = CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z, side, icon, metadata);
                    borders[3] = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                    break;
                }
                case ZPos: {
                    borders[0] = CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z, side, icon, metadata);
                    borders[1] = CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z, side, icon, metadata);
                    borders[2] = CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z, side, icon, metadata);
                    borders[3] = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                    break;
                }
                case XNeg: {
                    borders[0] = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z - 1, side, icon, metadata);
                    borders[1] = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z + 1, side, icon, metadata);
                    borders[2] = CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z, side, icon, metadata);
                    borders[3] = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                    break;
                }
                case XPos: {
                    borders[0] = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z + 1, side, icon, metadata);
                    borders[1] = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z - 1, side, icon, metadata);
                    borders[2] = CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z, side, icon, metadata);
                    borders[3] = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                }
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (index == 0) {
            return info.tileIcons[index];
        }
        boolean[] edges = new boolean[6];
        if (side != null) {
            switch (side) {
                case YNeg: 
                case YPos: {
                    edges[0] = !CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z + 1, side, icon, metadata);
                    edges[1] = !CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z + 1, side, icon, metadata);
                    edges[2] = !CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z - 1, side, icon, metadata);
                    edges[3] = !CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z - 1, side, icon, metadata);
                    break;
                }
                case ZNeg: {
                    edges[0] = !CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y - 1, z, side, icon, metadata);
                    edges[1] = !CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y - 1, z, side, icon, metadata);
                    edges[2] = !CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y + 1, z, side, icon, metadata);
                    edges[3] = !CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y + 1, z, side, icon, metadata);
                    break;
                }
                case ZPos: {
                    edges[0] = !CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y - 1, z, side, icon, metadata);
                    edges[1] = !CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y - 1, z, side, icon, metadata);
                    edges[2] = !CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y + 1, z, side, icon, metadata);
                    edges[3] = !CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y + 1, z, side, icon, metadata);
                    break;
                }
                case XNeg: {
                    edges[0] = !CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z + 1, side, icon, metadata);
                    edges[1] = !CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z - 1, side, icon, metadata);
                    edges[2] = !CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z + 1, side, icon, metadata);
                    edges[3] = !CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z - 1, side, icon, metadata);
                    break;
                }
                case XPos: {
                    edges[0] = !CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z - 1, side, icon, metadata);
                    edges[1] = !CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z + 1, side, icon, metadata);
                    edges[2] = !CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z - 1, side, icon, metadata);
                    boolean bl = edges[3] = !CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z + 1, side, icon, metadata);
                }
            }
        }
        if (index == 13 && edges[0]) {
            index = 4;
        } else if (index == 15 && edges[1]) {
            index = 5;
        } else if (index == 37 && edges[2]) {
            index = 16;
        } else if (index == 39 && edges[3]) {
            index = 17;
        } else if (index == 14 && edges[0] && edges[1]) {
            index = 7;
        } else if (index == 25 && edges[0] && edges[2]) {
            index = 6;
        } else if (index == 27 && edges[3] && edges[1]) {
            index = 19;
        } else if (index == 38 && edges[3] && edges[2]) {
            index = 18;
        } else if (index == 14 && !edges[0] && edges[1]) {
            index = 31;
        } else if (index == 25 && edges[0] && !edges[2]) {
            index = 30;
        } else if (index == 27 && !edges[3] && edges[1]) {
            index = 41;
        } else if (index == 38 && edges[3] && !edges[2]) {
            index = 40;
        } else if (index == 14 && edges[0] && !edges[1]) {
            index = 29;
        } else if (index == 25 && !edges[0] && edges[2]) {
            index = 28;
        } else if (index == 27 && edges[3] && !edges[1]) {
            index = 43;
        } else if (index == 38 && !edges[3] && edges[2]) {
            index = 42;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 46;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 9;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 21;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 8;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 20;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 11;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 22;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 23;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 10;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 34;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 35;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && !edges[3]) {
            index = 32;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 33;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 44;
        } else if (index == 26 && !edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 45;
        }
        return info.tileIcons[index];
    }

    private static boolean isNeighbour(CTMInfo info, IBlockAccess iblockaccess, Block block, int x, int y, int z, @Nullable Side side, IIcon icon, int metadata) {
        Block neighbourBlock = iblockaccess.func_147439_a(x, y, z);
        if (info.connect() == Connect.Tile) {
            if (neighbourBlock == null) {
                return false;
            }
            int neighbourMetadata = iblockaccess.func_72805_g(x, y, z);
            IIcon neighbourIcon = side != null ? neighbourBlock.func_149691_a(side.ordinal(), neighbourMetadata) : neighbourBlock.func_149691_a(Side.YPos.ordinal(), neighbourMetadata);
            return neighbourIcon == icon;
        }
        if (info.connect() == Connect.Material) {
            if (neighbourBlock == null) {
                return false;
            }
            return neighbourBlock.func_149688_o() == block.func_149688_o();
        }
        return neighbourBlock == block && iblockaccess.func_72805_g(x, y, z) == metadata;
    }

    private static IIcon getConnectedTextureHorizontal(CTMInfo info, IBlockAccess blockAccess, Block block, int x, int y, int z, Axis vertAxis, @Nullable Side side, IIcon icon, int metadata) {
        boolean left = false;
        boolean right = false;
        if (side != null) {
            block0 : switch (vertAxis) {
                case Y: {
                    switch (side) {
                        case YNeg: 
                        case YPos: {
                            return null;
                        }
                        case ZNeg: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z, side, icon, metadata);
                            break;
                        }
                        case ZPos: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z, side, icon, metadata);
                            break;
                        }
                        case XNeg: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z - 1, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z + 1, side, icon, metadata);
                            break;
                        }
                        case XPos: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z + 1, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z - 1, side, icon, metadata);
                        }
                    }
                    break;
                }
                case Z: {
                    switch (side) {
                        case YNeg: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z, side, icon, metadata);
                            break;
                        }
                        case YPos: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z, side, icon, metadata);
                            break;
                        }
                        case ZNeg: 
                        case ZPos: {
                            return null;
                        }
                        case XNeg: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z, side, icon, metadata);
                            break;
                        }
                        case XPos: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z, side, icon, metadata);
                        }
                    }
                    break;
                }
                case X: {
                    switch (side) {
                        case YNeg: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z - 1, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z + 1, side, icon, metadata);
                            break block0;
                        }
                        case YPos: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z - 1, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z + 1, side, icon, metadata);
                            break block0;
                        }
                        case ZNeg: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z, side, icon, metadata);
                            break block0;
                        }
                        case ZPos: {
                            left = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                            right = CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z, side, icon, metadata);
                            break block0;
                        }
                        case XNeg: 
                        case XPos: {
                            return null;
                        }
                    }
                }
            }
        }
        int index = 3;
        index = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return info.tileIcons[index];
    }

    private static IIcon getConnectedTextureVertical(CTMInfo info, IBlockAccess blockAccess, Block block, int x, int y, int z, Axis vertAxis, @Nullable Side side, IIcon icon, int metadata) {
        boolean bottom = false;
        boolean top = false;
        if (side != null) {
            if (side.axis == vertAxis) {
                return null;
            }
            switch (vertAxis) {
                case Y: {
                    bottom = CTMEngine.isNeighbour(info, blockAccess, block, x, y - 1, z, side, icon, metadata);
                    top = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                    break;
                }
                case Z: {
                    bottom = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z - 1, side, icon, metadata);
                    top = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z + 1, side, icon, metadata);
                    break;
                }
                case X: {
                    bottom = CTMEngine.isNeighbour(info, blockAccess, block, x - 1, y, z, side, icon, metadata);
                    top = CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z, side, icon, metadata);
                }
            }
        }
        int index = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return info.tileIcons[index];
    }

    private static IIcon getConnectedTextureHorizontalVertical(CTMInfo info, IBlockAccess blockAccess, Block block, int x, int y, int z, Axis vertAxis, @Nullable Side side, IIcon icon, int metadata) {
        IIcon[] tileIcons = info.tileIcons;
        IIcon iconH = CTMEngine.getConnectedTextureHorizontal(info, blockAccess, block, x, y, z, vertAxis, side, icon, metadata);
        if (iconH != null && iconH != icon && iconH != tileIcons[3]) {
            return iconH;
        }
        IIcon iconV = CTMEngine.getConnectedTextureVertical(info, blockAccess, block, x, y, z, vertAxis, side, icon, metadata);
        if (iconV == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconV == tileIcons[1]) {
            return tileIcons[5];
        }
        return iconV == tileIcons[2] ? tileIcons[6] : iconV;
    }

    private static IIcon getConnectedTextureVerticalHorizontal(CTMInfo info, IBlockAccess blockAccess, Block block, int x, int y, int z, Axis vertAxis, @Nullable Side side, IIcon icon, int metadata) {
        IIcon[] tileIcons = info.tileIcons;
        IIcon iconV = CTMEngine.getConnectedTextureVertical(info, blockAccess, block, x, y, z, vertAxis, side, icon, metadata);
        if (iconV != null && iconV != icon && iconV != tileIcons[3]) {
            return iconV;
        }
        IIcon iconH = CTMEngine.getConnectedTextureHorizontal(info, blockAccess, block, x, y, z, vertAxis, side, icon, metadata);
        if (iconH == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconH == tileIcons[1]) {
            return tileIcons[5];
        }
        return iconH == tileIcons[2] ? tileIcons[6] : iconH;
    }

    private static IIcon getConnectedTextureTop(CTMInfo info, IBlockAccess blockAccess, Block block, int x, int y, int z, Axis vertAxis, @Nullable Side side, IIcon icon, int metadata) {
        boolean top = false;
        if (side != null) {
            if (side.axis == vertAxis) {
                return null;
            }
            switch (vertAxis) {
                case Y: {
                    top = CTMEngine.isNeighbour(info, blockAccess, block, x, y + 1, z, side, icon, metadata);
                    break;
                }
                case Z: {
                    top = CTMEngine.isNeighbour(info, blockAccess, block, x, y, z + 1, side, icon, metadata);
                    break;
                }
                case X: {
                    top = CTMEngine.isNeighbour(info, blockAccess, block, x + 1, y, z, side, icon, metadata);
                }
            }
        }
        return top ? info.tileIcons[0] : null;
    }

    public static void updateIcons(TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay) {
        blockProperties.clear();
        tileProperties.clear();
        List<IResourcePack> packs = ResourceScanner.resourcePacks();
        for (IResourcePack pack : packs) {
            if (pack == null) continue;
            CTMEngine.updateIcons(textureMap, pack, overlay);
        }
    }

    private static void updateIcons(TextureMap textureMap, @NotNull IResourcePack pack, @Nullable Map<ResourceLocation, ResourceGenerator> overlay) {
        ObjectList<String> names = ResourceScanner.collectFiles(pack, "mcpatcher/ctm/", ".properties", false);
        names.sort(Comparator.naturalOrder());
        for (String name : names) {
            LOG.debug("ConnectedTextures: {}", new Object[]{name});
            try {
                CTMInfo info;
                ResourceLocation locFile = new ResourceLocation(name);
                InputStream in = pack.func_110590_a(locFile);
                if (in == null) {
                    LOG.warn("ConnectedTextures file not found: {}", new Object[]{name});
                    continue;
                }
                Properties props = new Properties();
                props.load(in);
                String def = props.getProperty("ft_default");
                if (def != null && !ResourceScanner.isFromDefaultResourcePack(new ResourceLocation(def)) || !(info = new CTMInfo(props, name)).isValid(name)) continue;
                info.updateIcons(textureMap, overlay);
                CTMEngine.addToTileMap(info);
                CTMEngine.addToBlockMap(info);
            }
            catch (FileNotFoundException e) {
                LOG.warn("ConnectedTextures file not found: {}", new Object[]{name});
            }
            catch (IOException | RuntimeException e) {
                LOG.warn((Message)new FormattedMessage("Error while loading connected texture: {}", (Object)name), (Throwable)e);
            }
        }
        multipass = CTMEngine.detectMultipass();
        LOG.debug("Multipass connected textures: {}", new Object[]{multipass});
    }

    private static boolean detectMultipass() {
        ObjectArrayList props = new ObjectArrayList();
        for (ObjectList infos : tileProperties) {
            if (infos == null) continue;
            props.addAll(infos);
        }
        for (ObjectList infos : blockProperties.values()) {
            if (infos == null) continue;
            props.addAll(infos);
        }
        ObjectOpenHashSet matchIcons = new ObjectOpenHashSet();
        ObjectOpenHashSet tileIcons = new ObjectOpenHashSet();
        for (CTMInfo info : props) {
            if (info.matchTileIcons != null) {
                matchIcons.addAll(Arrays.asList(info.matchTileIcons));
            }
            if (info.tileIcons == null) continue;
            tileIcons.addAll(Arrays.asList(info.tileIcons));
        }
        matchIcons.retainAll((Collection)tileIcons);
        return !matchIcons.isEmpty();
    }

    private static void addToTileMap(CTMInfo info) {
        if (info.matchTileIcons != null) {
            for (IIcon icon : info.matchTileIcons) {
                if (!(icon instanceof TextureAtlasSprite)) {
                    LOG.warn("IIcon is not TextureAtlasSprite: {}, name: {}", new Object[]{icon, icon.func_94215_i()});
                    continue;
                }
                TextureAtlasSprite ts = (TextureAtlasSprite)icon;
                int tileId = ((ICTMSprite)ts).mcp$indexInMap();
                if (tileId < 0) {
                    LOG.warn("Invalid tile ID: {}, icon: {}", new Object[]{tileId, ts.func_94215_i()});
                    continue;
                }
                CTMEngine.addToTileMap(info, tileId);
            }
        }
    }

    private static void addToBlockMap(CTMInfo info) {
        ObjectList<Block> mb = info.matchBlocks();
        if (mb != null) {
            for (Block block : mb) {
                if (block == null) continue;
                CTMEngine.addToBlockMap(info, block);
            }
        }
    }

    private static void addToBlockMap(CTMInfo info, Block id) {
        ObjectList subList = (ObjectList)blockProperties.get((Object)id);
        if (subList == null) {
            subList = new ObjectArrayList();
            blockProperties.put((Object)id, (Object)subList);
        }
        subList.add((Object)info);
    }

    private static void addToTileMap(CTMInfo info, int id) {
        while (id >= tileProperties.size()) {
            tileProperties.add(null);
        }
        ObjectList subList = (ObjectList)tileProperties.get(id);
        if (subList == null) {
            subList = new ObjectArrayList();
            tileProperties.set(id, (Object)subList);
        }
        subList.add((Object)info);
    }
}

