/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.common;

import com.falsepattern.mcpatcher.internal.modules.common.IntRange;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import lombok.Generated;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonParser {
    public static final Logger LOG = LogManager.getLogger((String)"Right Proper MCPatcher Parser");
    public static final long PARSE_SENTINEL_VALUE = 0xFF00000000L;

    private CommonParser() {
        throw new AssertionError((Object)"Utility class");
    }

    public static int parseInt(@Nullable String str) {
        return CommonParser.parseInt(str, -1);
    }

    public static int parseInt(@Nullable String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        if (str.startsWith("(") && str.endsWith(")")) {
            str = str.substring(1, str.length() - 1);
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ignored) {
            return defVal;
        }
    }

    public static long parseIntSentinel(@NotNull String str) {
        if (str.startsWith("(") && str.endsWith(")")) {
            str = str.substring(1, str.length() - 1);
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ignored) {
            return 0xFF00000000L;
        }
    }

    public static float parseFloat(@Nullable String str, float defVal) {
        if (str == null) {
            return defVal;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException ignored) {
            return defVal;
        }
    }

    public static boolean parseBoolean(@Nullable String str) {
        return CommonParser.parseBoolean(str, false);
    }

    public static boolean parseBoolean(@Nullable String str, boolean def) {
        return str != null ? str.equalsIgnoreCase("true") : def;
    }

    @Contract(value="!null -> !null; null -> null")
    @Nullable
    public static IntList parseInts(@Nullable String str, int minBound, int maxBound) {
        String[] intStrs;
        if (str == null) {
            return null;
        }
        IntArrayList list = new IntArrayList();
        for (String intStr : intStrs = StringUtils.split((String)str, (String)" ,")) {
            long max;
            TokenizedRange range = CommonParser.tokenizeRange(intStr);
            if (range == null) {
                LOG.warn("when parsing: {}", new Object[]{str});
                continue;
            }
            long min = range.start != null ? CommonParser.parseIntSentinel(range.start) : (long)minBound;
            long l = max = range.end != null ? CommonParser.parseIntSentinel(range.end) : (long)maxBound;
            if (min != 0xFF00000000L && max != 0xFF00000000L && min <= max) {
                int n = (int)min;
                while ((long)n <= max) {
                    list.add(n);
                    ++n;
                }
                continue;
            }
            LOG.warn("Invalid inverval: {}, when parsing: {}", new Object[]{intStr, str});
        }
        return list;
    }

    public static @Nullable IntRange.List parseIntRanges(@Nullable String str) {
        String[] parts;
        if (str == null) {
            return null;
        }
        IntRange.List list = new IntRange.List();
        for (String part : parts = StringUtils.split((String)str, (String)" ,")) {
            IntRange ri = CommonParser.parseIntRange(part);
            if (ri == null) {
                return null;
            }
            list.add(ri);
        }
        return list;
    }

    @Nullable
    public static IntRange parseIntRange(@Nullable String str) {
        long max;
        if (str == null) {
            return null;
        }
        TokenizedRange range = CommonParser.tokenizeRange(str);
        if (range == null) {
            return null;
        }
        long min = range.start != null ? CommonParser.parseIntSentinel(range.start) : Integer.MIN_VALUE;
        long l = max = range.end != null ? CommonParser.parseIntSentinel(range.end) : Integer.MAX_VALUE;
        if (min != 0xFF00000000L && max != 0xFF00000000L) {
            return new IntRange((int)min, (int)max);
        }
        LOG.warn("Invalid range: {}", new Object[]{str});
        return null;
    }

    @Nullable
    private static TokenizedRange tokenizeRange(String str) {
        String start = null;
        String end = null;
        int len = str.length();
        boolean inParen = false;
        boolean preDash = true;
        int dashOffset = -1;
        block5: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '(': {
                    if (inParen) {
                        LOG.warn("Nested parentheses are not supported: {}", new Object[]{str});
                        return null;
                    }
                    inParen = true;
                    continue block5;
                }
                case ')': {
                    if (!inParen) {
                        LOG.warn("Closing ) without a matching (: {}", new Object[]{str});
                        return null;
                    }
                    inParen = false;
                    continue block5;
                }
                case '-': {
                    if (inParen) continue block5;
                    if (!preDash) {
                        LOG.warn("Multiple - separators: {}", new Object[]{str});
                        return null;
                    }
                    dashOffset = i + 1;
                    if (i == 0) continue block5;
                    start = str.substring(0, i);
                    continue block5;
                }
            }
        }
        if (dashOffset == -1) {
            return new TokenizedRange(str, str);
        }
        if (dashOffset < len) {
            end = str.substring(dashOffset, len);
        }
        return new TokenizedRange(start, end);
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static ObjectList<BiomeGenBase> parseBiomes(@Nullable String str) {
        if (str == null) {
            return null;
        }
        String[] biomeNames = StringUtils.split((String)str);
        ObjectArrayList list = new ObjectArrayList();
        for (String biomeName : biomeNames) {
            BiomeGenBase biome = CommonParser.findBiome(biomeName);
            if (biome == null) {
                LOG.warn("Biome not found: {}", new Object[]{biomeName});
                continue;
            }
            list.add((Object)biome);
        }
        return list;
    }

    @Nullable
    public static BiomeGenBase findBiome(@NotNull String biomeName) {
        BiomeGenBase[] biomeList;
        biomeName = biomeName.toLowerCase();
        for (BiomeGenBase biome : biomeList = BiomeGenBase.func_150565_n()) {
            String name;
            if (biome == null || !(name = biome.field_76791_y.replace(" ", "").toLowerCase()).equals(biomeName)) continue;
            return biome;
        }
        return null;
    }

    private static class TokenizedRange {
        public final String start;
        public final String end;

        @Generated
        public TokenizedRange(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }
}

