/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.common;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class CollectionUtil {
    private CollectionUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static <K> @UnmodifiableView ObjectList<K> lockList(@Nullable ObjectList<K> list) {
        if (list instanceof ObjectLists.EmptyList) {
            return list;
        }
        if (list instanceof ObjectLists.UnmodifiableList) {
            return list;
        }
        if (list instanceof ObjectLists.Singleton) {
            return list;
        }
        if (list == null || list.isEmpty()) {
            return ObjectLists.emptyList();
        }
        if (list.size() == 1) {
            return ObjectLists.singleton((Object)list.get(0));
        }
        return ObjectLists.unmodifiable(list);
    }

    @NotNull
    public static <K> @UnmodifiableView ObjectSet<K> lockSet(@Nullable ObjectSet<K> set) {
        if (set instanceof ObjectSets.EmptySet) {
            return set;
        }
        if (set instanceof ObjectSets.UnmodifiableSet) {
            return set;
        }
        if (set instanceof ObjectSets.Singleton) {
            return set;
        }
        if (set == null || set.isEmpty()) {
            return ObjectSets.emptySet();
        }
        if (set.size() == 1) {
            return ObjectSets.singleton((Object)set.iterator().next());
        }
        return ObjectSets.unmodifiable(set);
    }

    @NotNull
    public static <K, V> @UnmodifiableView Object2ObjectMap<K, V> lockMap(@Nullable Object2ObjectMap<K, V> map) {
        if (map instanceof Object2ObjectMaps.EmptyMap) {
            return map;
        }
        if (map instanceof Object2ObjectMaps.UnmodifiableMap) {
            return map;
        }
        if (map instanceof Object2ObjectMaps.Singleton) {
            return map;
        }
        if (map == null || map.isEmpty()) {
            return Object2ObjectMaps.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry entry = (Map.Entry)map.entrySet().iterator().next();
            return Object2ObjectMaps.singleton(entry.getKey(), entry.getValue());
        }
        return Object2ObjectMaps.unmodifiable(map);
    }
}

