/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.cit;

import com.falsepattern.mcpatcher.internal.modules.cit.CITParser;
import com.falsepattern.mcpatcher.internal.modules.cit.DamageRangeList;
import com.falsepattern.mcpatcher.internal.modules.common.NBTRule;
import com.falsepattern.mcpatcher.internal.modules.overlay.ResourceGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CITPropsSingle
implements Comparable<CITPropsSingle> {
    protected final String name;
    @Nullable
    protected final String texture;
    protected final Object2ObjectMap<String, String> altTextures;
    protected final int weight;
    protected final ObjectSet<Item> items;
    @Nullable
    protected final DamageRangeList damage;
    protected final int damageMask;
    protected final  @Nullable IntRange.List stackSize;
    protected final  @Nullable IntRange.List enchantmentIDs;
    protected final  @Nullable IntRange.List enchantmentLevels;
    protected final @Unmodifiable ObjectList<NBTRule> nbtRules;

    public CITPropsSingle(String name, Properties props) {
        this.name = name;
        this.texture = CITParser.parseTexture(name, props);
        this.altTextures = CITParser.parseAltTextures(name, props);
        this.weight = CITParser.parseWeight(props);
        this.items = CITParser.parseItems(props);
        this.damage = CITParser.parseDamage(props);
        this.damageMask = CITParser.parseDamageMask(props);
        this.stackSize = CITParser.parseStackSize(props);
        this.enchantmentIDs = CITParser.parseEnchantmentIDs(props);
        this.enchantmentLevels = CITParser.parseEnchantmentLevels(props);
        this.nbtRules = CITParser.parseNbtRules(props);
    }

    public abstract boolean isValid();

    public abstract void load(TextureMap var1, @Nullable Map<ResourceLocation, ResourceGenerator> var2);

    public abstract boolean shouldKeep();

    public boolean matches(ItemStack itemStack) {
        return this.matchDamage(itemStack) && this.matchStackSize(itemStack) && this.matchNbtRules(itemStack) && this.matchEnchantments(itemStack);
    }

    protected boolean matchDamage(ItemStack itemStack) {
        if (this.damage == null) {
            return true;
        }
        return this.damage.isInRange(itemStack, this.damageMask);
    }

    protected boolean matchStackSize(ItemStack itemStack) {
        if (this.stackSize == null) {
            return true;
        }
        return this.stackSize.isInRange(itemStack.field_77994_a);
    }

    protected boolean matchNbtRules(ItemStack itemStack) {
        if (this.nbtRules.isEmpty()) {
            return true;
        }
        for (NBTRule nbtRule : this.nbtRules) {
            if (nbtRule.match(itemStack.field_77990_d)) continue;
            return false;
        }
        return true;
    }

    protected boolean matchEnchantments(ItemStack itemStack) {
        if (this.enchantmentIDs == null && this.enchantmentLevels == null) {
            return true;
        }
        List<NBTTagCompound> enchantList = CITPropsSingle.getEnchantList(itemStack);
        if (enchantList == null) {
            return false;
        }
        for (NBTTagCompound enchant : enchantList) {
            try {
                short level;
                short id;
                if (this.enchantmentIDs != null && !this.enchantmentIDs.isInRange(id = enchant.func_74765_d("id"))) {
                    return false;
                }
                if (this.enchantmentLevels == null || this.enchantmentLevels.isInRange(level = enchant.func_74765_d("lvl"))) continue;
                return false;
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(@NotNull CITPropsSingle other) {
        int comp = Integer.compare(other.weight, this.weight);
        if (comp != 0) {
            return comp;
        }
        return this.name.compareTo(other.name);
    }

    @Nullable
    private static List<NBTTagCompound> getEnchantList(ItemStack itemStack) {
        NBTTagCompound itemNbt = itemStack.field_77990_d;
        if (itemNbt == null) {
            return null;
        }
        NBTBase enchantNbt = itemStack.func_77973_b() == Items.field_151134_bR ? itemNbt.func_74781_a("StoredEnchantments") : itemNbt.func_74781_a("ench");
        if (enchantNbt instanceof NBTTagList) {
            return ((NBTTagList)enchantNbt).field_74747_a;
        }
        return null;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Nullable
    @Generated
    public String texture() {
        return this.texture;
    }

    @Generated
    public Object2ObjectMap<String, String> altTextures() {
        return this.altTextures;
    }

    @Generated
    public int weight() {
        return this.weight;
    }

    @Generated
    public ObjectSet<Item> items() {
        return this.items;
    }

    @Nullable
    @Generated
    public DamageRangeList damage() {
        return this.damage;
    }

    @Generated
    public int damageMask() {
        return this.damageMask;
    }

    @Generated
    public  @Nullable IntRange.List stackSize() {
        return this.stackSize;
    }

    @Generated
    public  @Nullable IntRange.List enchantmentIDs() {
        return this.enchantmentIDs;
    }

    @Generated
    public  @Nullable IntRange.List enchantmentLevels() {
        return this.enchantmentLevels;
    }

    @Generated
    public ObjectList<NBTRule> nbtRules() {
        return this.nbtRules;
    }
}

