/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.cit;

import com.falsepattern.mcpatcher.internal.modules.cit.CITEngine;
import com.falsepattern.mcpatcher.internal.modules.cit.CITPropsSingle;
import com.falsepattern.mcpatcher.internal.modules.common.CollectionUtil;
import com.falsepattern.mcpatcher.internal.modules.common.ResourceScanner;
import com.falsepattern.mcpatcher.internal.modules.overlay.ResourceGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class CITPropsArmor
extends CITPropsSingle {
    @Nullable
    private ResourceLocation texLoc = null;
    private @Unmodifiable @Nullable Object2ObjectMap<ResourceLocation, ResourceLocation> altTexLoc = null;

    public CITPropsArmor(String name, Properties props) {
        super(name, props);
    }

    public ResourceLocation getTexture(ResourceLocation original) {
        ResourceLocation replacement = this.altTexLoc != null ? (ResourceLocation)this.altTexLoc.getOrDefault((Object)original, (Object)this.texLoc) : this.texLoc;
        if (replacement != null) {
            return replacement;
        }
        return original;
    }

    @Override
    public boolean isValid() {
        if (this.items.isEmpty()) {
            CITEngine.LOG.warn("No valid items defined for: {}", new Object[]{this.name});
            return false;
        }
        if (this.texture == null && this.altTextures.isEmpty()) {
            CITEngine.LOG.warn("No valid textures defined for: {}", new Object[]{this.name});
            return false;
        }
        return true;
    }

    @Override
    public void load(TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay) {
        this.texLoc = this.texture == null ? null : new ResourceLocation(this.texture + ".png");
        if (this.altTextures.isEmpty()) {
            this.altTexLoc = null;
        } else {
            this.altTexLoc = new Object2ObjectOpenHashMap();
            for (Map.Entry entry : this.altTextures.entrySet()) {
                String srcName = (String)entry.getKey();
                String dstName = (String)entry.getValue();
                ResourceLocation src = new ResourceLocation("textures/models/armor/" + srcName + ".png");
                if (!ResourceScanner.hasResource(src)) continue;
                ResourceLocation dst = new ResourceLocation(dstName + ".png");
                this.altTexLoc.put((Object)src, (Object)dst);
                this.altTexLoc.put((Object)dst, (Object)dst);
            }
            this.altTexLoc = this.altTexLoc.isEmpty() ? null : CollectionUtil.lockMap(this.altTexLoc);
        }
    }

    @Override
    public boolean shouldKeep() {
        return this.texLoc != null || this.altTexLoc != null;
    }
}

