/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.modules.cit;

import com.falsepattern.mcpatcher.internal.modules.cit.CITParticleHandler;
import com.falsepattern.mcpatcher.internal.modules.cit.CITPropsArmor;
import com.falsepattern.mcpatcher.internal.modules.cit.CITPropsGlobal;
import com.falsepattern.mcpatcher.internal.modules.cit.CITPropsItem;
import com.falsepattern.mcpatcher.internal.modules.cit.CITPropsSingle;
import com.falsepattern.mcpatcher.internal.modules.common.CollectionUtil;
import com.falsepattern.mcpatcher.internal.modules.common.Identity2ObjectHashMap;
import com.falsepattern.mcpatcher.internal.modules.common.ResourceScanner;
import com.falsepattern.mcpatcher.internal.modules.overlay.ResourceGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.lwjgl.opengl.GL11;

public final class CITEngine {
    static final Logger LOG = LogManager.getLogger((String)"Right Proper MCPatcher CIT");
    private static CITPropsGlobal globalProps = new CITPropsGlobal();
    private static @Unmodifiable Object2ObjectMap<Item, ObjectList<CITPropsItem>> itemProps = Object2ObjectMaps.emptyMap();
    private static @Unmodifiable Object2ObjectMap<Item, ObjectList<CITPropsArmor>> armorProps = Object2ObjectMaps.emptyMap();

    private CITEngine() {
        throw new UnsupportedOperationException();
    }

    public static void reloadResources() {
        LOG.debug("Reloading Resources");
        CITParticleHandler.reset();
        try {
            IResource res = ResourceScanner.getResource(new ResourceLocation("minecraft:mcpatcher/cit/cit.properties"));
            Properties props = new Properties();
            props.load(res.func_110527_b());
            globalProps = new CITPropsGlobal(props);
            LOG.debug("Loaded custom cit.properties");
        }
        catch (IOException e) {
            globalProps = new CITPropsGlobal();
            LOG.debug("Loaded default cit.properties");
        }
    }

    public static void updateIcons(@NotNull TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay) {
        LOG.debug("Updating Icons");
        itemProps = new Identity2ObjectHashMap();
        armorProps = new Identity2ObjectHashMap();
        List<IResourcePack> packs = ResourceScanner.resourcePacks();
        for (IResourcePack pack : packs) {
            if (pack == null) continue;
            CITEngine.updateIcons(textureMap, overlay, pack);
        }
        itemProps = CITEngine.lockMapRecursive(itemProps);
        armorProps = CITEngine.lockMapRecursive(armorProps);
    }

    private static void updateIcons(@NotNull TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay, @NotNull IResourcePack pack) {
        ObjectList<String> names = ResourceScanner.collectFiles(pack, "mcpatcher/cit/", ".properties", false);
        names.sort(Comparator.naturalOrder());
        for (String name : names) {
            if (name.endsWith("cit.properties")) continue;
            LOG.debug("CustomItemTextures: {}", new Object[]{name});
            try {
                String type;
                ResourceLocation loc = new ResourceLocation(name);
                InputStream is = pack.func_110590_a(loc);
                if (is == null) {
                    throw new FileNotFoundException(name);
                }
                Properties props = new Properties();
                props.load(is);
                switch (type = props.getProperty("type", "item")) {
                    case "item": {
                        CITEngine.addItemInfo(textureMap, overlay, name, props);
                        break;
                    }
                    case "enchantment": 
                    case "overlay": {
                        LOG.warn("type={} not implemented!", new Object[]{type});
                        CITEngine.addEnchantmentInfo(textureMap, overlay, name, props);
                        break;
                    }
                    case "armor": {
                        CITEngine.addArmorInfo(textureMap, overlay, name, props);
                        break;
                    }
                    default: {
                        LOG.warn("Invalid [type={}] for: {}", new Object[]{type, name});
                        break;
                    }
                }
            }
            catch (FileNotFoundException e) {
                LOG.warn("ConnectedTextures file not found: {}", new Object[]{name});
            }
            catch (IOException | RuntimeException e) {
                LOG.warn((Message)new FormattedMessage("Error while loading custom item texture: {}", (Object)name), (Throwable)e);
            }
        }
    }

    private static void addItemInfo(@NotNull TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay, @NotNull String name, @NotNull Properties props) {
        CITPropsItem citProps = new CITPropsItem(name, props);
        if (!citProps.isValid()) {
            return;
        }
        citProps.load(textureMap, overlay);
        if (!citProps.shouldKeep()) {
            return;
        }
        ObjectSet<Item> items = citProps.items();
        for (Item item : items) {
            ((ObjectList)itemProps.computeIfAbsent((Object)item, key -> new ObjectArrayList())).add((Object)citProps);
        }
    }

    private static void addEnchantmentInfo(@NotNull TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay, @NotNull String name, @NotNull Properties props) {
    }

    private static void addArmorInfo(@NotNull TextureMap textureMap, @Nullable Map<ResourceLocation, ResourceGenerator> overlay, @NotNull String name, @NotNull Properties props) {
        CITPropsArmor citProps = new CITPropsArmor(name, props);
        if (!citProps.isValid()) {
            return;
        }
        citProps.load(textureMap, overlay);
        if (!citProps.shouldKeep()) {
            return;
        }
        ObjectSet<Item> items = citProps.items();
        for (Item item : items) {
            ((ObjectList)armorProps.computeIfAbsent((Object)item, key -> new ObjectArrayList())).add((Object)citProps);
        }
    }

    private static <T extends CITPropsSingle> @Unmodifiable Object2ObjectMap<Item, ObjectList<T>> lockMapRecursive(Object2ObjectMap<Item, ObjectList<T>> map) {
        Identity2ObjectHashMap temp = new Identity2ObjectHashMap();
        for (Map.Entry entry : map.entrySet()) {
            Item item = (Item)entry.getKey();
            ObjectList infos = (ObjectList)entry.getValue();
            if (infos.isEmpty()) continue;
            infos.sort(CITPropsSingle::compareTo);
            temp.put(item, CollectionUtil.lockList(infos));
        }
        return CollectionUtil.lockMap(temp);
    }

    public static IIcon replaceIcon(@Nullable ItemStack itemStack, @Nullable IIcon original) {
        if (itemProps.isEmpty()) {
            return original;
        }
        if (itemStack == null || original == null) {
            return original;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return original;
        }
        ObjectList list = (ObjectList)itemProps.get((Object)item);
        if (list == null) {
            return original;
        }
        for (CITPropsItem info : list) {
            if (!info.matches(itemStack)) continue;
            return info.getIcon(original);
        }
        return original;
    }

    public static ResourceLocation replaceArmorTexture(ItemStack itemStack, ResourceLocation original) {
        if (armorProps.isEmpty()) {
            return original;
        }
        if (itemStack == null || original == null) {
            return original;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return original;
        }
        ObjectList list = (ObjectList)armorProps.get((Object)item);
        if (list == null) {
            return original;
        }
        for (CITPropsArmor info : list) {
            if (!info.matches(itemStack)) continue;
            return info.getTexture(original);
        }
        return original;
    }

    public static boolean renderArmorGlint(EntityLivingBase entity, ItemStack itemStack, float partialTick, Runnable renderFn) {
        float f8 = (float)entity.field_70173_aa + partialTick;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/misc/enchanted_item_glint.png"));
        GL11.glEnable((int)3042);
        float f9 = 0.5f;
        GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glDepthFunc((int)514);
        GL11.glDepthMask((boolean)false);
        for (int k = 0; k < 2; ++k) {
            GL11.glDisable((int)2896);
            float f10 = 0.76f;
            GL11.glColor4f((float)0.38f, (float)0.19f, (float)0.608f, (float)1.0f);
            GL11.glBlendFunc((int)768, (int)1);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            float f11 = f8 * (0.001f + (float)k * 0.003f) * 20.0f;
            float f12 = 0.33333334f;
            GL11.glScalef((float)f12, (float)f12, (float)f12);
            GL11.glRotatef((float)(30.0f - (float)k * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)f11, (float)0.0f);
            GL11.glMatrixMode((int)5888);
            renderFn.run();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glMatrixMode((int)5890);
        GL11.glDepthMask((boolean)true);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDepthFunc((int)515);
        return true;
    }
}

