/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.mcpatcher.internal.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class CITIconReplacementInjector
implements IClassTransformer {
    private static final String NAME_GET_ICON_INDEX_DEOBF = "getIconIndex";
    private static final String NAME_GET_ICON_INDEX_OBF = "func_77650_f";
    private static final String NAME_GET_ICON = "getIcon";
    private static final String DESC_GET_ICON_INDEX = "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/util/IIcon;";
    private static final String DESC_GET_ICON_0 = "(Lnet/minecraft/item/ItemStack;I)Lnet/minecraft/util/IIcon;";
    private static final String DESC_GET_ICON_1 = "(Lnet/minecraft/item/ItemStack;ILnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;I)Lnet/minecraft/util/IIcon;";
    private static final String NAME_GET_ICON_INDEX_RENAMED = "mcp$renamed$getIconIndex";
    private static final String NAME_GET_ICON_RENAMED = "mcp$renamed$getIcon";
    private static final MethodDecl DECL_GET_ICON_INDEX_DEOBF = new MethodDecl("getIconIndex", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/util/IIcon;");
    private static final MethodDecl DECL_GET_ICON_INDEX_OBF = new MethodDecl("func_77650_f", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/util/IIcon;");
    private static final MethodDecl DECL_GET_ICON_0 = new MethodDecl("getIcon", "(Lnet/minecraft/item/ItemStack;I)Lnet/minecraft/util/IIcon;");
    private static final MethodDecl DECL_GET_ICON_1 = new MethodDecl("getIcon", "(Lnet/minecraft/item/ItemStack;ILnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;I)Lnet/minecraft/util/IIcon;");
    private static final MethodDecl[] POTENTIAL_CANDIDATES = new MethodDecl[]{DECL_GET_ICON_INDEX_DEOBF, DECL_GET_ICON_INDEX_OBF, DECL_GET_ICON_0, DECL_GET_ICON_1};
    private static final int POTENTIAL_CANDIDATE_COUNT = POTENTIAL_CANDIDATES.length;
    private static final Map<MethodDecl, String> MAPPINGS = new HashMap<MethodDecl, String>();
    private static final String INTERNAL_ITEM = "net/minecraft/item/Item";
    private static final String ITEM = "net.minecraft.item.Item";
    private static final Map<String, Boolean> ITEM_SUBCLASS_MEMOIZATION;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || transformedName.equals(ITEM)) {
            return basicClass;
        }
        if (!CITIconReplacementInjector.isItemSubclass(transformedName.replace('.', '/'))) {
            return basicClass;
        }
        ClassNode cn = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)cn, 0);
        if (!CITIconReplacementInjector.isValidTarget(cn)) {
            return basicClass;
        }
        boolean modified = false;
        int methodCount = cn.methods.size();
        block0: for (int i = 0; i < methodCount; ++i) {
            MethodNode method = (MethodNode)cn.methods.get(i);
            for (Map.Entry<MethodDecl, String> mapping : MAPPINGS.entrySet()) {
                if (!CITIconReplacementInjector.tryTransform(cn, method, mapping.getKey(), mapping.getValue())) continue;
                modified = true;
                continue block0;
            }
        }
        if (modified) {
            ClassWriter writer = new ClassWriter(0);
            cn.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private static boolean tryTransform(ClassNode cn, MethodNode method, MethodDecl decl, String newName) {
        if (!decl.matches(method)) {
            return false;
        }
        method.name = newName;
        block0: for (AbstractInsnNode inst : method.instructions) {
            if (!(inst instanceof MethodInsnNode)) continue;
            MethodInsnNode insnNode = (MethodInsnNode)inst;
            if (!insnNode.owner.equals(cn.name) && !insnNode.owner.equals(cn.superName) && !CITIconReplacementInjector.isItemSubclass(insnNode.owner)) continue;
            for (Map.Entry<MethodDecl, String> mapping : MAPPINGS.entrySet()) {
                if (!mapping.getKey().matches(insnNode)) continue;
                insnNode.name = mapping.getValue();
                continue block0;
            }
        }
        return true;
    }

    private static boolean isItemSubclass(String className) {
        if (className == null) {
            return false;
        }
        Boolean v = ITEM_SUBCLASS_MEMOIZATION.get(className);
        if (v != null) {
            return v;
        }
        if (className.equals(INTERNAL_ITEM)) {
            ITEM_SUBCLASS_MEMOIZATION.put(className, true);
            return true;
        }
        byte[] classBytes = CITIconReplacementInjector.bytesFromInternalName(className);
        if (classBytes == null) {
            ITEM_SUBCLASS_MEMOIZATION.put(className, false);
            return false;
        }
        boolean isc = CITIconReplacementInjector.isItemSubclass(new ClassReader(classBytes).getSuperName());
        ITEM_SUBCLASS_MEMOIZATION.put(className, isc);
        return isc;
    }

    private static boolean isValidTarget(ClassNode cn) {
        int methodCount = cn.methods.size();
        for (int i = 0; i < methodCount; ++i) {
            MethodNode method = (MethodNode)cn.methods.get(i);
            for (int j = 0; j < POTENTIAL_CANDIDATE_COUNT; ++j) {
                if (!POTENTIAL_CANDIDATES[j].matches(method)) continue;
                return true;
            }
        }
        return false;
    }

    private static byte[] bytesFromInternalName(String internalName) {
        LaunchClassLoader classLoader = Launch.classLoader;
        InputStream in = classLoader.getResourceAsStream(internalName + ".class");
        if (in == null) {
            return null;
        }
        try {
            return IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        MAPPINGS.put(DECL_GET_ICON_INDEX_DEOBF, NAME_GET_ICON_INDEX_RENAMED);
        MAPPINGS.put(DECL_GET_ICON_INDEX_OBF, NAME_GET_ICON_INDEX_RENAMED);
        MAPPINGS.put(DECL_GET_ICON_0, NAME_GET_ICON_RENAMED);
        MAPPINGS.put(DECL_GET_ICON_1, NAME_GET_ICON_RENAMED);
        ITEM_SUBCLASS_MEMOIZATION = new HashMap<String, Boolean>(1024, 0.2f);
        ITEM_SUBCLASS_MEMOIZATION.put(INTERNAL_ITEM, true);
    }

    public static final class MethodDecl {
        private final String name;
        private final String desc;

        public boolean matches(MethodNode node) {
            return node.name.equals(this.name) && node.desc.equals(this.desc);
        }

        public boolean matches(MethodInsnNode insnNode) {
            return insnNode.name.equals(this.name) && insnNode.desc.equals(this.desc);
        }

        @Generated
        public MethodDecl(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDesc() {
            return this.desc;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDecl)) {
                return false;
            }
            MethodDecl other = (MethodDecl)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CITIconReplacementInjector.MethodDecl(name=" + this.getName() + ", desc=" + this.getDesc() + ")";
        }
    }
}

