/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.web;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class Json {
    public static String stringifyJson(Object o) {
        StringBuilder sb = new StringBuilder();
        Json.appendJson(o, sb);
        return sb.toString();
    }

    public static void escape(String s, StringBuilder s2) {
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    s2.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    s2.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    s2.append("\\b");
                    continue block10;
                }
                case '\f': {
                    s2.append("\\f");
                    continue block10;
                }
                case '\n': {
                    s2.append("\\n");
                    continue block10;
                }
                case '\r': {
                    s2.append("\\r");
                    continue block10;
                }
                case '\t': {
                    s2.append("\\t");
                    continue block10;
                }
                case '/': {
                    s2.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f') {
                        String ss = Integer.toHexString(ch);
                        s2.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            s2.append('0');
                        }
                        s2.append(ss.toUpperCase());
                        continue block10;
                    }
                    s2.append(ch);
                }
            }
        }
    }

    public static void appendJson(Object o, StringBuilder s) {
        if (o == null) {
            s.append("null");
        } else if (o instanceof Boolean) {
            s.append((Boolean)o != false ? "true" : "false");
        } else if (o instanceof String) {
            s.append("\"");
            Json.escape((String)o, s);
            s.append("\"");
        } else if (o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double) {
            s.append(o.toString());
        } else if (o instanceof Map) {
            Map m = (Map)o;
            s.append("{");
            boolean first = true;
            for (Map.Entry entry : m.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    s.append(",");
                }
                Json.appendJson(entry.getKey(), s);
                s.append(": ");
                Json.appendJson(entry.getValue(), s);
            }
            s.append("}");
        } else if (o instanceof List) {
            List l = (List)o;
            s.append("[");
            int count = 0;
            for (int i = 0; i < l.size(); ++i) {
                if (count++ > 0) {
                    s.append(",");
                }
                Json.appendJson(l.get(i), s);
            }
            s.append("]");
        } else if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            s.append("[");
            int count = 0;
            for (int i = 0; i < length; ++i) {
                if (count++ > 0) {
                    s.append(",");
                }
                Json.appendJson(Array.get(o, i), s);
            }
            s.append("]");
        } else if (o instanceof Object) {
            s.append("{");
            boolean first = true;
            Class<?> c = o.getClass();
            for (Field field : c.getFields()) {
                Object fieldValue;
                if (!Modifier.isPublic(field.getModifiers())) continue;
                String fieldName = field.getName();
                try {
                    fieldValue = field.get(o);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    s.append(",");
                }
                Json.appendJson(fieldName, s);
                s.append(": ");
                Json.appendJson(fieldValue, s);
            }
            s.append("}");
        } else {
            s.append("undefined");
        }
    }
}

