/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class DynmapBufferedImage {
    public BufferedImage buf_img;
    public int[] argb_buf;
    public int width;
    public int height;
    private static Object lock = new Object();
    private static HashMap<Long, LinkedList<DynmapBufferedImage>> imgcache = new HashMap();
    private static final int CACHE_LIMIT = 10;
    private static final int[] band_masks = new int[]{0xFF0000, 65280, 255, -16777216};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynmapBufferedImage allocateBufferedImage(int x, int y) {
        DynmapBufferedImage img = null;
        Object object = lock;
        synchronized (object) {
            long k = (x << 16) + y;
            LinkedList<DynmapBufferedImage> ll = imgcache.get(k);
            if (ll != null) {
                img = ll.poll();
            }
        }
        if (img != null) {
            Arrays.fill(img.argb_buf, 0);
        } else {
            img = new DynmapBufferedImage();
            img.width = x;
            img.height = y;
            img.argb_buf = new int[x * y];
        }
        img.buf_img = DynmapBufferedImage.createBufferedImage(img.argb_buf, img.width, img.height);
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeBufferedImage(DynmapBufferedImage img) {
        img.buf_img.flush();
        img.buf_img = null;
        Object object = lock;
        synchronized (object) {
            long k = (img.width << 16) + img.height;
            LinkedList<DynmapBufferedImage> ll = imgcache.get(k);
            if (ll == null) {
                ll = new LinkedList();
                imgcache.put(k, ll);
            }
            if (ll.size() < 10) {
                ll.add(img);
                img = null;
            }
        }
    }

    public static BufferedImage createBufferedImage(int[] argb_buf, int w, int h) {
        DataBufferInt db = new DataBufferInt(argb_buf, w * h);
        WritableRaster raster = Raster.createPackedRaster(db, w, h, w, band_masks, null);
        ColorModel color_model = ColorModel.getRGBdefault();
        return new BufferedImage(color_model, raster, false, null);
    }
}

