/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.shadow.org.owasp.html;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.dynmap.shadow.org.owasp.html.HtmlChangeListener;
import org.dynmap.shadow.org.owasp.html.HtmlSanitizer;
import org.dynmap.shadow.org.owasp.html.HtmlStreamEventReceiver;

public final class HtmlChangeReporter<T> {
    private final OutputChannel output;
    private final InputChannel<T> input;

    public HtmlChangeReporter(HtmlStreamEventReceiver renderer, HtmlChangeListener<? super T> listener, @Nullable T context) {
        this.output = new OutputChannel(renderer);
        this.input = new InputChannel<T>(this.output, listener, context);
    }

    public void setPolicy(HtmlSanitizer.Policy policy) {
        this.input.policy = policy;
    }

    public HtmlStreamEventReceiver getWrappedRenderer() {
        return this.output;
    }

    public HtmlSanitizer.Policy getWrappedPolicy() {
        return this.input;
    }

    private static final class OutputChannel
    implements HtmlStreamEventReceiver {
        private final HtmlStreamEventReceiver renderer;
        String expectedElementName;
        Set<String> expectedAttrNames = new LinkedHashSet<String>();

        OutputChannel(HtmlStreamEventReceiver renderer) {
            this.renderer = renderer;
        }

        @Override
        public void openDocument() {
            this.renderer.openDocument();
        }

        @Override
        public void closeDocument() {
            this.renderer.closeDocument();
        }

        @Override
        public void openTag(String elementName, List<String> attrs) {
            if (elementName.equals(this.expectedElementName)) {
                this.expectedElementName = null;
            }
            int n = attrs.size();
            for (int i = 0; i < n; i += 2) {
                this.expectedAttrNames.remove(attrs.get(i));
            }
            this.renderer.openTag(elementName, attrs);
        }

        @Override
        public void closeTag(String elementName) {
            this.renderer.closeTag(elementName);
        }

        @Override
        public void text(String text) {
            this.renderer.text(text);
        }
    }

    private static final class InputChannel<T>
    implements HtmlSanitizer.Policy {
        HtmlStreamEventReceiver policy;
        final OutputChannel output;
        final T context;
        final HtmlChangeListener<? super T> listener;
        private static final String[] ZERO_STRINGS = new String[0];

        InputChannel(OutputChannel output, HtmlChangeListener<? super T> listener, @Nullable T context) {
            this.output = output;
            this.context = context;
            this.listener = listener;
        }

        @Override
        public void openDocument() {
            this.policy.openDocument();
        }

        @Override
        public void closeDocument() {
            this.policy.closeDocument();
        }

        @Override
        public void openTag(String elementName, List<String> attrs) {
            this.output.expectedElementName = elementName;
            this.output.expectedAttrNames.clear();
            int n = attrs.size();
            for (int i = 0; i < n; i += 2) {
                this.output.expectedAttrNames.add(attrs.get(i));
            }
            this.policy.openTag(elementName, attrs);
            String discardedElementName = this.output.expectedElementName;
            this.output.expectedElementName = null;
            int nExpected = this.output.expectedAttrNames.size();
            String[] discardedAttrNames = nExpected != 0 && discardedElementName == null ? this.output.expectedAttrNames.toArray(new String[nExpected]) : ZERO_STRINGS;
            this.output.expectedAttrNames.clear();
            if (discardedElementName != null) {
                this.listener.discardedTag(this.context, discardedElementName);
            }
            if (discardedAttrNames.length != 0) {
                this.listener.discardedAttributes(this.context, elementName, discardedAttrNames);
            }
        }

        @Override
        public void closeTag(String elementName) {
            this.policy.closeTag(elementName);
        }

        @Override
        public void text(String textChunk) {
            this.policy.text(textChunk);
        }
    }
}

