/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.shadow.org.eclipse.jetty.util.log;

import java.io.PrintStream;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import org.dynmap.shadow.org.eclipse.jetty.util.DateCache;
import org.dynmap.shadow.org.eclipse.jetty.util.log.AbstractLogger;
import org.dynmap.shadow.org.eclipse.jetty.util.log.Log;
import org.dynmap.shadow.org.eclipse.jetty.util.log.Logger;

public class StdErrLog
extends AbstractLogger {
    private static final String EOL;
    private static DateCache _dateCache;
    private static final Properties __props;
    private static final boolean __source;
    private static final boolean __long;
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARN = 3;
    private int _level = 2;
    private int _configuredLevel;
    private PrintStream _stderr = null;
    private boolean _source = __source;
    private boolean _printLongNames = __long;
    private final String _name;
    private final String _abbrevname;
    private boolean _hideStacks = false;

    public StdErrLog() {
        this(null);
    }

    public StdErrLog(String name) {
        this(name, __props);
    }

    public StdErrLog(String name, Properties props) {
        if (props != null && props != __props) {
            __props.putAll((Map<?, ?>)props);
        }
        this._name = name == null ? "" : name;
        this._abbrevname = StdErrLog.condensePackageString(this._name);
        this._configuredLevel = this._level = StdErrLog.getLoggingLevel(props, this._name);
        try {
            this._source = Boolean.parseBoolean(props.getProperty(this._name + ".SOURCE", Boolean.toString(this._source)));
        }
        catch (AccessControlException ace) {
            this._source = __source;
        }
    }

    public static int getLoggingLevel(Properties props, String name) {
        String nameSegment = name;
        while (nameSegment != null && nameSegment.length() > 0) {
            String levelStr = props.getProperty(nameSegment + ".LEVEL");
            int level = StdErrLog.getLevelId(nameSegment + ".LEVEL", levelStr);
            if (level != -1) {
                return level;
            }
            int idx = nameSegment.lastIndexOf(46);
            if (idx >= 0) {
                nameSegment = nameSegment.substring(0, idx);
                continue;
            }
            nameSegment = null;
        }
        return StdErrLog.getLevelId("log.LEVEL", props.getProperty("log.LEVEL", "INFO"));
    }

    protected static int getLevelId(String levelSegment, String levelName) {
        if (levelName == null) {
            return -1;
        }
        String levelStr = levelName.trim();
        if ("ALL".equalsIgnoreCase(levelStr)) {
            return 0;
        }
        if ("DEBUG".equalsIgnoreCase(levelStr)) {
            return 1;
        }
        if ("INFO".equalsIgnoreCase(levelStr)) {
            return 2;
        }
        if ("WARN".equalsIgnoreCase(levelStr)) {
            return 3;
        }
        System.err.println("Unknown StdErrLog level [" + levelSegment + "]=[" + levelStr + "], expecting only [ALL, DEBUG, INFO, WARN] as values.");
        return -1;
    }

    protected static String condensePackageString(String classname) {
        String[] parts = classname.split("\\.");
        StringBuilder dense = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            dense.append(parts[i].charAt(0));
        }
        if (dense.length() > 0) {
            dense.append('.');
        }
        dense.append(parts[parts.length - 1]);
        return dense.toString();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setPrintLongNames(boolean printLongNames) {
        this._printLongNames = printLongNames;
    }

    public boolean isPrintLongNames() {
        return this._printLongNames;
    }

    public boolean isHideStacks() {
        return this._hideStacks;
    }

    public void setHideStacks(boolean hideStacks) {
        this._hideStacks = hideStacks;
    }

    public boolean isSource() {
        return this._source;
    }

    public void setSource(boolean source) {
        this._source = source;
    }

    @Override
    public void warn(String msg, Object ... args) {
        if (this._level <= 3) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":WARN:", msg, args);
            (this._stderr == null ? System.err : this._stderr).println(buffer);
        }
    }

    @Override
    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    @Override
    public void warn(String msg, Throwable thrown) {
        if (this._level <= 3) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":WARN:", msg, thrown);
            (this._stderr == null ? System.err : this._stderr).println(buffer);
        }
    }

    @Override
    public void info(String msg, Object ... args) {
        if (this._level <= 2) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":INFO:", msg, args);
            (this._stderr == null ? System.err : this._stderr).println(buffer);
        }
    }

    @Override
    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    @Override
    public void info(String msg, Throwable thrown) {
        if (this._level <= 2) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":INFO:", msg, thrown);
            (this._stderr == null ? System.err : this._stderr).println(buffer);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._level <= 1;
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this._level = 1;
            for (Logger log : Log.getLoggers().values()) {
                if (!log.getName().startsWith(this.getName()) || !(log instanceof StdErrLog)) continue;
                ((StdErrLog)log).setLevel(1);
            }
        } else {
            this._level = this._configuredLevel;
            for (Logger log : Log.getLoggers().values()) {
                if (!log.getName().startsWith(this.getName()) || !(log instanceof StdErrLog)) continue;
                ((StdErrLog)log).setLevel(((StdErrLog)log)._configuredLevel);
            }
        }
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int level) {
        this._level = level;
    }

    public void setStdErrStream(PrintStream stream) {
        this._stderr = stream == System.err ? null : stream;
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this._level <= 1) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":DBUG:", msg, args);
            (this._stderr == null ? System.err : this._stderr).println(buffer);
        }
    }

    @Override
    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    @Override
    public void debug(String msg, Throwable thrown) {
        if (this._level <= 1) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":DBUG:", msg, thrown);
            (this._stderr == null ? System.err : this._stderr).println(buffer);
        }
    }

    private void format(StringBuilder buffer, String level, String msg, Object ... args) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        this.tag(buffer, d, ms, level);
        this.format(buffer, msg, args);
    }

    private void format(StringBuilder buffer, String level, String msg, Throwable thrown) {
        this.format(buffer, level, msg, new Object[0]);
        if (this.isHideStacks()) {
            this.format(buffer, String.valueOf(thrown), new Object[0]);
        } else {
            this.format(buffer, thrown);
        }
    }

    private void tag(StringBuilder buffer, String d, int ms, String tag) {
        buffer.setLength(0);
        buffer.append(d);
        if (ms > 99) {
            buffer.append('.');
        } else if (ms > 9) {
            buffer.append(".0");
        } else {
            buffer.append(".00");
        }
        buffer.append(ms).append(tag);
        if (this._printLongNames) {
            buffer.append(this._name);
        } else {
            buffer.append(this._abbrevname);
        }
        buffer.append(':');
        if (this._source) {
            Throwable source = new Throwable();
            StackTraceElement[] frames = source.getStackTrace();
            for (int i = 0; i < frames.length; ++i) {
                StackTraceElement frame = frames[i];
                String clazz = frame.getClassName();
                if (clazz.equals(StdErrLog.class.getName()) || clazz.equals(Log.class.getName())) continue;
                if (!this._printLongNames && clazz.startsWith("org.eclipse.jetty.")) {
                    buffer.append(StdErrLog.condensePackageString(clazz));
                } else {
                    buffer.append(clazz);
                }
                buffer.append('#').append(frame.getMethodName());
                if (frame.getFileName() != null) {
                    buffer.append('(').append(frame.getFileName()).append(':').append(frame.getLineNumber()).append(')');
                }
                buffer.append(':');
                break;
            }
        }
    }

    private void format(StringBuilder builder, String msg, Object ... args) {
        if (msg == null) {
            msg = "";
            for (int i = 0; i < args.length; ++i) {
                msg = msg + "{} ";
            }
        }
        String braces = "{}";
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                this.escape(builder, msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            this.escape(builder, msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        this.escape(builder, msg.substring(start));
    }

    private void escape(StringBuilder builder, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) {
                if (c == '\n') {
                    builder.append('|');
                    continue;
                }
                if (c == '\r') {
                    builder.append('<');
                    continue;
                }
                builder.append('?');
                continue;
            }
            builder.append(c);
        }
    }

    private void format(StringBuilder buffer, Throwable thrown) {
        if (thrown == null) {
            buffer.append("null");
        } else {
            buffer.append(EOL);
            this.format(buffer, thrown.toString(), new Object[0]);
            StackTraceElement[] elements = thrown.getStackTrace();
            for (int i = 0; elements != null && i < elements.length; ++i) {
                buffer.append(EOL).append("\tat ");
                this.format(buffer, elements[i].toString(), new Object[0]);
            }
            Throwable cause = thrown.getCause();
            if (cause != null && cause != thrown) {
                buffer.append(EOL).append("Caused by: ");
                this.format(buffer, cause);
            }
        }
    }

    @Override
    protected Logger newLogger(String fullname) {
        StdErrLog logger = new StdErrLog(fullname);
        logger.setPrintLongNames(this._printLongNames);
        logger.setSource(this._source);
        logger._stderr = this._stderr;
        if (this._level != this._configuredLevel) {
            logger._level = this._level;
        }
        return logger;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("StdErrLog:");
        s.append(this._name);
        s.append(":LEVEL=");
        switch (this._level) {
            case 0: {
                s.append("ALL");
                break;
            }
            case 1: {
                s.append("DEBUG");
                break;
            }
            case 2: {
                s.append("INFO");
                break;
            }
            case 3: {
                s.append("WARN");
                break;
            }
            default: {
                s.append("?");
            }
        }
        return s.toString();
    }

    public static void setProperties(Properties props) {
        __props.clear();
        __props.putAll((Map<?, ?>)props);
    }

    @Override
    public void ignore(Throwable ignored) {
        if (this._level <= 0) {
            StringBuilder buffer = new StringBuilder(64);
            this.format(buffer, ":IGNORED:", "", ignored);
            (this._stderr == null ? System.err : this._stderr).println(buffer);
        }
    }

    static {
        String[] deprecatedProperties;
        EOL = System.getProperty("line.separator");
        __props = new Properties();
        __source = Boolean.parseBoolean(Log.__props.getProperty("org.dynmap.shadow.org.eclipse.jetty.util.log.SOURCE", Log.__props.getProperty("org.dynmap.shadow.org.eclipse.jetty.util.log.stderr.SOURCE", "false")));
        __long = Boolean.parseBoolean(Log.__props.getProperty("org.dynmap.shadow.org.eclipse.jetty.util.log.stderr.LONG", "false"));
        __props.putAll((Map<?, ?>)Log.__props);
        for (String deprecatedProp : deprecatedProperties = new String[]{"DEBUG", "org.dynmap.shadow.org.eclipse.jetty.util.log.DEBUG", "org.dynmap.shadow.org.eclipse.jetty.util.log.stderr.DEBUG"}) {
            if (System.getProperty(deprecatedProp) == null) continue;
            System.err.printf("System Property [%s] has been deprecated! (Use org.eclipse.jetty.LEVEL=DEBUG instead)%n", deprecatedProp);
        }
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }
}

