/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.shadow.org.eclipse.jetty.security.authentication;

import org.dynmap.shadow.javax.servlet.ServletRequest;
import org.dynmap.shadow.javax.servlet.http.HttpServletRequest;
import org.dynmap.shadow.javax.servlet.http.HttpServletResponse;
import org.dynmap.shadow.javax.servlet.http.HttpSession;
import org.dynmap.shadow.org.eclipse.jetty.security.Authenticator;
import org.dynmap.shadow.org.eclipse.jetty.security.IdentityService;
import org.dynmap.shadow.org.eclipse.jetty.security.LoginService;
import org.dynmap.shadow.org.eclipse.jetty.server.UserIdentity;
import org.dynmap.shadow.org.eclipse.jetty.server.session.AbstractSessionManager;

public abstract class LoginAuthenticator
implements Authenticator {
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    public UserIdentity login(String username, Object password, ServletRequest request) {
        UserIdentity user = this._loginService.login(username, password);
        if (user != null) {
            this.renewSession((HttpServletRequest)request, null);
            return user;
        }
        return null;
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + this + " in " + configuration);
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + this + " in " + configuration);
        }
        this._renewSession = configuration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession httpSession = request.getSession(false);
        if (this._renewSession && httpSession != null && httpSession.getAttribute("org.dynmap.shadow.org.eclipse.jetty.security.sessionKnownOnlytoAuthenticated") != Boolean.TRUE) {
            LoginAuthenticator loginAuthenticator = this;
            synchronized (loginAuthenticator) {
                httpSession = AbstractSessionManager.renewSession(request, httpSession, true);
            }
        }
        return httpSession;
    }
}

