/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.forestry;

import java.util.HashMap;
import org.dynmap.renderer.CustomColorMultiplier;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;

public class ForestrySupport {
    static HashMap<String, LeavesEntry> leavesPerTreeName = new HashMap();

    public static void registerTreeType(String treeName, int saplingTex, int leavesTex, int color) {
        LeavesEntry leaves = new LeavesEntry(leavesTex, color);
        leavesPerTreeName.put(treeName, leaves);
        leavesPerTreeName.put("forestry." + treeName, leaves);
    }

    public static LeavesEntry getLeavesEntryForTreeName(String treeName) {
        return leavesPerTreeName.get(treeName);
    }

    public static class LeavesEntry
    extends CustomColorMultiplier
    implements CustomTextureMapper {
        int[] stack;
        int colorMultiplier;

        public LeavesEntry(int leavesTex, int color) {
            this.stack = new int[]{leavesTex};
            this.colorMultiplier = color;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            return this.stack;
        }

        @Override
        public int getColorMultiplier(MapDataContext mapDataCtx) {
            return this.colorMultiplier;
        }
    }
}

