/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import org.dynmap.renderer.MapDataContext;

public class BlockMatcher {
    BitSet simpleBlocks = new BitSet();
    HashMap<Integer, ArrayList<AdvancedCondition>> blocksWithAdvancedConditions = new HashMap();

    public void addBlock(int blockId) {
        int blockIdStart = BlockMatcher.getBlockIdStart(blockId);
        this.simpleBlocks.set(blockIdStart, blockIdStart + 16, true);
    }

    public void addBlockSingleMeta(int blockId, int meta) {
        int blockIdStart = BlockMatcher.getBlockIdStart(blockId);
        this.simpleBlocks.set(blockIdStart + meta);
    }

    public void addBlockMetaMask(int blockId, int metaMask) {
        int blockIdStart = BlockMatcher.getBlockIdStart(blockId);
        for (int i = 0; i < 16; ++i) {
            if ((metaMask & BlockMatcher.metaToMetaMask(i)) == 0) continue;
            this.simpleBlocks.set(blockIdStart + i);
        }
    }

    public void addBlockWithCondition(int blockId, int meta, AdvancedCondition advancedCondition) {
        int blockIdStart = BlockMatcher.getBlockIdStart(blockId);
        int combined = blockIdStart | meta;
        ArrayList<AdvancedCondition> list = this.blocksWithAdvancedConditions.get(combined);
        if (list == null) {
            list = new ArrayList();
            this.blocksWithAdvancedConditions.put(combined, list);
        }
        list.add(advancedCondition);
    }

    public boolean matches(MapDataContext mdc) {
        int blockMeta;
        int blockId = mdc.getBlockTypeID();
        int blockIdStart = BlockMatcher.getBlockIdStart(blockId);
        int combined = blockIdStart | BlockMatcher.metaToMetaMask(blockMeta = mdc.getBlockData() & 0xF);
        if (this.simpleBlocks.get(combined)) {
            return true;
        }
        ArrayList<AdvancedCondition> advanced = this.blocksWithAdvancedConditions.get(combined);
        if (advanced != null) {
            for (AdvancedCondition ac : advanced) {
                if (!ac.matches(mdc)) continue;
                return true;
            }
        }
        return false;
    }

    private static int metaToMetaMask(int blockMeta) {
        return 1 << blockMeta;
    }

    private static int getBlockIdStart(int blockId) {
        return blockId << 16;
    }

    public static class AdvancedCondition {
        public boolean matches(MapDataContext mdc) {
            return true;
        }
    }

    public static class AdvancedConditionParser {
        public AdvancedCondition parseExpression(String expr) {
            return new AdvancedCondition();
        }
    }
}

