/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class WardedBlockRenderer
extends CustomRenderer {
    private RenderPatch[] fullBlock;
    private static final int[] patchlist = new int[]{0, 1, 4, 5, 2, 3};
    static String[] nbtFieldsNeeded = new String[]{"md", "bi"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, patchlist);
        this.fullBlock = list.toArray(new RenderPatch[patchlist.length]);
        return true;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        return new CustomRendererData(this.fullBlock, null, new Texturer(mapDataCtx.getBlockTileEntityField("bi"), mapDataCtx.getBlockTileEntityField("md")));
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        return this.fullBlock;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    class Texturer
    implements CustomTextureMapper {
        TexturePack.HDTextureMap map;

        public Texturer(Object bi, Object md) {
            int blockId = GWM_Util.objectToInt(bi, 0);
            int meta = GWM_Util.objectToInt(md, 0);
            if (blockId != 0) {
                this.map = TexturePack.HDTextureMap.getMap(blockId, meta, 0);
            }
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            if (this.map == null) {
                return null;
            }
            return new int[]{this.map.getIndexForFace(patchId)};
        }
    }
}

