/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.hdmap.renderer.PipeRendererBase;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ThaumcraftPipeRenderer
extends PipeRendererBase {
    RenderPatch[][] pipesWithoutGoldBox;
    RenderPatch[][] pipesWithGoldBox;
    static String[] nbtFieldsNeeded = new String[]{"open"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        this.pipesWithoutGoldBox = this.generateSingleSize(rpf, 0.0625, 0.125, 0, 0);
        this.pipesWithGoldBox = this.generateSingleSize(rpf, 0.0625, 0.16666666666666666, 0, 1);
        return true;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        Object open = mapDataCtx.getBlockTileEntityField("open");
        int version = 0;
        if (open instanceof byte[]) {
            byte[] barr = (byte[])open;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int id;
                if (barr[dir.ordinal()] == 0 || (id = mapDataCtx.getBlockTypeIDAt(dir.offsetX, dir.offsetY, dir.offsetZ)) != mapDataCtx.getBlockTypeID()) continue;
                version |= dir.flag;
            }
        }
        return this.pipesWithoutGoldBox[version];
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }
}

