/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.modsupport.SimpleColorMultiplier;
import org.dynmap.renderer.CustomColorMultiplier;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class OpenComputers3DPrintedModelRenderer
extends CustomRenderer {
    private static final int[] fullBlockPatchList = new int[]{0, 1, 4, 5, 2, 3};
    private RenderPatch[] fullBlock;
    static String[] nbtFieldsNeeded = new String[]{"state", "data", "oc:pitch", "oc:yaw"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, fullBlockPatchList);
        this.fullBlock = list.toArray(new RenderPatch[fullBlockPatchList.length]);
        return true;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        return this.fullBlock;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        Object objState = mapDataCtx.getBlockTileEntityField("state");
        int state = GWM_Util.objectToInt(objState, 0);
        Object tmp = mapDataCtx.getBlockTileEntityField("data");
        if (tmp instanceof HashMap) {
            HashMap fields = (HashMap)tmp;
            ArrayList parts = state == 0 ? (ArrayList)fields.get("stateOff") : (ArrayList)fields.get("stateOn");
            ArrayList<RenderPatch[]> boxList = new ArrayList<RenderPatch[]>();
            ArrayList<Integer> tintList = new ArrayList<Integer>();
            ArrayList<Integer> textureList = new ArrayList<Integer>();
            for (Object o : parts) {
                if (!(o instanceof HashMap)) continue;
                HashMap map = (HashMap)o;
                Object objBounds = map.get("bounds");
                if (objBounds instanceof byte[]) {
                    byte[] bounds = (byte[])objBounds;
                    boxList.add(OpenComputers3DPrintedModelRenderer.getBoxSingleTextureInt(mapDataCtx.getPatchFactory(), bounds[0], bounds[3], bounds[1], bounds[4], bounds[2], bounds[5], 6 + boxList.size(), false));
                }
                int color = GWM_Util.objectToInt(map.get("tint"), 0xFFFFFF);
                tintList.add(color |= 0xFF000000);
                Object objTexture = map.get("texture");
                if (!(objTexture instanceof String)) continue;
                String texture = (String)objTexture;
                int attemptedLookup = GWM_Util.tryGetTextureIdByName(texture);
                textureList.add(attemptedLookup);
            }
            int yaw = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("oc:yaw"), 0);
            int pitch = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("oc:pitch"), 0);
            if (boxList.size() > 0) {
                RenderPatch[] patches = new RenderPatch[6 * boxList.size()];
                int[] tints = new int[tintList.size()];
                int[] actualTextures = new int[textureList.size()];
                for (int i = 0; i < boxList.size(); ++i) {
                    for (int j = 0; j < 6; ++j) {
                        RenderPatch[] renderPatches = (RenderPatch[])boxList.get(i);
                        switch (yaw) {
                            case 2: {
                                renderPatches = OpenComputers3DPrintedModelRenderer.getRotatedSet(mapDataCtx.getPatchFactory(), renderPatches, 0, 180, 0);
                                break;
                            }
                            case 4: {
                                renderPatches = OpenComputers3DPrintedModelRenderer.getRotatedSet(mapDataCtx.getPatchFactory(), renderPatches, 0, 90, 0);
                                break;
                            }
                            case 5: {
                                renderPatches = OpenComputers3DPrintedModelRenderer.getRotatedSet(mapDataCtx.getPatchFactory(), renderPatches, 0, 270, 0);
                            }
                        }
                        patches[i * 6 + j] = renderPatches[j];
                    }
                    tints[i] = (Integer)tintList.get(i);
                    actualTextures[i] = (Integer)textureList.get(i);
                }
                return new OpenComputers3DPrintedBlockRenderData(mapDataCtx, patches, tints, actualTextures);
            }
        }
        return super.getRenderData(mapDataCtx);
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    class OpenComputers3DPrintedBlockRenderData
    extends CustomRendererData
    implements CustomTextureMapper {
        private final int[] tints;
        SimpleColorMultiplier[] multipliers;
        private final int[] actualTextures;
        TexturePack.HDTextureMap map;

        public OpenComputers3DPrintedBlockRenderData(MapDataContext ctx, RenderPatch[] mesh, int[] tints, int[] actualTextures) {
            super(mesh, null, null);
            this.tints = tints;
            this.multipliers = new SimpleColorMultiplier[tints.length];
            this.actualTextures = actualTextures;
            this.map = TexturePack.HDTextureMap.getMap(ctx.getBlockTypeID(), ctx.getBlockData(), 0);
            for (int i = 0; i < tints.length; ++i) {
                this.multipliers[i] = new SimpleColorMultiplier(tints[i]);
                if (actualTextures[i] < 0) {
                    actualTextures[i] = this.map.getIndexForFace(6);
                }
                if (actualTextures[i] >= 1000000) continue;
                int n = i;
                actualTextures[n] = actualTextures[n] + 17000000;
            }
        }

        @Override
        public CustomTextureMapper getCustomTextureMapper() {
            return this;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            if (patchId >= 6) {
                return new int[]{this.actualTextures[patchId - 6]};
            }
            return new int[]{this.map.getIndexForFace(patchId)};
        }

        @Override
        public CustomColorMultiplier getCustomColorMultiplier(int patchId, int layer) {
            if (patchId >= 6) {
                return this.multipliers[patchId - 6];
            }
            return super.getCustomColorMultiplier(patchId, layer);
        }
    }
}

