/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.renderer.MultipartRenderer;
import org.dynmap.hdmap.renderer.PipeRendererBase;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.modsupport.appliedenergistics2.AE2Support;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class MECableRenderer
extends PipeRendererBase {
    public static MECableRenderer INSTANCE = null;
    RenderPatch[][] smallPipes;
    RenderPatch[][] mediumPipes;
    RenderPatch[][] largePipes;
    double smallPipeRadius = 0.125;
    double mediumPipeRadius = 0.1875;
    double largePipeRadius = 0.3125;
    int meCableBusBlockId;
    int multipartBlockId = -1000;
    public static final int ME_P2P_ID = 460;
    public static final int ME_QUARTZ_ID = 140;
    public static final int ME_ANCHOR_ID = 120;
    static int[] quartzIndices = new int[]{7, 7, 7, 7, 7, 7};
    static int[] anchorIndices = new int[]{8, 8, 8, 8, 8, 8};
    static String[] nbtFieldsNeeded = new String[]{"def:0", "def:1", "def:2", "def:3", "def:4", "def:5", "def:6", "extra:0", "extra:1", "extra:2", "extra:3", "extra:4", "extra:5", "extra:6", "facade:0", "facade:1", "facade:2", "facade:3", "facade:4", "facade:5", "parts"};
    static TexturePack.HDTextureMap map;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        RenderPatch[][] tmpSmallPipes = this.generateSingleSize(rpf, this.smallPipeRadius, this.smallPipeRadius, 0, 0);
        RenderPatch[][] tmpMediumPipes = this.generateSingleSize(rpf, this.mediumPipeRadius - 0.0625, this.mediumPipeRadius, 0, 0);
        RenderPatch[][] tmpLargePipes = this.generateSingleSize(rpf, this.largePipeRadius - 0.0625, this.largePipeRadius, 0, 0);
        this.smallPipes = new RenderPatch[67][];
        this.smallPipes[64] = CustomRenderer.getBoxSingleTexture(rpf, 0.5 - this.smallPipeRadius, 0.5 + this.smallPipeRadius, 0.0, 1.0, 0.5 - this.smallPipeRadius, 0.5 + this.smallPipeRadius, 0, false);
        this.smallPipes[65] = CustomRenderer.getBoxSingleTexture(rpf, 0.5 - this.smallPipeRadius, 0.5 + this.smallPipeRadius, 0.5 - this.smallPipeRadius, 0.5 + this.smallPipeRadius, 0.0, 1.0, 0, true);
        this.smallPipes[66] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.5 - this.smallPipeRadius, 0.5 + this.smallPipeRadius, 0.5 - this.smallPipeRadius, 0.5 + this.smallPipeRadius, 0, false);
        this.mediumPipes = new RenderPatch[67][];
        this.mediumPipes[64] = CustomRenderer.getBoxSingleTexture(rpf, 0.5 - this.mediumPipeRadius, 0.5 + this.mediumPipeRadius, 0.0, 1.0, 0.5 - this.mediumPipeRadius, 0.5 + this.mediumPipeRadius, 0, false);
        this.mediumPipes[65] = CustomRenderer.getBoxSingleTexture(rpf, 0.5 - this.mediumPipeRadius, 0.5 + this.mediumPipeRadius, 0.5 - this.mediumPipeRadius, 0.5 + this.mediumPipeRadius, 0.0, 1.0, 0, true);
        this.mediumPipes[66] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.5 - this.mediumPipeRadius, 0.5 + this.mediumPipeRadius, 0.5 - this.mediumPipeRadius, 0.5 + this.mediumPipeRadius, 0, false);
        this.largePipes = new RenderPatch[67][];
        this.largePipes[64] = CustomRenderer.getBoxSingleTexture(rpf, 0.5 - this.largePipeRadius, 0.5 + this.largePipeRadius, 0.0, 1.0, 0.5 - this.largePipeRadius, 0.5 + this.largePipeRadius, 0, false);
        this.largePipes[65] = CustomRenderer.getBoxSingleTexture(rpf, 0.5 - this.largePipeRadius, 0.5 + this.largePipeRadius, 0.5 - this.largePipeRadius, 0.5 + this.largePipeRadius, 0.0, 1.0, 0, true);
        this.largePipes[66] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.5 - this.largePipeRadius, 0.5 + this.largePipeRadius, 0.5 - this.largePipeRadius, 0.5 + this.largePipeRadius, 0, false);
        for (int i = 0; i < 64; ++i) {
            this.smallPipes[i] = tmpSmallPipes[i];
            this.mediumPipes[i] = tmpMediumPipes[i];
            this.largePipes[i] = tmpLargePipes[i];
        }
        this.meCableBusBlockId = blkid;
        INSTANCE = this;
        if (MultipartRenderer.INSTANCE != null) {
            this.multipartBlockId = MultipartRenderer.INSTANCE.blockId;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        void var13_34;
        void var10_20;
        HashMap map;
        Object v;
        HashMap thisExtra;
        HashMap multipartRoot;
        Object thisDef;
        int version;
        ArrayList<RenderPatch> list;
        RenderPatchFactory rpf;
        block43: {
            block42: {
                rpf = mapDataCtx.getPatchFactory();
                list = new ArrayList<RenderPatch>();
                version = 0;
                thisDef = null;
                multipartRoot = null;
                thisExtra = null;
                if (mapDataCtx.getBlockTypeID() != this.meCableBusBlockId) break block42;
                thisDef = mapDataCtx.getBlockTileEntityField("def:6");
                Object tmpExtra = mapDataCtx.getBlockTileEntityField("extra:6");
                if (tmpExtra == null) break block43;
                thisExtra = (HashMap)tmpExtra;
                break block43;
            }
            Object parts = mapDataCtx.getBlockTileEntityField("parts");
            if (parts instanceof ArrayList) {
                for (Object e : (ArrayList)parts) {
                    HashMap tmp;
                    Object objId;
                    if (!(e instanceof HashMap) || (objId = (tmp = (HashMap)e).get("id")) == null || !"ae2_cablebus".equals((String)objId)) continue;
                    multipartRoot = tmp;
                    thisDef = tmp.get("def:6");
                    Object v2 = tmp.get("extra:6");
                    if (v2 == null) break;
                    thisExtra = (HashMap)v2;
                    break;
                }
            }
        }
        short thisDamage = 16;
        if (thisDef instanceof HashMap && (v = (map = (HashMap)thisDef).get("Damage")) instanceof Short) {
            thisDamage = (Short)v;
        }
        boolean forceDefault = false;
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            Object tmpExtra;
            Object tmpDef;
            HashMap def = null;
            HashMap extra = null;
            if (multipartRoot == null) {
                tmpDef = mapDataCtx.getBlockTileEntityField("def:" + forgeDirection.ordinal());
                tmpExtra = mapDataCtx.getBlockTileEntityField("extra:" + forgeDirection.ordinal());
                if (tmpDef != null && tmpExtra != null) {
                    def = (HashMap)tmpDef;
                    extra = (HashMap)tmpExtra;
                }
            } else {
                tmpDef = multipartRoot.get("def:" + forgeDirection.ordinal());
                tmpExtra = multipartRoot.get("extra:" + forgeDirection.ordinal());
                if (tmpDef != null && tmpExtra != null) {
                    def = (HashMap)tmpDef;
                    extra = (HashMap)tmpExtra;
                }
            }
            if (extra == null && def == null) {
                Object parts;
                int id = mapDataCtx.getBlockTypeIDAt(forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ);
                ForgeDirection opposite = forgeDirection.getOpposite();
                Object otherExtra = null;
                Object otherDef = null;
                Object otherDirDef = null;
                boolean hasAe2CablePart = false;
                if (id == this.meCableBusBlockId) {
                    otherExtra = mapDataCtx.getBlockTileEntityFieldAt("extra:" + opposite.ordinal(), forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ);
                    otherDef = mapDataCtx.getBlockTileEntityFieldAt("def:6", forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ);
                    otherDirDef = mapDataCtx.getBlockTileEntityFieldAt("def:" + opposite.ordinal(), forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ);
                } else if (id == this.multipartBlockId && (parts = mapDataCtx.getBlockTileEntityFieldAt("parts", forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ)) instanceof ArrayList) {
                    for (Object part : (ArrayList)parts) {
                        HashMap tmp;
                        Object objId;
                        if (!(part instanceof HashMap) || (objId = (tmp = (HashMap)part).get("id")) == null || !"ae2_cablebus".equals((String)objId)) continue;
                        otherDef = tmp.get("def:6");
                        otherExtra = tmp.get("extra:" + opposite.ordinal());
                        otherDirDef = tmp.get("def:" + opposite.ordinal());
                        hasAe2CablePart = true;
                        break;
                    }
                }
                if (id == this.meCableBusBlockId || id == this.multipartBlockId && hasAe2CablePart) {
                    HashMap hm;
                    int damage;
                    HashMap map2;
                    Object dmgObj2;
                    int otherDamage = 0;
                    if (otherDef instanceof HashMap && (dmgObj2 = (map2 = (HashMap)otherDef).get("Damage")) instanceof Short) {
                        otherDamage = ((Short)dmgObj2).shortValue();
                    }
                    if (otherExtra == null && (otherDamage % 20 == thisDamage % 20 || thisDamage % 20 == 16 || otherDamage % 20 == 16)) {
                        version |= forgeDirection.flag;
                        if (thisDamage % 20 == otherDamage % 20 || thisDamage / 20 == otherDamage / 20) continue;
                        forceDefault = true;
                        continue;
                    }
                    if (otherExtra == null || otherDirDef == null || !(otherDirDef instanceof HashMap) || (damage = GWM_Util.objectToInt((hm = (HashMap)otherDirDef).get("Damage"), 0)) != 460 && damage != 140) continue;
                    version |= forgeDirection.flag;
                    continue;
                }
                AE2Support.ConnectableBlockData connectableBlockData = AE2Support.getConnectableData(id);
                if (connectableBlockData == null || !connectableBlockData.canConnectFrom(mapDataCtx, forgeDirection.getOpposite())) continue;
                version |= forgeDirection.flag;
                continue;
            }
            this.addTerminalOrBusOrWhatever(rpf, list, forgeDirection, def, extra);
            forceDefault = true;
        }
        boolean bl = false;
        if (thisDamage / 20 != 0 && !forceDefault) {
            if (version == (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) {
                int n = 2;
                version = 64;
            } else if (version == (ForgeDirection.NORTH.flag | ForgeDirection.SOUTH.flag)) {
                int n = 3;
                version = 65;
            } else if (version == (ForgeDirection.EAST.flag | ForgeDirection.WEST.flag)) {
                int n = 3;
                version = 66;
            }
        }
        if (MECableRenderer.map == null) {
            MECableRenderer.map = TexturePack.HDTextureMap.getMap(mapDataCtx.getBlockTypeID(), 0, 0);
        }
        boolean powered = false;
        if (thisExtra != null && GWM_Util.objectToInt(thisExtra.get("usedChannels"), 0) > 0) {
            powered = true;
        }
        TextureSelector texSel = new TextureSelector(thisDamage, (int)var10_20, powered);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TexturePack.HDTextureMap tmpMap;
            int[] arr;
            HashMap map3;
            Object tag;
            Object facade = multipartRoot == null ? mapDataCtx.getBlockTileEntityField("facade:" + dir.ordinal()) : multipartRoot.get("facade:" + dir.ordinal());
            if (!(facade instanceof HashMap) || !((tag = (map3 = (HashMap)facade).get("tag")) instanceof HashMap)) continue;
            HashMap tagMap = (HashMap)tag;
            Object tagX = tagMap.get("x");
            Object objModId = tagMap.get("modid");
            Object objItemName = tagMap.get("itemname");
            if (!(tagX instanceof int[]) || (arr = (int[])tagX).length < 2) continue;
            int blockId = arr[0];
            if (objModId instanceof String && objItemName instanceof String) {
                blockId = GWM_Util.blockNameToId(objModId + ":" + objItemName);
            }
            if ((tmpMap = TexturePack.HDTextureMap.getMap(blockId, arr[1], 0)) == null) continue;
            int[] textures = new int[6];
            for (int i = 0; i < 6; ++i) {
                textures[i] = 10000 + dir.ordinal();
            }
            switch (dir) {
                case DOWN: {
                    CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 0.1, 0.0, 1.0, textures);
                    break;
                }
                case UP: {
                    CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.9, 1.0, 0.0, 1.0, textures);
                    break;
                }
                case NORTH: {
                    CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 0.1, textures);
                    break;
                }
                case SOUTH: {
                    CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.9, 1.0, textures);
                    break;
                }
                case WEST: {
                    CustomRenderer.addBox(rpf, list, 0.0, 0.1, 0.0, 1.0, 0.0, 1.0, textures);
                    break;
                }
                case EAST: {
                    CustomRenderer.addBox(rpf, list, 0.9, 1.0, 0.0, 1.0, 0.0, 1.0, textures);
                    break;
                }
            }
            texSel.setFacade(dir, tmpMap.getIndexForFace(0));
        }
        RenderPatch[] renderPatchArray = this.smallPipes[version];
        switch (thisDamage / 20) {
            case 0: {
                RenderPatch[] renderPatchArray2 = this.smallPipes[version];
                break;
            }
            case 1: 
            case 2: {
                RenderPatch[] renderPatchArray3 = this.mediumPipes[version];
                break;
            }
            case 3: 
            case 26: 
            case 27: 
            case 28: {
                RenderPatch[] renderPatchArray4 = this.largePipes[version];
            }
        }
        if (!list.isEmpty()) {
            for (void rp : var13_34) {
                list.add((RenderPatch)rp);
            }
            return new CustomRendererData(list.toArray(new RenderPatch[list.size()]), null, texSel);
        }
        return new CustomRendererData((RenderPatch[])var13_34, null, texSel);
    }

    private void addTerminalOrBusOrWhatever(RenderPatchFactory rpf, ArrayList<RenderPatch> list, ForgeDirection dir, HashMap<String, Object> def, HashMap<String, Object> extra) {
        double max = 0.875;
        double min = 0.125;
        double pipePositive = 0.5 + this.smallPipeRadius;
        double pipeNegative = 0.5 - this.smallPipeRadius;
        int damage = GWM_Util.objectToInt(def.get("Damage"), -1);
        if (damage == 120) {
            switch (dir) {
                case DOWN: {
                    MECableRenderer.addBoxInt(rpf, list, 7, 9, 0, 7, 7, 9, anchorIndices);
                    break;
                }
                case UP: {
                    MECableRenderer.addBoxInt(rpf, list, 7, 9, 9, 16, 7, 9, anchorIndices);
                    break;
                }
                case NORTH: {
                    MECableRenderer.addBoxInt(rpf, list, 7, 9, 7, 9, 0, 7, anchorIndices);
                    break;
                }
                case SOUTH: {
                    MECableRenderer.addBoxInt(rpf, list, 7, 9, 7, 9, 9, 16, anchorIndices);
                    break;
                }
                case WEST: {
                    MECableRenderer.addBoxInt(rpf, list, 0, 7, 7, 9, 7, 9, anchorIndices);
                    break;
                }
                case EAST: {
                    MECableRenderer.addBoxInt(rpf, list, 9, 16, 7, 9, 7, 9, anchorIndices);
                    break;
                }
            }
            return;
        }
        if (damage == 140) {
            switch (dir) {
                case DOWN: {
                    MECableRenderer.addBoxInt(rpf, list, 6, 10, 0, 6, 6, 10, quartzIndices);
                    break;
                }
                case UP: {
                    MECableRenderer.addBoxInt(rpf, list, 6, 10, 10, 16, 6, 10, quartzIndices);
                    break;
                }
                case NORTH: {
                    MECableRenderer.addBoxInt(rpf, list, 6, 10, 6, 10, 0, 6, quartzIndices);
                    break;
                }
                case SOUTH: {
                    MECableRenderer.addBoxInt(rpf, list, 6, 10, 6, 10, 10, 16, quartzIndices);
                    break;
                }
                case WEST: {
                    MECableRenderer.addBoxInt(rpf, list, 0, 6, 6, 10, 6, 10, quartzIndices);
                    break;
                }
                case EAST: {
                    MECableRenderer.addBoxInt(rpf, list, 10, 16, 6, 10, 6, 10, quartzIndices);
                    break;
                }
            }
            return;
        }
        switch (dir) {
            case DOWN: {
                CustomRenderer.addBox(rpf, list, pipeNegative, pipePositive, min, pipePositive, pipeNegative, pipePositive, new int[]{0, 0, 0, 0, 0, 0});
                CustomRenderer.addBox(rpf, list, min, max, 0.0, min, min, max, new int[]{1, 2, 3, 4, 5, 6});
                break;
            }
            case UP: {
                CustomRenderer.addBox(rpf, list, pipeNegative, pipePositive, pipePositive, max, pipeNegative, pipePositive, new int[]{0, 0, 0, 0, 0, 0});
                CustomRenderer.addBox(rpf, list, min, max, max, 1.0, min, max, new int[]{2, 1, 3, 4, 5, 6});
                break;
            }
            case NORTH: {
                CustomRenderer.addBox(rpf, list, pipeNegative, pipePositive, pipeNegative, pipePositive, min, pipePositive, new int[]{0, 0, 0, 0, 0, 0});
                CustomRenderer.addBox(rpf, list, min, max, min, max, 0.0, min, new int[]{3, 4, 5, 6, 1, 2});
                break;
            }
            case SOUTH: {
                CustomRenderer.addBox(rpf, list, pipeNegative, pipePositive, pipeNegative, pipePositive, pipePositive, max, new int[]{0, 0, 0, 0, 0, 0});
                CustomRenderer.addBox(rpf, list, min, max, min, max, max, 1.0, new int[]{3, 4, 5, 6, 2, 1});
                break;
            }
            case WEST: {
                CustomRenderer.addBox(rpf, list, min, pipePositive, pipeNegative, pipePositive, pipeNegative, pipePositive, new int[]{0, 0, 0, 0, 0, 0});
                CustomRenderer.addBox(rpf, list, 0.0, min, min, max, min, max, new int[]{3, 4, 1, 2, 5, 6});
                break;
            }
            case EAST: {
                CustomRenderer.addBox(rpf, list, pipePositive, max, pipeNegative, pipePositive, pipeNegative, pipePositive, new int[]{0, 0, 0, 0, 0, 0});
                CustomRenderer.addBox(rpf, list, max, 1.0, min, max, min, max, new int[]{3, 4, 2, 1, 5, 6});
                break;
            }
        }
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    class TextureSelector
    implements CustomTextureMapper {
        private final short thisDamage;
        int textureId = 0;
        private final boolean powered;
        int[] facadeTextures;

        public TextureSelector(short thisDamage, int textureId, boolean powered) {
            this.thisDamage = thisDamage;
            this.textureId = textureId;
            this.powered = powered;
        }

        public void setFacade(ForgeDirection side, int textureId) {
            if (this.facadeTextures == null) {
                this.facadeTextures = new int[]{-1, -1, -1, -1, -1, -1};
            }
            this.facadeTextures[side.ordinal()] = textureId;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            if (patchId >= 10000 && patchId <= 10005) {
                return new int[]{this.facadeTextures[patchId - 10000]};
            }
            if (patchId == 1) {
                if (this.powered) {
                    return new int[]{map.getIndexForFace(2), map.getIndexForFace(1) + this.thisDamage % 20 + 23000000};
                }
                return new int[]{map.getIndexForFace(2), map.getIndexForFace(1) + this.thisDamage % 20};
            }
            if (patchId > 0) {
                return null;
            }
            if (this.thisDamage >= 0 && AE2Support.cableTypes[this.thisDamage] != null) {
                switch (this.textureId) {
                    case 2: {
                        return new int[]{AE2Support.cableTypes[this.thisDamage].textureId2};
                    }
                    case 3: {
                        return new int[]{AE2Support.cableTypes[this.thisDamage].textureId3};
                    }
                }
                return new int[]{AE2Support.cableTypes[this.thisDamage].textureId};
            }
            return null;
        }
    }
}

