/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.modsupport.SimpleColorMultiplier;
import org.dynmap.modsupport.gregtech.GregTechSupport;
import org.dynmap.renderer.CustomColorMultiplier;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class GregTechOreRenderer
extends CustomRenderer {
    private static final int[] fullBlockPatchList = new int[]{0, 1, 4, 5, 2, 3};
    private static RenderPatch[] fullBlock;
    static OreRenderData[][] oreRenderDataCache;
    static int[] baseTextures;
    private int blkid;
    static String[] nbtFieldsNeeded;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        this.blkid = blkid;
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, fullBlockPatchList);
        fullBlock = list.toArray(new RenderPatch[fullBlockPatchList.length]);
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        return fullBlock;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        int meta;
        if (baseTextures == null) {
            baseTextures = new int[16];
            for (int i = 0; i < 16; ++i) {
                TexturePack.HDTextureMap map = TexturePack.HDTextureMap.getMap(this.blkid, i, 0);
                GregTechOreRenderer.baseTextures[i] = map.getIndexForFace(0);
            }
        }
        int oreType = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("m"), 0);
        if (oreRenderDataCache[oreType %= 1000][meta = oreType / 1000] == null) {
            GregTechOreRenderer.oreRenderDataCache[oreType][meta] = new OreRenderData(meta, oreType);
        }
        return oreRenderDataCache[oreType][meta];
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    static {
        oreRenderDataCache = new OreRenderData[1000][32];
        nbtFieldsNeeded = new String[]{"m"};
    }

    static class OreRenderData
    extends CustomRendererData
    implements CustomTextureMapper {
        int[] textures;
        SimpleColorMultiplier multiplier;

        public OreRenderData(int meta, int oreType) {
            super(fullBlock, null, null);
            boolean isSmall;
            GregTechSupport.MaterialEntry ent = GregTechSupport.INSTANCE.getMaterial(oreType);
            int actualMeta = meta % 16;
            boolean bl = isSmall = meta >= 16;
            if (ent != null) {
                int overlay;
                this.multiplier = new SimpleColorMultiplier(ent.color);
                int n = overlay = isSmall ? ent.smallOreTextureOverlay : ent.oreTextureOverlay;
                this.textures = overlay >= 0 ? new int[]{baseTextures[actualMeta], isSmall ? ent.smallOreTexture : ent.oreTexture, overlay} : new int[]{baseTextures[actualMeta], isSmall ? ent.smallOreTexture : ent.oreTexture};
            }
        }

        @Override
        public CustomTextureMapper getCustomTextureMapper() {
            return this;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            return this.textures;
        }

        @Override
        public CustomColorMultiplier getCustomColorMultiplier(int patchId, int layer) {
            return this.multiplier;
        }
    }
}

