/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import gregtech.api.enums.Dyes;
import java.util.ArrayList;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.hdmap.renderer.PipeRendererBase;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.modsupport.gregtech.GregTechSupport;
import org.dynmap.renderer.CustomColorMultiplier;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class GregTechMachineRenderer
extends PipeRendererBase {
    private static final int[] fullBlockPatchList = new int[]{0, 1, 4, 5, 2, 3};
    private RenderPatch[] fullBlock;
    RenderPatch[][] pipes125;
    RenderPatch[][] pipes250;
    RenderPatch[][] pipes375;
    RenderPatch[][] pipes500;
    RenderPatch[][] pipes600;
    RenderPatch[][] pipes625;
    RenderPatch[][] pipes750;
    RenderPatch[][] pipes875;
    static int[] dyeColors = new int[16];
    static String[] nbtFieldsNeeded = new String[]{"id", "mID", "mColor", "mConnections", "mFacing", "mActive", "mMainFacing", "mMachineBlock", "mTexturePage", "texturePage", "textureIndex"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        this.pipes125 = this.generateSingleSize(rpf, 0.0625, 0.0, 0, 0);
        this.pipes250 = this.generateSingleSize(rpf, 0.125, 0.0, 0, 0);
        this.pipes375 = this.generateSingleSize(rpf, 0.1875, 0.0, 0, 0);
        this.pipes500 = this.generateSingleSize(rpf, 0.25, 0.0, 0, 0);
        this.pipes600 = this.generateSingleSize(rpf, 0.3, 0.0, 0, 0);
        this.pipes625 = this.generateSingleSize(rpf, 0.3125, 0.0, 0, 0);
        this.pipes750 = this.generateSingleSize(rpf, 0.375, 0.0, 0, 0);
        this.pipes875 = this.generateSingleSize(rpf, 0.4375, 0.0, 0, 0);
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, fullBlockPatchList);
        this.fullBlock = list.toArray(new RenderPatch[fullBlockPatchList.length]);
        for (Dyes d : Dyes.VALUES) {
            short[] rgba = d.getRGBA();
            GregTechMachineRenderer.dyeColors[d.ordinal()] = rgba[0] << 16 | rgba[1] << 8 | rgba[2];
        }
        return true;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        byte version = 0;
        Object typeIdObj = mapDataCtx.getBlockTileEntityField("mID");
        if (typeIdObj instanceof Integer) {
            int typeId = (Integer)typeIdObj;
            GregTechSupport.MetaTileEntityEntry entry = GregTechSupport.INSTANCE.getMTEEntre(typeId);
            int mColor = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("mColor"), 0);
            if (entry != null) {
                if (entry.type == GregTechSupport.MteType.Cable || entry.type == GregTechSupport.MteType.Wire || entry.type == GregTechSupport.MteType.Frame || entry.type == GregTechSupport.MteType.Pipe) {
                    Object connections = mapDataCtx.getBlockTileEntityField("mConnections");
                    RenderPatch[][] patchSetToUse = this.pipes375;
                    BasicMachineTextureAndColor pipeTexturesAndColorsThing = new BasicMachineTextureAndColor(typeId, mapDataCtx, false, -1, -1, mColor);
                    int thickness = entry.thickness;
                    switch (thickness) {
                        case 125: {
                            patchSetToUse = this.pipes125;
                            break;
                        }
                        case 250: {
                            patchSetToUse = this.pipes250;
                            break;
                        }
                        case 375: {
                            patchSetToUse = this.pipes375;
                            break;
                        }
                        case 500: {
                            patchSetToUse = this.pipes500;
                            break;
                        }
                        case 600: {
                            patchSetToUse = this.pipes600;
                            break;
                        }
                        case 625: {
                            patchSetToUse = this.pipes625;
                            break;
                        }
                        case 750: {
                            patchSetToUse = this.pipes750;
                            break;
                        }
                        case 875: {
                            patchSetToUse = this.pipes875;
                            break;
                        }
                        case 1000: {
                            return new CustomRendererData(this.fullBlock, pipeTexturesAndColorsThing, pipeTexturesAndColorsThing);
                        }
                        default: {
                            patchSetToUse = this.pipes250;
                        }
                    }
                    if (connections instanceof Byte) {
                        version = (Byte)connections;
                    }
                    return new CustomRendererData(patchSetToUse[version], pipeTexturesAndColorsThing, pipeTexturesAndColorsThing);
                }
                Object tmpActive = mapDataCtx.getBlockTileEntityField("mActive");
                Object tmpFacing = mapDataCtx.getBlockTileEntityField("mFacing");
                Object tmpMainFacing = mapDataCtx.getBlockTileEntityField("mMainFacing");
                boolean active = tmpActive != null && (Byte)tmpActive != 0;
                int facing = tmpFacing instanceof Short ? (int)((Short)tmpFacing).shortValue() : ForgeDirection.NORTH.ordinal();
                int mainFacing = tmpMainFacing instanceof Integer ? ((Integer)tmpMainFacing).intValue() : ForgeDirection.EAST.ordinal();
                BasicMachineTextureAndColor bmtac = new BasicMachineTextureAndColor(typeId, mapDataCtx, active, facing, mainFacing, mColor);
                return new CustomRendererData(this.fullBlock, bmtac, bmtac);
            }
        }
        return new CustomRendererData(this.fullBlock, null, null);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        return super.getRenderPatchList(mapDataCtx);
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    class BasicMachineTextureAndColor
    extends CustomColorMultiplier
    implements CustomTextureMapper {
        int[][] texturesToUse = new int[6][1];
        int colorMul = 0xFFFFFF;
        GregTechSupport.IconSet baseSet;
        int baseTex;
        int baseTex2;

        public BasicMachineTextureAndColor(int typeId, MapDataContext mapDataCtx, boolean active, int outputFacing, int mainFacing, int mColor) {
            GregTechSupport.MetaTileEntityEntry entry = GregTechSupport.INSTANCE.getMTEEntre(typeId);
            if (entry != null) {
                this.colorMul = entry.colorMul;
                int front = mainFacing;
                this.baseSet = entry.baseTextureSet;
                GregTechSupport.IconSet iconSet = entry.icons;
                this.baseTex = entry.baseTexture;
                this.baseTex2 = entry.baseTexture2;
                if (active) {
                    GregTechSupport.IconSet iconSet2 = iconSet = entry.activeIcons == null ? entry.icons : entry.activeIcons;
                }
                if (entry.isHatch) {
                    Object machineType = mapDataCtx.getBlockTileEntityField("textureIndex");
                    if (machineType == null) {
                        machineType = mapDataCtx.getBlockTileEntityField("mMachineBlock");
                    }
                    boolean success = false;
                    if (machineType != null) {
                        int num;
                        int page = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("texturePage"), 0);
                        if (page == 0) {
                            page = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("mTexturePage"), 0);
                        }
                        if ((num = GWM_Util.objectToInt(machineType, 0)) < 0) {
                            num += 128;
                        }
                        if (num >= 0 && num < 128 && GregTechSupport.INSTANCE.hatchBaseTextures2[page] != null && GregTechSupport.INSTANCE.hatchBaseTextures2[page][num] != 0) {
                            this.baseTex = GregTechSupport.INSTANCE.hatchBaseTextures2[page][num];
                            this.baseSet = null;
                            success = true;
                        }
                    }
                    if (!success) {
                        this.tryStealBaseTexFromNeighbor(mapDataCtx, outputFacing);
                    }
                }
                if (mColor > 0 && mColor <= 16) {
                    this.colorMul = dyeColors[mColor - 1];
                }
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (this.baseSet != null) {
                        if (iconSet != null) {
                            switch (dir) {
                                case DOWN: {
                                    if (outputFacing == dir.ordinal() && iconSet.output != -1) {
                                        this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.bottom, iconSet.output};
                                        break;
                                    }
                                    if (iconSet.bottom != -1) {
                                        this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.bottom, iconSet.bottom};
                                        break;
                                    }
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.bottom};
                                    break;
                                }
                                case UP: {
                                    if (outputFacing == dir.ordinal() && iconSet.output != -1) {
                                        this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.top, iconSet.output};
                                        break;
                                    }
                                    if (iconSet.top != -1) {
                                        this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.top, iconSet.top};
                                        break;
                                    }
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.top};
                                    break;
                                }
                                case NORTH: 
                                case SOUTH: 
                                case WEST: 
                                case EAST: {
                                    if (outputFacing == dir.ordinal() && iconSet.output != -1) {
                                        this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.side, iconSet.output};
                                        break;
                                    }
                                    if (front == dir.ordinal() && iconSet.front != -1) {
                                        this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.side, iconSet.front};
                                        break;
                                    }
                                    if (iconSet.side != -1) {
                                        this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.side, iconSet.side};
                                        break;
                                    }
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.side};
                                    break;
                                }
                            }
                            continue;
                        }
                        switch (dir) {
                            case DOWN: {
                                this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.bottom};
                                break;
                            }
                            case UP: {
                                this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.top};
                                break;
                            }
                            case NORTH: 
                            case SOUTH: 
                            case WEST: 
                            case EAST: {
                                this.texturesToUse[dir.ordinal()] = new int[]{this.baseSet.side};
                                break;
                            }
                        }
                        continue;
                    }
                    if (this.baseTex == -1) continue;
                    if (iconSet != null) {
                        switch (dir) {
                            case DOWN: {
                                if (outputFacing == dir.ordinal() && iconSet.output != -1) {
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex, iconSet.output};
                                    break;
                                }
                                if (iconSet.bottom != -1) {
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex, iconSet.bottom};
                                    break;
                                }
                                this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex};
                                break;
                            }
                            case UP: {
                                if (outputFacing == dir.ordinal() && iconSet.output != -1) {
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex, iconSet.output};
                                    break;
                                }
                                if (iconSet.top != -1) {
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex, iconSet.top};
                                    break;
                                }
                                this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex};
                                break;
                            }
                            case NORTH: 
                            case SOUTH: 
                            case WEST: 
                            case EAST: {
                                if (outputFacing == dir.ordinal() && iconSet.output != -1) {
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex, iconSet.output};
                                    break;
                                }
                                if (front == dir.ordinal() && iconSet.front != -1) {
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex, iconSet.front};
                                    break;
                                }
                                if (iconSet.side != -1) {
                                    this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex, iconSet.side};
                                    break;
                                }
                                this.texturesToUse[dir.ordinal()] = new int[]{this.baseTex};
                                break;
                            }
                        }
                        continue;
                    }
                    this.texturesToUse[dir.ordinal()] = this.baseTex2 != -1 ? new int[]{this.baseTex, this.baseTex2} : new int[]{this.baseTex};
                }
            } else {
                for (int i = 0; i < 6; ++i) {
                    this.texturesToUse[i] = new int[]{-1};
                }
            }
        }

        private void tryStealBaseTexFromNeighbor(MapDataContext mapDataCtx, int outputFacing) {
            ForgeDirection output = ForgeDirection.getOrientation((int)outputFacing);
            for (ForgeDirection searchDir : ForgeDirection.VALID_DIRECTIONS) {
                GregTechSupport.MetaTileEntityEntry otherMtee;
                int otherId;
                Object objId;
                int blockAt;
                if (searchDir == output || (blockAt = mapDataCtx.getBlockTypeIDAt(searchDir.offsetX, searchDir.offsetY, searchDir.offsetZ)) <= 1 || blockAt >= 65536) continue;
                if (GregTechSupport.INSTANCE.validHatchBaseBlocks[blockAt] != null) {
                    int blockDataAt = mapDataCtx.getBlockDataAt(searchDir.offsetX, searchDir.offsetY, searchDir.offsetZ);
                    int tex = GregTechSupport.INSTANCE.validHatchBaseBlocks[blockAt][blockDataAt];
                    if (tex <= 64) continue;
                    this.baseSet = null;
                    this.baseTex = tex;
                    break;
                }
                if (blockAt != mapDataCtx.getBlockTypeID() || !((objId = mapDataCtx.getBlockTileEntityFieldAt("mID", searchDir.offsetX, searchDir.offsetY, searchDir.offsetZ)) instanceof Integer) || (otherId = ((Integer)objId).intValue()) < 0 || otherId >= 65536 || (otherMtee = GregTechSupport.INSTANCE.getMTEEntre(otherId)) == null || otherMtee.baseTexture == -1 || otherMtee.type != GregTechSupport.MteType.Controller) continue;
                this.baseSet = null;
                this.baseTex = otherMtee.baseTexture;
                break;
            }
        }

        @Override
        public int getColorMultiplier(MapDataContext mapDataCtx) {
            return this.colorMul;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            return this.texturesToUse[patchId];
        }
    }
}

