/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ExtraTreesSlabRenderer
extends CustomRenderer {
    RenderPatch[][] upper;
    RenderPatch[][] lower;
    static String[] nbtFieldsNeeded = new String[]{"meta"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        this.upper = new RenderPatch[256][];
        this.lower = new RenderPatch[256][];
        for (int i = 0; i < 64; ++i) {
            this.upper[i] = ExtraTreesSlabRenderer.getBoxSingleTextureInt(rpf, 0, 16, 8, 16, 0, 16, i, false);
            this.lower[i] = ExtraTreesSlabRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 8, 0, 16, i, false);
        }
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int meta = GWM_Util.objectToInt(ctx.getBlockTileEntityField("meta"), 0);
        int data = ctx.getBlockData();
        if ((meta += 6) < 0 || meta > 40) {
            meta = 0;
        }
        return data < 8 ? this.lower[meta] : this.upper[meta];
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }
}

