/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class EnderStorageChestRenderer
extends CustomRenderer {
    private RenderPatch[] fullBlock;
    private static final int[] patchlist = new int[]{0, 1, 4, 5, 2, 3};
    private static final int[] patchlist2 = new int[]{10, 10, 10, 10, 10, 10};
    private static final int[] patchlist3 = new int[]{11, 11, 11, 11, 11, 11};
    private static final int[] patchlist4 = new int[]{12, 12, 12, 12, 12, 12};
    int[][] textures;
    static String[] nbtFieldsNeeded = new String[]{"rot", "freq"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0625, 0.9375, 0.0, 0.875, 0.0625, 0.9375, patchlist);
        CustomRenderer.addBox(rpf, list, 0.25, 0.375, 0.875, 0.9, 0.375, 0.625, patchlist2);
        CustomRenderer.addBox(rpf, list, 0.4375, 0.5625, 0.875, 0.9, 0.375, 0.625, patchlist3);
        CustomRenderer.addBox(rpf, list, 0.625, 0.75, 0.875, 0.9, 0.375, 0.625, patchlist4);
        this.fullBlock = list.toArray(new RenderPatch[list.size()]);
        return true;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        if (this.textures == null) {
            this.textures = new int[16][1];
            int woolId = GWM_Util.blockNameToId("minecraft:wool");
            for (int i = 0; i < 16; ++i) {
                TexturePack.HDTextureMap map = TexturePack.HDTextureMap.getMap(woolId, i, 0);
                this.textures[i] = new int[]{map.getIndexForFace(0)};
            }
        }
        int freq = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("freq"), 0);
        return new CustomRendererData(this.getRenderPatchList(mapDataCtx), null, new TextureMapper(freq, this.textures));
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        int rot = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("rot"), 0) * 90;
        if (rot != 0) {
            return EnderStorageChestRenderer.getRotatedSet(mapDataCtx.getPatchFactory(), this.fullBlock, 0, rot, 0);
        }
        return this.fullBlock;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    class TextureMapper
    implements CustomTextureMapper {
        private final int freq;
        private final int[][] textures;

        public TextureMapper(int freq, int[][] textures) {
            this.freq = freq;
            this.textures = textures;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            switch (patchId) {
                case 10: {
                    return this.textures[(this.freq & 0xF00) >> 8];
                }
                case 11: {
                    return this.textures[(this.freq & 0xF0) >> 4];
                }
                case 12: {
                    return this.textures[this.freq & 0xF];
                }
            }
            return null;
        }
    }
}

