/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.renderer.PipeRendererBase;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class EnderIOConduitRenderer
extends PipeRendererBase {
    RenderPatch[][] smallPipes;
    double smallPipeRadius = 0.09375;
    private RenderPatch[] fullBlock;
    int[] allZeroPatchIds = new int[]{0, 0, 0, 0, 0, 0};
    static String[] nbtFieldsNeeded = new String[]{"conduits", "facadeId", "facadeMeta"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        this.smallPipes = this.generateSingleSize(rpf, this.smallPipeRadius, this.smallPipeRadius + 0.0625, 0, 0);
        this.fullBlock = EnderIOConduitRenderer.getFullBlock(rpf, 0);
        return true;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        Object conduits = mapDataCtx.getBlockTileEntityField("conduits");
        Object facadeId = mapDataCtx.getBlockTileEntityField("facadeId");
        Object facadeMeta = mapDataCtx.getBlockTileEntityField("facadeMeta");
        if (facadeId instanceof String && facadeMeta instanceof Integer && !"null".equals((String)facadeId)) {
            return new CustomRendererData(this.fullBlock, null, new FacadeTextureLookupThing((String)facadeId, (Integer)facadeMeta));
        }
        int version = 0;
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        try {
            if (conduits instanceof ArrayList) {
                ArrayList alConduits = (ArrayList)conduits;
                for (Object tmp : alConduits) {
                    HashMap map = (HashMap)tmp;
                    Object conduit = map.get("conduit");
                    if (!(conduit instanceof HashMap)) continue;
                    HashMap hmConduit = (HashMap)conduit;
                    int[] connections = (int[])hmConduit.get("connections");
                    int[] extConnections = (int[])hmConduit.get("externalConnections");
                    for (int i : connections) {
                        version |= 1 << i;
                    }
                    block12: for (int i : extConnections) {
                        version |= 1 << i;
                        ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                        switch (dir) {
                            case DOWN: {
                                CustomRenderer.addBox(mapDataCtx.getPatchFactory(), list, 0.15, 0.85, 0.0, 0.05, 0.15, 0.85, this.allZeroPatchIds);
                                continue block12;
                            }
                            case UP: {
                                CustomRenderer.addBox(mapDataCtx.getPatchFactory(), list, 0.15, 0.85, 0.95, 1.0, 0.15, 0.85, this.allZeroPatchIds);
                                continue block12;
                            }
                            case NORTH: {
                                CustomRenderer.addBox(mapDataCtx.getPatchFactory(), list, 0.15, 0.85, 0.15, 0.85, 0.0, 0.05, this.allZeroPatchIds);
                                continue block12;
                            }
                            case SOUTH: {
                                CustomRenderer.addBox(mapDataCtx.getPatchFactory(), list, 0.15, 0.85, 0.15, 0.85, 0.95, 1.0, this.allZeroPatchIds);
                                continue block12;
                            }
                            case WEST: {
                                CustomRenderer.addBox(mapDataCtx.getPatchFactory(), list, 0.0, 0.05, 0.15, 0.85, 0.15, 0.85, this.allZeroPatchIds);
                                continue block12;
                            }
                            case EAST: {
                                CustomRenderer.addBox(mapDataCtx.getPatchFactory(), list, 0.95, 1.0, 0.15, 0.85, 0.15, 0.85, this.allZeroPatchIds);
                                continue block12;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.toString();
        }
        if (!list.isEmpty()) {
            for (RenderPatch rp : this.smallPipes[version]) {
                list.add(rp);
            }
            return new CustomRendererData(list.toArray(new RenderPatch[list.size()]), null, null);
        }
        return new CustomRendererData(this.smallPipes[version], null, null);
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    class FacadeTextureLookupThing
    implements CustomTextureMapper {
        int[] textures = new int[0];

        public FacadeTextureLookupThing(String blockName, int meta) {
            int blockId = GWM_Util.blockNameToId(blockName);
            TexturePack.HDTextureMap map = TexturePack.HDTextureMap.getMap(blockId, meta, 0);
            this.textures = new int[]{map.getIndexForFace(0), map.getIndexForFace(1), map.getIndexForFace(2), map.getIndexForFace(3), map.getIndexForFace(4), map.getIndexForFace(5)};
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            return new int[]{this.textures[patchId]};
        }
    }
}

