/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class CocoaBeanRenderer
extends CustomRenderer {
    RenderPatch[][] patches = new RenderPatch[16][];

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        this.patches[0] = this.makeBox(rpf, 4.0, 5.0);
        this.patches[4] = this.makeBox(rpf, 6.0, 7.0);
        this.patches[12] = this.makeBox(rpf, 7.0, 8.0);
        this.patches[8] = this.patches[12];
        for (int i = 1; i < 4; ++i) {
            this.patches[i] = CocoaBeanRenderer.getRotatedSet(rpf, this.patches[0], 0, 90 * i, 0);
            this.patches[4 + i] = CocoaBeanRenderer.getRotatedSet(rpf, this.patches[4], 0, 90 * i, 0);
            this.patches[8 + i] = CocoaBeanRenderer.getRotatedSet(rpf, this.patches[8], 0, 90 * i, 0);
            this.patches[12 + i] = this.patches[8 + i];
        }
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    RenderPatch[] makeBox(RenderPatchFactory rpf, double w, double h) {
        double xmin = this.i2d(8.0 - w / 2.0);
        double xmax = this.i2d(8.0 + w / 2.0);
        double zmin = this.i2d(1.0);
        double zmax = this.i2d(1.0 + w);
        double ymin = this.i2d(12.0 - h);
        double ymax = this.i2d(12.0);
        double sideLeft = this.i2d(15.0 - w);
        double sideRight = this.i2d(15.0);
        double sideTop = this.i2d(12.0);
        double sideBottom = this.i2d(12.0 - h);
        double topBottomTop = this.i2d(16.0);
        double topBottomBottom = this.i2d(16.0 - w);
        double topBottomLeft = this.i2d(0.0);
        double topBottomRight = this.i2d(w);
        RenderPatch[] patches = new RenderPatch[]{rpf.getPatchExplTexCoords(xmin, ymin, zmin, topBottomLeft, topBottomBottom, xmax, ymin, zmin, topBottomRight, topBottomBottom, xmin, ymin, zmin, topBottomLeft, topBottomTop, 100.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatchExplTexCoords(xmin, ymax, zmax, topBottomLeft, topBottomBottom, xmax, ymax, zmax, topBottomRight, topBottomBottom, xmin, ymax, zmin, topBottomLeft, topBottomTop, 100.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatchExplTexCoords(xmin, ymin, zmax, sideLeft, sideBottom, xmax, ymin, zmax, sideRight, sideBottom, xmin, ymax, zmax, sideLeft, sideTop, 100.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatchExplTexCoords(xmax, ymin, zmax, sideLeft, sideBottom, xmax, ymin, zmin, sideRight, sideBottom, xmax, ymax, zmax, sideLeft, sideTop, 100.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatchExplTexCoords(xmax, ymin, zmin, sideLeft, sideBottom, xmin, ymin, zmin, sideRight, sideBottom, xmax, ymax, zmin, sideLeft, sideTop, 100.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatchExplTexCoords(xmin, ymin, zmin, sideLeft, sideBottom, xmin, ymin, zmax, sideRight, sideBottom, xmin, ymax, zmin, sideLeft, sideTop, 100.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatchExplTexCoords(this.i2d(8.0), this.i2d(12.0), this.i2d(4.0), this.i2d(12.0), this.i2d(12.0), this.i2d(8.0), this.i2d(12.0), this.i2d(0.0), this.i2d(16.0), this.i2d(12.0), this.i2d(8.0), this.i2d(16.0), this.i2d(4.0), this.i2d(12.0), this.i2d(16.0), 100.0, RenderPatchFactory.SideVisible.BOTH, 0)};
        return CocoaBeanRenderer.getRotatedSet(rpf, patches, 0, 180, 0);
    }

    double i2d(double i) {
        return i / 16.0;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        return this.patches[mapDataCtx.getBlockData() & 0xF];
    }
}

