/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import org.dynmap.hdmap.renderer.CarpentersBlocksRenderer;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class CarpentersCollapsibleBlockRenderer
extends CarpentersBlocksRenderer {
    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        RenderPatchFactory rpf = mapDataCtx.getPatchFactory();
        Object objMetaData = mapDataCtx.getBlockTileEntityField("cbMetadata");
        int metaData = GWM_Util.objectToInt(objMetaData, 0);
        int base = metaData & 7;
        int se = metaData >> 3 & 0x1F;
        int ne = metaData >> 8 & 0x1F;
        int sw = metaData >> 13 & 0x1F;
        int nw = metaData >> 18 & 0x1F;
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        if (base == 1) {
            list.add(rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
            this.addSide(list, rpf, 180, sw, se);
            this.addSide(list, rpf, 90, se, ne);
            this.addSide(list, rpf, 0, ne, nw);
            this.addSide(list, rpf, 270, nw, sw);
            list.add(rpf.getTriangleAutoTexCoords(0.0, (double)sw / 16.0, 1.0, 1.0, (double)se / 16.0, 1.0, 0.0, (double)nw / 16.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
            list.add(rpf.getTriangleAutoTexCoords(1.0, (double)se / 16.0, 1.0, 0.0, (double)nw / 16.0, 0.0, 1.0, (double)ne / 16.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0));
            return list.toArray(new RenderPatch[list.size()]);
        }
        if (base == 0) {
            list.add(rpf.getPatch(0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0));
            this.addSideDown(list, rpf, 180, sw, se);
            this.addSideDown(list, rpf, 90, se, ne);
            this.addSideDown(list, rpf, 0, ne, nw);
            this.addSideDown(list, rpf, 270, nw, sw);
            list.add(rpf.getTriangleAutoTexCoords(0.0, 1.0 - (double)sw / 16.0, 1.0, 1.0, 1.0 - (double)se / 16.0, 1.0, 0.0, 1.0 - (double)nw / 16.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0));
            list.add(rpf.getTriangleAutoTexCoords(1.0, 1.0 - (double)se / 16.0, 1.0, 0.0, 1.0 - (double)nw / 16.0, 0.0, 1.0, 1.0 - (double)ne / 16.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
            return list.toArray(new RenderPatch[list.size()]);
        }
        return this.fullBlock;
    }

    void addSide(ArrayList<RenderPatch> list, RenderPatchFactory rpf, int rot, int a, int b) {
        if (a == 0 && b == 0) {
            return;
        }
        if (a == b && a > 0) {
            list.add(rpf.getRotatedPatch(rpf.getQuadAutoTexCoords(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, (double)a / 16.0, 0.0, RenderPatchFactory.SideVisible.BOTTOM, 0), 0, rot, 0, 0));
        } else {
            double min = (double)(a < b ? a : b) / 16.0;
            double max = (double)(a < b ? b : a) / 16.0;
            if (min > 0.0) {
                list.add(rpf.getRotatedPatch(rpf.getQuadAutoTexCoords(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, min, 0.0, RenderPatchFactory.SideVisible.BOTTOM, 0), 0, rot, 0, 0));
            }
            if (a < b) {
                list.add(rpf.getRotatedPatch(rpf.getTriangleAutoTexCoords(0.0, min, 0.0, 1.0, min, 0.0, 0.0, max, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0), 0, rot, 0, 0));
            } else {
                list.add(rpf.getRotatedPatch(rpf.getTriangleAutoTexCoords(0.0, min, 0.0, 1.0, max, 0.0, 1.0, min, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), 0, rot, 0, 0));
            }
        }
    }

    void addSideDown(ArrayList<RenderPatch> list, RenderPatchFactory rpf, int rot, int a, int b) {
        if (a == 0 && b == 0) {
            return;
        }
        if (a == b && a > 0) {
            list.add(rpf.getRotatedPatch(rpf.getQuadAutoTexCoords(0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0 - (double)a / 16.0, 0.0, RenderPatchFactory.SideVisible.TOP, 0), 0, rot, 0, 0));
        } else {
            double min = (double)(a < b ? a : b) / 16.0;
            double max = (double)(a < b ? b : a) / 16.0;
            if (min > 0.0) {
                list.add(rpf.getRotatedPatch(rpf.getQuadAutoTexCoords(0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0 - min, 0.0, RenderPatchFactory.SideVisible.TOP, 0), 0, rot, 0, 0));
            }
            if (a < b) {
                list.add(rpf.getRotatedPatch(rpf.getTriangleAutoTexCoords(0.0, 1.0 - min, 0.0, 1.0, 1.0 - min, 0.0, 0.0, 1.0 - max, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), 0, rot, 0, 0));
            } else {
                list.add(rpf.getRotatedPatch(rpf.getTriangleAutoTexCoords(0.0, 1.0 - min, 0.0, 1.0, 1.0 - max, 0.0, 1.0, 1.0 - min, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0), 0, rot, 0, 0));
            }
        }
    }
}

