/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.renderer.ArchitectureCraftShapeRenderer;
import org.dynmap.hdmap.renderer.FenceGateBase;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class CarpentersBlocksRenderer
extends FenceGateBase {
    protected RenderPatch[] fullBlock;
    private static final int[] patchlist = new int[]{0, 1, 4, 5, 2, 3};
    RenderPatch[][] shapes = new RenderPatch[256][];
    static String[] nbtFieldsNeeded = new String[]{"cbMetadata", "cbAttrList"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, patchlist);
        this.fullBlock = list.toArray(new RenderPatch[patchlist.length]);
        String type = custparm.get("type");
        if (type == null) {
            type = "";
        }
        if (type.equals("slope")) {
            this.initSlopeShapes(rpf);
        } else if (type.equals("stairs")) {
            this.initStairsShapes(rpf);
        } else if (type.equals("block")) {
            this.initBlockShapes(rpf);
        } else if (type.equals("plate")) {
            this.initPlateShapes(rpf);
        } else if (type.equals("hatch")) {
            this.initHatchShapes(rpf);
        } else if (type.equals("garage")) {
            this.initGarageShapes(rpf);
        } else if (type.equals("door")) {
            this.initDoorShapes(rpf);
        } else if (type.equals("gate")) {
            this.initGateShapes(rpf);
            link_ids.set(blkid);
        }
        return true;
    }

    private void initGateShapes(RenderPatchFactory rpf) {
        this.shapes[0] = CarpentersBlocksRenderer.combineMultiple(new RenderPatch[][]{CustomRenderer.getBoxSingleTextureInt(rpf, 0, 2, 5, 16, 7, 9, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 14, 16, 5, 16, 7, 9, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 2, 14, 12, 15, 7, 9, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 2, 14, 6, 9, 7, 9, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 6, 10, 9, 12, 7, 9, 0, false)});
        this.shapes[32] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[0], 0, 90, 0);
        this.shapes[64] = CarpentersBlocksRenderer.combineMultiple(new RenderPatch[][]{CustomRenderer.getBoxSingleTextureInt(rpf, 0, 2, 5, 16, 7, 9, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 14, 16, 5, 16, 7, 9, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 0, 2, 12, 15, 9, 15, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 0, 2, 6, 9, 9, 15, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 0, 2, 9, 12, 13, 15, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 14, 16, 12, 15, 9, 15, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 14, 16, 6, 9, 9, 15, 0, false), CustomRenderer.getBoxSingleTextureInt(rpf, 14, 16, 9, 12, 13, 15, 0, false)});
        this.shapes[80] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[64], 0, 180, 0);
        this.shapes[96] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[64], 0, 270, 0);
        this.shapes[112] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[64], 0, 90, 0);
        this.shapes[6] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 13, 7, 9, 0, false);
        this.shapes[38] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 7, 9, 0, 13, 0, 16, 0, false);
        this.shapes[70] = CarpentersBlocksRenderer.combineMultiple(new RenderPatch[][]{CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 2, 0, 13, 8, 16, 0, false), CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 14, 16, 0, 13, 8, 16, 0, false)});
        this.shapes[86] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[70], 0, 180, 0);
        this.shapes[102] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[70], 0, 270, 0);
        this.shapes[118] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[70], 0, 90, 0);
        for (int i = 1; i < 6; ++i) {
            for (int j = 0; j < 128; j += 16) {
                if (this.shapes[j + i] != null) continue;
                this.shapes[j + i] = this.shapes[j];
            }
        }
    }

    private void initBlockShapes(RenderPatchFactory rpf) {
        this.shapes[0] = this.fullBlock;
        this.shapes[1] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 0.5, 0.0, 1.0, 0.0, 1.0, 0, false);
        this.shapes[2] = CustomRenderer.getBoxSingleTexture(rpf, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0, 0, false);
        this.shapes[3] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0, 0, false);
        this.shapes[4] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.5, 1.0, 0.0, 1.0, 0, false);
        this.shapes[5] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.0, 1.0, 0.0, 0.5, 0, false);
        this.shapes[6] = CustomRenderer.getBoxSingleTexture(rpf, 0.0, 1.0, 0.0, 1.0, 0.5, 1.0, 0, false);
    }

    private void initPlateShapes(RenderPatchFactory rpf) {
        this.shapes[0] = CustomRenderer.getBoxSingleTextureInt(rpf, 1, 15, 15, 16, 1, 15, 0, false);
        this.shapes[1] = CustomRenderer.getBoxSingleTextureInt(rpf, 1, 15, 0, 1, 1, 15, 0, false);
        this.shapes[2] = CustomRenderer.getBoxSingleTextureInt(rpf, 1, 15, 1, 15, 15, 16, 0, false);
        this.shapes[3] = CustomRenderer.getBoxSingleTextureInt(rpf, 1, 15, 1, 15, 0, 1, 0, false);
        this.shapes[4] = CustomRenderer.getBoxSingleTextureInt(rpf, 15, 16, 1, 15, 1, 15, 0, false);
        this.shapes[5] = CustomRenderer.getBoxSingleTextureInt(rpf, 0, 1, 1, 15, 1, 15, 0, false);
        for (int i = 0; i < 6; ++i) {
            RenderPatch[] renderPatchArray = this.shapes[i];
            this.shapes[96 + i] = renderPatchArray;
            this.shapes[64 + i] = renderPatchArray;
            this.shapes[32 + i] = renderPatchArray;
        }
    }

    private void initHatchShapes(RenderPatchFactory rpf) {
        this.shapes[0] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 2, 0, 16, 0, false);
        this.shapes[32] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[0], 0, 180, 0);
        this.shapes[64] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[0], 0, 270, 0);
        this.shapes[96] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[0], 0, 90, 0);
        this.shapes[16] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 16, 14, 16, 0, false);
        this.shapes[48] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[16], 0, 180, 0);
        this.shapes[80] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[16], 0, 270, 0);
        this.shapes[112] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[16], 0, 90, 0);
        this.shapes[8] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 16, 14, 16, 0, 16, 0, false);
        this.shapes[40] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[8], 0, 180, 0);
        this.shapes[72] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[8], 0, 270, 0);
        this.shapes[104] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[8], 0, 90, 0);
        this.shapes[24] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 16, 14, 16, 0, false);
        this.shapes[56] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[24], 0, 180, 0);
        this.shapes[88] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[24], 0, 270, 0);
        this.shapes[120] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[24], 0, 90, 0);
        for (int i = 1; i < 128; ++i) {
            if (this.shapes[i] != null || this.shapes[i - 1] == null) continue;
            this.shapes[i] = this.shapes[i - 1];
        }
    }

    private void initGarageShapes(RenderPatchFactory rpf) {
        this.shapes[0] = this.fullBlock;
        this.shapes[32] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 16, 12, 14, 0, false);
        this.shapes[48] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[32], 0, 180, 0);
        this.shapes[64] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[32], 0, 270, 0);
        this.shapes[80] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[32], 0, 90, 0);
        this.shapes[160] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 16, 8, 16, 14, 16, 0, false);
        this.shapes[176] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[160], 0, 180, 0);
        this.shapes[192] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[160], 0, 270, 0);
        this.shapes[208] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[160], 0, 90, 0);
        for (int i = 1; i < 128; ++i) {
            if (this.shapes[i] != null || this.shapes[i - 1] == null) continue;
            this.shapes[i] = this.shapes[i - 1];
        }
    }

    private void initDoorShapes(RenderPatchFactory rpf) {
        int i;
        this.shapes[0] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 3, 0, 16, 0, 16, 0, false);
        this.shapes[16] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[0], 0, 90, 0);
        this.shapes[32] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[0], 0, 180, 0);
        this.shapes[48] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[0], 0, 270, 0);
        this.shapes[128] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 3, 0, 16, 0, 16, 0, false);
        this.shapes[144] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[128], 0, 90, 0);
        this.shapes[160] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[128], 0, 180, 0);
        this.shapes[176] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[128], 0, 270, 0);
        this.shapes[8] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 3, 0, 16, 0, 16, 0, false);
        this.shapes[24] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[8], 0, 90, 0);
        this.shapes[40] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[8], 0, 180, 0);
        this.shapes[56] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[8], 0, 270, 0);
        this.shapes[136] = CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 3, 0, 16, 0, 16, 0, false);
        this.shapes[152] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[136], 0, 90, 0);
        this.shapes[168] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[136], 0, 180, 0);
        this.shapes[184] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[136], 0, 270, 0);
        for (i = 191; i >= 0; --i) {
            if (this.shapes[i] == null || this.shapes[i + 64] != null) continue;
            this.shapes[i + 64] = (i & 8) != 0 ? CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[i], 0, 270, 0) : CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[i], 0, 90, 0);
        }
        for (i = 1; i < 256; ++i) {
            if (this.shapes[i] != null || this.shapes[i - 1] == null) continue;
            this.shapes[i] = this.shapes[i - 1];
        }
    }

    private void initStairsShapes(RenderPatchFactory rpf) {
        this.shapes[8] = ArchitectureCraftShapeRenderer.makeStairs(rpf, 0);
        this.shapes[9] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[8], 0, 180, 0);
        this.shapes[10] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[8], 0, 270, 0);
        this.shapes[11] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[8], 0, 90, 0);
        this.shapes[16] = CarpentersBlocksRenderer.combineMultiple(new RenderPatch[][]{CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 8, 0, 16, 0, false), CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 8, 8, 16, 0, 16, 0, false), CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 8, 16, 8, 16, 0, 8, 0, false)});
        this.shapes[17] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[16], 0, 180, 0);
        this.shapes[18] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[16], 0, 270, 0);
        this.shapes[19] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[16], 0, 90, 0);
        this.shapes[24] = CarpentersBlocksRenderer.combineMultiple(new RenderPatch[][]{CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 8, 0, 16, 0, false), CarpentersBlocksRenderer.getBoxSingleTextureInt(rpf, 0, 8, 8, 16, 0, 8, 0, false)});
        this.shapes[25] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[24], 0, 180, 0);
        this.shapes[26] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[24], 0, 270, 0);
        this.shapes[27] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[24], 0, 90, 0);
    }

    private void initSlopeShapes(RenderPatchFactory rpf) {
        RenderPatch[] halfHeightRoofPartToSlope = CarpentersBlocksRenderer.combineMultiple(rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.5, 0.5, 0.0, 1.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 0.0, 0.5, 0.5, 0.0, 0.5, 0.5, 0.5, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.5, 0.5, 0.5, 0.5, 0.5, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        RenderPatch[] halfHeightRoofPartSlopeToStraight = CarpentersBlocksRenderer.combineMultiple(rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 0.5, 0.5, 0.5, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.5, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 0.0, 0.5, 0.5, 0.5, 0.5, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        RenderPatch[] halfHeightRoofPartStraight = CarpentersBlocksRenderer.combineMultiple(rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.5, 0.5, 0.0, 1.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getQuadAutoTexCoords(0.0, 0.0, 0.0, 0.0, 0.0, 0.5, 0.5, 0.5, 0.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getQuadAutoTexCoords(1.0, 0.0, 0.5, 1.0, 0.0, 0.0, 0.5, 0.5, 0.5, RenderPatchFactory.SideVisible.TOP, 0));
        RenderPatch[] bottom = new RenderPatch[]{rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0)};
        this.shapes[0] = CarpentersBlocksRenderer.getRotatedSet(rpf, ArchitectureCraftShapeRenderer.makeRoofPatches(rpf, 0), 0, 180, 90, true);
        this.shapes[4] = CarpentersBlocksRenderer.getRotatedSet(rpf, ArchitectureCraftShapeRenderer.makeRoofPatches(rpf, 0), 0, 0, 180, true);
        this.shapes[8] = ArchitectureCraftShapeRenderer.makeRoofPatches(rpf, 0);
        this.shapes[12] = CarpentersBlocksRenderer.getRotatedSet(rpf, CarpentersBlocksRenderer.getRotatedSet(rpf, ArchitectureCraftShapeRenderer.makeRoofInnerCornerPatches(rpf, 0), 0, 0, 180), 0, 180, 0, true);
        this.shapes[16] = CarpentersBlocksRenderer.getRotatedSet(rpf, ArchitectureCraftShapeRenderer.makeRoofInnerCornerPatches(rpf, 0), 0, 90, 0, true);
        this.shapes[20] = CarpentersBlocksRenderer.getRotatedSet(rpf, CarpentersBlocksRenderer.getRotatedSet(rpf, ArchitectureCraftShapeRenderer.makeRoofOuterCornerPatches(rpf, 0), 0, 0, 180), 0, 180, 0, true);
        this.shapes[24] = CarpentersBlocksRenderer.getRotatedSet(rpf, ArchitectureCraftShapeRenderer.makeRoofOuterCornerPatches(rpf, 0), 0, 90, 0, true);
        this.shapes[32] = CarpentersBlocksRenderer.combineMultiple(rpf.getPatch(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        this.shapes[40] = CarpentersBlocksRenderer.combineMultiple(rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        this.shapes[28] = CarpentersBlocksRenderer.getRotatedSet(rpf, CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[32], 0, 0, 180), 0, 270, 0, true);
        this.shapes[36] = CarpentersBlocksRenderer.getRotatedSet(rpf, CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[40], 0, 0, 180), 0, 270, 0, true);
        for (int i = 0; i < 44; i += 4) {
            if (this.shapes[i] == null) continue;
            this.shapes[i + 1] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[i], 0, 180, 0, true);
            this.shapes[i + 2] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[i], 0, 270, 0, true);
            this.shapes[i + 3] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[i], 0, 90, 0, true);
        }
        this.shapes[44] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.getSpikeTop(rpf), 180, 0, 0, true);
        this.shapes[45] = this.getSpikeTop(rpf);
        this.shapes[46] = CarpentersBlocksRenderer.combineMultiple(new RenderPatch[][]{bottom, halfHeightRoofPartStraight, halfHeightRoofPartSlopeToStraight});
        this.shapes[47] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[46], 0, 180, 0, true);
        this.shapes[48] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[46], 0, 270, 0, true);
        this.shapes[49] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[46], 0, 90, 0, true);
        this.shapes[50] = CarpentersBlocksRenderer.combineMultiple(bottom[0], rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.5, 0.5, 0.0, 1.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.5, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.5, RenderPatchFactory.SideVisible.TOP, 0));
        this.shapes[51] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[50], 0, 90, 0, true);
        this.shapes[52] = CarpentersBlocksRenderer.combineMultiple(bottom[0], rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.5, 0.5, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.5, 0.5, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.5, 0.0, 0.5, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.5, 1.0, 0.0, 0.5, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 0.5, 0.5, 0.5, 0.5, 0.5, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 0.5, 0.5, 0.5, 0.5, 0.5, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.5, 0.5, 0.5, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.0, 0.0, 0.5, 0.5, 0.5, 0.5, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        this.shapes[53] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[52], 0, 180, 0, true);
        this.shapes[54] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[52], 0, 270, 0, true);
        this.shapes[55] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[52], 0, 90, 0, true);
        this.shapes[56] = CarpentersBlocksRenderer.combineMultiple(new RenderPatch[][]{bottom, halfHeightRoofPartToSlope, this.shapes[51]});
        this.shapes[57] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[56], 0, 180, 0, true);
        this.shapes[58] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[56], 0, 270, 0, true);
        this.shapes[59] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[56], 0, 90, 0, true);
        this.shapes[60] = CarpentersBlocksRenderer.combineMultiple(new RenderPatch[][]{bottom, halfHeightRoofPartToSlope, CarpentersBlocksRenderer.getRotatedSet(rpf, halfHeightRoofPartToSlope, 0, 90, 0, true), CarpentersBlocksRenderer.getRotatedSet(rpf, halfHeightRoofPartToSlope, 0, 180, 0, true), CarpentersBlocksRenderer.getRotatedSet(rpf, halfHeightRoofPartToSlope, 0, 270, 0, true)});
        this.shapes[61] = CarpentersBlocksRenderer.combineMultiple(new RenderPatch[][]{this.shapes[8], halfHeightRoofPartToSlope});
        this.shapes[62] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[61], 0, 180, 0, true);
        this.shapes[63] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[61], 0, 270, 0, true);
        this.shapes[64] = CarpentersBlocksRenderer.getRotatedSet(rpf, this.shapes[61], 0, 90, 0, true);
    }

    private RenderPatch[] getSpikeTop(RenderPatchFactory rpf) {
        RenderPatch[] ret = new RenderPatch[]{rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.5, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 0.0, 0.5, 0.5, 0.5, 1.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 0.5, 0.5, 0.5, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 0.5, 0.5, 0.5, 0.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0)};
        return ret;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        Object objMetaData = mapDataCtx.getBlockTileEntityField("cbMetadata");
        int metaData = 0;
        if (objMetaData instanceof Integer) {
            metaData = (Integer)objMetaData;
        } else if (objMetaData instanceof Short) {
            metaData = ((Short)objMetaData).intValue();
        } else {
            return this.fullBlock;
        }
        if (metaData >= 256) {
            metaData %= 256;
        }
        if (metaData >= 0 && metaData < this.shapes.length && this.shapes[metaData] != null) {
            return this.shapes[metaData];
        }
        return this.fullBlock;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        return new CustomRendererData(this.getRenderPatchList(mapDataCtx), null, new TextureSelector(mapDataCtx));
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    public static class TextureSelector
    implements CustomTextureMapper {
        TexturePack.HDTextureMap map;
        TexturePack.HDTextureMap[] maps;

        public TextureSelector(MapDataContext mapDataCtx) {
            this(mapDataCtx, -1);
        }

        public TextureSelector(MapDataContext mapDataCtx, int maxMaps) {
            Object objAttrList = mapDataCtx.getBlockTileEntityField("cbAttrList");
            if (maxMaps > 6) {
                this.maps = new TexturePack.HDTextureMap[maxMaps];
            }
            if (objAttrList instanceof ArrayList) {
                ArrayList attrList = (ArrayList)objAttrList;
                boolean sixFound = false;
                for (Object attrSet : attrList) {
                    Object strId;
                    if (!(attrSet instanceof HashMap)) continue;
                    HashMap attrs = (HashMap)attrSet;
                    int attr = GWM_Util.objectToInt(attrs.get("cbAttribute"), -1);
                    if (attr == 6) {
                        sixFound = true;
                    }
                    int id = (strId = attrs.get("cbUniqueId")) instanceof String ? GWM_Util.blockNameToId((String)strId) : GWM_Util.objectToInt(attrs.get("id"), 0);
                    int data = GWM_Util.objectToInt(attrs.get("Damage"), 0);
                    this.map = TexturePack.HDTextureMap.getMap(id, data, 0);
                    if (this.maps != null && attr >= 0 && attr < maxMaps) {
                        this.maps[attr] = this.map;
                    }
                    if (!sixFound || this.map == null || this.maps != null) continue;
                    break;
                }
                if (this.maps != null && this.maps[6] != null) {
                    this.map = this.maps[6];
                }
            }
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            if (this.maps != null) {
                if (patchId > 0 && patchId < this.maps.length && this.maps[patchId] != null) {
                    return new int[]{this.maps[patchId].getIndexForFace(0)};
                }
                if (patchId == 0 && this.maps[6] != null) {
                    return new int[]{this.maps[6].getIndexForFace(0)};
                }
                return null;
            }
            if (this.map != null) {
                return new int[]{this.map.getIndexForFace(patchId % 6)};
            }
            return new int[0];
        }
    }
}

