/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.BitSet;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.renderer.PipeRendererBase;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class BuildCraftPipeRenderer
extends PipeRendererBase {
    public static BitSet buildCraftCompatiblePipeBlocks = new BitSet(65536);
    RenderPatch[][] pipes;
    static String[] nbtFieldsNeeded = new String[]{"inputOpen", "pipeId"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        buildCraftCompatiblePipeBlocks.set(blkid);
        this.pipes = this.generateSingleSize(rpf, 0.25, 0.25, 0, 0);
        return true;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        int open = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("inputOpen"), 63);
        int version = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int id;
            if ((open & 1 << dir.ordinal()) == 0 || !buildCraftCompatiblePipeBlocks.get(id = mapDataCtx.getBlockTypeIDAt(dir.offsetX, dir.offsetY, dir.offsetZ))) continue;
            version |= dir.flag;
        }
        return this.pipes[version];
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        int tex;
        int pipeId = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("pipeId"), -1);
        int[] layers = null;
        if (pipeId > 0 && (tex = TexturePack.getTextureIdFromTextureMap("PIPES", pipeId)) > 0) {
            layers = new int[]{tex};
        }
        return new RenderData(this.getRenderPatchList(mapDataCtx), layers);
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    static class RenderData
    extends CustomRendererData
    implements CustomTextureMapper {
        private final int[] layers;

        public RenderData(RenderPatch[] mesh, int[] layers) {
            super(mesh, null, null);
            this.layers = layers;
        }

        @Override
        public CustomTextureMapper getCustomTextureMapper() {
            return this;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            return this.layers;
        }
    }
}

