/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.modsupport.forestry.BinnieSupport;
import org.dynmap.renderer.CustomColorMultiplier;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class BinnieCeramicsRenderer
extends CustomRenderer {
    RenderPatch[] fullBlock;
    RenderPatch[][][] rotations = new RenderPatch[6][4][];
    boolean isBrick;
    boolean isBasic;
    static String[] nbtFieldsNeeded = new String[]{"meta"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        int i;
        this.fullBlock = CustomRenderer.getBoxFull(rpf, new int[]{0, 1, 2, 3, 4, 5});
        this.rotations[1][0] = BinnieCeramicsRenderer.combineMultiple(rpf.getPatch(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0), rpf.getPatch(0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 1), BinnieCeramicsRenderer.getSidePatch(rpf, 2, 0, 2), BinnieCeramicsRenderer.getSidePatch(rpf, 3, 0, 3), BinnieCeramicsRenderer.getSidePatch(rpf, 4, 0, 4), BinnieCeramicsRenderer.getSidePatch(rpf, 5, 0, 5));
        for (i = 1; i < 4; ++i) {
            this.rotations[1][i] = BinnieCeramicsRenderer.getRotatedSet(rpf, this.rotations[1][0], 0, 90 * i, 0);
        }
        for (i = 0; i < 4; ++i) {
            this.rotations[0][i] = BinnieCeramicsRenderer.getRotatedSet(rpf, this.rotations[1][i], 180, 0, 0);
            this.rotations[2][i] = BinnieCeramicsRenderer.getRotatedSet(rpf, this.rotations[1][i], 90, 180, 0);
            this.rotations[3][i] = BinnieCeramicsRenderer.getRotatedSet(rpf, this.rotations[1][i], 270, 0, 0);
            this.rotations[4][i] = BinnieCeramicsRenderer.getRotatedSet(rpf, this.rotations[1][i], 0, 90, 270);
            this.rotations[5][i] = BinnieCeramicsRenderer.getRotatedSet(rpf, this.rotations[1][i], 0, 270, 90);
        }
        String t = custparm.get("type");
        if (t != null) {
            if (t.equals("brick")) {
                this.isBrick = true;
            } else if (t.equals("basic")) {
                this.isBasic = true;
            }
        }
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        return this.fullBlock;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        int meta = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField("meta"), 0);
        int top = meta >> 28 & 0xF;
        int rot = meta >> 26 & 3;
        if (top >= 6) {
            top = 1;
        }
        if (rot >= 4) {
            rot = 0;
        }
        if (this.isBasic) {
            return new MyCustomRenderData(this.fullBlock, mapDataCtx, this.isBrick, this.isBasic, meta);
        }
        return new MyCustomRenderData(this.rotations[top][rot], mapDataCtx, this.isBrick, this.isBasic, meta);
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    static class MyCustomRenderData
    extends CustomRendererData
    implements CustomTextureMapper {
        private final MapDataContext mapDataCtx;
        private final boolean isBasic;
        int colorA;
        int colorB;
        int[][] layers;

        public MyCustomRenderData(RenderPatch[] mesh, MapDataContext mapDataCtx, boolean isBrick, boolean isBasic, int meta) {
            super(mesh, null, null);
            this.mapDataCtx = mapDataCtx;
            this.isBasic = isBasic;
            this.colorA = meta & 0xFF;
            this.colorB = meta >> 8 & 0xFF;
            if (this.colorA >= BinnieSupport.flowerColorMultipliers.length) {
                this.colorA = 0;
            }
            if (this.colorB >= BinnieSupport.flowerColorMultipliers.length) {
                this.colorB = 0;
            }
            if (isBrick) {
                int design = meta >> 16 & 0xFF;
                this.layers = BinnieSupport.ceramicBrickTextures.get(design);
            } else {
                int design = meta >> 16 & 0xFF;
                this.layers = BinnieSupport.ceramicPatternTextures.get(design);
            }
        }

        @Override
        public CustomColorMultiplier getCustomColorMultiplier(int patchId, int layer) {
            if (layer == 0) {
                return BinnieSupport.flowerColorMultipliers[this.colorA];
            }
            if (layer == 1) {
                return BinnieSupport.flowerColorMultipliers[this.colorB];
            }
            return null;
        }

        @Override
        public CustomTextureMapper getCustomTextureMapper() {
            if (this.isBasic) {
                return null;
            }
            return this;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            if (this.layers == null) {
                return null;
            }
            if (patchId < this.layers.length) {
                return this.layers[patchId];
            }
            return this.layers[0];
        }
    }
}

