/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge.integration;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.forge.ForgeWorld;
import org.dynmap.forge.GwmCommand;
import org.dynmap.forge.GwmConfig;
import org.dynmap.forge.GwmSubCommand;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.events.chunks.ChunkModifiedEvent;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.math.ChunkDimPos;

public class ServerUtilitiesClaimedChunksMarkers
extends DynmapCommonAPIListener {
    static ServerUtilitiesClaimedChunksMarkers INSTANCE;
    MarkerSet markerSet;
    MarkerAPI markerAPI;
    boolean updateNeeded = true;
    HashMap<Integer, String> dimensionIdToWorldName = new HashMap();

    @Override
    public void apiEnabled(DynmapCommonAPI api) {
        if (!ServerUtilitiesConfig.world.chunk_claiming) {
            return;
        }
        GwmCommand.registerSubCommand(new UpdateSUClaimsGwmSubCommand("updatesuclaims"));
        this.markerAPI = api.getMarkerAPI();
        this.markerSet = this.markerAPI.createMarkerSet("suclaims", "Claimed Chunks (SU)", null, false);
        this.markerSet.setHideByDefault(true);
        MinecraftServer server = MinecraftServer.func_71276_C();
        for (WorldServer ws : server.field_71305_c) {
            this.dimensionIdToWorldName.put(ws.field_73011_w.field_76574_g, ForgeWorld.getWorldName((World)ws));
        }
        INSTANCE = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    void update() {
        if (!ClaimedChunks.isActive()) {
            return;
        }
        for (AreaMarker m : this.markerSet.getAreaMarkers()) {
            if (m == null) continue;
            m.deleteMarker();
        }
        if (ClaimedChunks.instance == null) {
            return;
        }
        int claimId = 1;
        for (ClaimedChunk cc : ClaimedChunks.instance.getAllChunks()) {
            List members;
            ChunkDimPos pos = cc.getPos();
            String worldId = this.dimensionIdToWorldName.get(pos.dim);
            if (worldId == null) continue;
            double[] x = new double[]{pos.posX * 16, pos.posX * 16 + 16};
            double[] z = new double[]{pos.posZ * 16, pos.posZ * 16 + 16};
            ForgeTeam team = cc.getTeam();
            String teamName = team.getId();
            String label = "Claimed by <b>" + teamName + "</b>";
            String desc = team.getDesc();
            if (desc != null && !desc.equals("")) {
                label = label + "<br/><i>" + team.getDesc() + "</i>";
            }
            if (team.owner != null) {
                label = label + "<br/><b>Founder: </b>" + team.owner.getName();
            }
            if ((members = team.getMembers()) != null) {
                for (ForgePlayer forgePlayer : members) {
                    if (forgePlayer == team.owner) continue;
                    label = label + "<br/>Member: " + forgePlayer.getName();
                }
            }
            if (team.players != null) {
                for (Map.Entry entry : team.players.entrySet()) {
                    label = label + "<br/>" + entry.getValue() + ": " + ((ForgePlayer)entry.getKey()).getName();
                }
            }
            AreaMarker am = this.markerSet.createAreaMarker("c_" + claimId++, label, true, worldId, x, z, false);
            if (GwmConfig.boostServerUtilitiesClaimsMarkers) {
                am.setBoostFlag(true);
            }
            am.setLineStyle(0, 0.0, 0);
            am.setFillStyle(0.2, team.getColor().getColor().rgb());
        }
        this.updateNeeded = false;
    }

    @SubscribeEvent
    public void onServerUtilitiesChunkModifiedEvent(ChunkModifiedEvent.Claim event) {
        this.updateNeeded = true;
    }

    @SubscribeEvent
    public void onServerUtilitiesChunkModifiedEvent(ChunkModifiedEvent.Unclaimed event) {
        this.updateNeeded = true;
    }

    @SubscribeEvent
    public void doUpdates(TickEvent.ServerTickEvent event) {
        if (this.updateNeeded && event.phase == TickEvent.Phase.START) {
            this.update();
        }
    }

    class UpdateSUClaimsGwmSubCommand
    extends GwmSubCommand {
        protected UpdateSUClaimsGwmSubCommand(String name) {
            super(name);
        }

        @Override
        protected void process(ICommandSender sender, String[] args) {
            ServerUtilitiesClaimedChunksMarkers.this.update();
        }
    }
}

