/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge.integration;

import com.google.common.collect.ImmutableSetMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.forge.ForgeWorld;
import org.dynmap.forge.GwmCommand;
import org.dynmap.forge.GwmConfig;
import org.dynmap.forge.GwmSubCommand;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;

public class ForgeChunkLoaderMarkers
extends DynmapCommonAPIListener {
    MarkerAPI markerAPI;
    DynmapCore fullAPI;
    MarkerSet markerSet;
    static ForgeChunkLoaderMarkers INSTANCE;
    HashMap<ForgeChunkManager.Ticket, ArrayList<String>> knownTickets = new HashMap();
    HashSet<ForgeChunkManager.Ticket> addedTickets = new HashSet();
    HashSet<ForgeChunkManager.Ticket> removedTickets = new HashSet();

    @Override
    public void apiEnabled(DynmapCommonAPI api) {
        INSTANCE = this;
        this.fullAPI = (DynmapCore)api;
        this.markerAPI = api.getMarkerAPI();
        GwmCommand.registerSubCommand(new UpdateChunksGwmSubCommand("updatechunks"));
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        this.markerSet = this.markerAPI.createMarkerSet("forgechunks", "Chunk Loading", null, false);
        this.markerSet.setHideByDefault(true);
    }

    void updateMarkersInt() {
        for (AreaMarker m : this.markerSet.getAreaMarkers()) {
            if (m == null) continue;
            m.deleteMarker();
        }
        this.knownTickets.clear();
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server.field_71305_c != null) {
            for (WorldServer world : server.field_71305_c) {
                ImmutableSetMultimap loaded = ForgeChunkManager.getPersistentChunksFor((World)world);
                for (ForgeChunkManager.Ticket ticket : loaded.values()) {
                    this.createMarkersForTicket(ticket);
                }
            }
        }
    }

    private void removeMarkersForTicket(ForgeChunkManager.Ticket ticket) {
        if (!this.knownTickets.containsKey(ticket)) {
            return;
        }
        ArrayList<String> markerNames = this.knownTickets.get(ticket);
        for (String markerName : markerNames) {
            AreaMarker m = this.markerSet.findAreaMarker(markerName);
            if (m == null) continue;
            m.deleteMarker();
        }
        this.knownTickets.remove(ticket);
    }

    private void createMarkersForTicket(ForgeChunkManager.Ticket ticket) {
        NBTTagCompound modData;
        if (this.knownTickets.containsKey(ticket)) {
            return;
        }
        ArrayList<String> markerNames = new ArrayList<String>();
        this.knownTickets.put(ticket, markerNames);
        String worldName = ForgeWorld.getWorldName(ticket.world);
        DynmapWorld world = this.fullAPI.getWorld(worldName);
        if (world == null || !world.isEnabled()) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int count = 0;
        for (ChunkCoordIntPair cp : ticket.getChunkList()) {
            if (minX > cp.field_77276_a) {
                minX = cp.field_77276_a;
            }
            if (maxX < cp.field_77276_a) {
                maxX = cp.field_77276_a;
            }
            if (minZ > cp.field_77275_b) {
                minZ = cp.field_77275_b;
            }
            if (maxZ < cp.field_77275_b) {
                maxZ = cp.field_77275_b;
            }
            ++count;
        }
        String label = "<b>MOD: </b>" + ticket.getModId();
        if (ticket.getPlayerName() != null) {
            label = label + "<br /><b>Player: </b> " + ticket.getPlayerName();
        }
        if ((modData = ticket.getModData()) != null) {
            for (Object ent : modData.func_150296_c()) {
                String strKey;
                NBTBase tmp;
                byte nbtType;
                if (!(ent instanceof String) || (nbtType = (tmp = modData.func_74781_a(strKey = (String)ent)).func_74732_a()) > 8 || nbtType == 7) continue;
                label = label + "<br /><b>" + strKey + ": </b> " + tmp;
            }
        }
        int ticketHash = ticket.hashCode();
        String markerBaseId = worldName + "_fclm_" + ticketHash;
        if ((maxX - minX + 1) * (maxZ - minZ + 1) == count) {
            double[] x = new double[]{minX * 16, maxX * 16 + 16};
            double[] z = new double[]{minZ * 16, maxZ * 16 + 16};
            AreaMarker m = this.markerSet.createAreaMarker(markerBaseId, label, true, worldName, x, z, false);
            m.setFillStyle(0.4, 0xFFFF00);
            m.setLineStyle(2, 0.5, 0xFFFF00);
            markerNames.add(markerBaseId);
        } else {
            int counter = 0;
            for (ChunkCoordIntPair cp : ticket.getChunkList()) {
                double[] x = new double[]{cp.field_77276_a * 16, cp.field_77276_a * 16 + 16};
                double[] z = new double[]{cp.field_77275_b * 16, cp.field_77275_b * 16 + 16};
                String id = markerBaseId + "_" + counter++;
                AreaMarker m = this.markerSet.createAreaMarker(id, label, true, worldName, x, z, false);
                m.setFillStyle(0.4, 0xFFFF00);
                m.setLineStyle(0, 0.0, 0);
                markerNames.add(id);
            }
        }
    }

    public static void updateMarkers() {
        if (INSTANCE != null) {
            INSTANCE.updateMarkersInt();
        }
    }

    @SubscribeEvent
    public void onForceChunk(ForgeChunkManager.ForceChunkEvent event) {
        if (GwmConfig.enableChunkLoadingMarkers) {
            this.addedTickets.add(event.ticket);
        }
    }

    @SubscribeEvent
    public void onUnforceChunk(ForgeChunkManager.UnforceChunkEvent event) {
        if (GwmConfig.enableChunkLoadingMarkers) {
            this.removedTickets.add(event.ticket);
        }
    }

    @SubscribeEvent
    public void doUpdates(TickEvent.ServerTickEvent event) {
        if (!this.removedTickets.isEmpty()) {
            for (ForgeChunkManager.Ticket t : this.removedTickets) {
                this.removeMarkersForTicket(t);
            }
            this.removedTickets.clear();
        }
        if (!this.addedTickets.isEmpty()) {
            for (ForgeChunkManager.Ticket t : this.addedTickets) {
                this.createMarkersForTicket(t);
            }
            this.addedTickets.clear();
        }
    }

    class UpdateChunksGwmSubCommand
    extends GwmSubCommand {
        protected UpdateChunksGwmSubCommand(String name) {
            super(name);
        }

        @Override
        protected void process(ICommandSender sender, String[] args) {
            ForgeChunkLoaderMarkers.updateMarkers();
            ForgeChunkLoaderMarkers.this.removedTickets.clear();
            ForgeChunkLoaderMarkers.this.addedTickets.clear();
        }
    }
}

