/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.dynmap.Log;

public class ChunkSnapshot {
    private final int x;
    private final int z;
    private final short[][] blockids;
    private final byte[][] blockdata;
    private final short[][] blockdata16;
    private final byte[][] skylight;
    private final byte[][] emitlight;
    private final boolean[] empty;
    private final int[] hmap;
    private final byte[] biome;
    private final long captureFulltime;
    private final int sectionCnt;
    private final long inhabitedTicks;
    private boolean have16bitBlockData;
    private static final int BLOCKS_PER_SECTION = 4096;
    private static final int COLUMNS_PER_CHUNK = 256;
    private static final short[] emptyIDs = new short[4096];
    private static final byte[] emptyData = new byte[2048];
    private static final byte[] fullData = new byte[2048];
    private static Method getvalarray = null;

    public ChunkSnapshot(int worldheight, int x, int z, long captime, long inhabitedTime) {
        this.x = x;
        this.z = z;
        this.captureFulltime = captime;
        this.biome = new byte[256];
        this.sectionCnt = worldheight / 16;
        this.blockids = new short[this.sectionCnt][];
        this.blockdata16 = new short[this.sectionCnt][];
        this.blockdata = new byte[this.sectionCnt][];
        this.skylight = new byte[this.sectionCnt][];
        this.emitlight = new byte[this.sectionCnt][];
        this.empty = new boolean[this.sectionCnt];
        for (int i = 0; i < this.sectionCnt; ++i) {
            this.empty[i] = true;
            this.blockids[i] = emptyIDs;
            this.blockdata16[i] = emptyIDs;
            this.blockdata[i] = emptyData;
            this.emitlight[i] = emptyData;
            this.skylight[i] = fullData;
        }
        this.hmap = new int[256];
        this.inhabitedTicks = inhabitedTime;
    }

    public ChunkSnapshot(NBTTagCompound nbt, int worldheight) {
        this.x = nbt.func_74762_e("xPos");
        this.z = nbt.func_74762_e("zPos");
        this.captureFulltime = 0L;
        this.hmap = nbt.func_74759_k("HeightMap");
        this.sectionCnt = worldheight / 16;
        this.inhabitedTicks = nbt.func_74764_b("InhabitedTime") ? nbt.func_74763_f("InhabitedTime") : 0L;
        this.blockids = new short[this.sectionCnt][];
        this.blockdata16 = new short[this.sectionCnt][];
        this.blockdata = new byte[this.sectionCnt][];
        this.skylight = new byte[this.sectionCnt][];
        this.emitlight = new byte[this.sectionCnt][];
        this.empty = new boolean[this.sectionCnt];
        for (int i = 0; i < this.sectionCnt; ++i) {
            this.empty[i] = true;
            this.blockids[i] = emptyIDs;
            this.blockdata16[i] = emptyIDs;
            this.blockdata[i] = emptyData;
            this.emitlight[i] = emptyData;
            this.skylight[i] = fullData;
        }
        NBTTagList sect = nbt.func_150295_c("Sections", 10);
        for (int i = 0; i < sect.func_74745_c(); ++i) {
            int b;
            NBTTagCompound sec = sect.func_150305_b(i);
            byte secnum = sec.func_74771_c("Y");
            if (secnum >= this.sectionCnt) {
                Log.info("Section " + secnum + " above world height " + worldheight);
                continue;
            }
            short[] blkids = new short[4096];
            this.blockids[secnum] = blkids;
            int len = 4096;
            byte[] blocks16 = sec.func_74770_j("Blocks16");
            if (blocks16 != null && blocks16.length > 0) {
                for (int b2 = 0; b2 < blkids.length; ++b2) {
                    blkids[b2] = (short)((0xFF & blocks16[2 * b2]) << 8 | 0xFF & blocks16[2 * b2 + 1]);
                }
            } else {
                byte[] lsb_bytes = sec.func_74770_j("Blocks");
                if (len > lsb_bytes.length) {
                    len = lsb_bytes.length;
                }
                for (int j = 0; j < len; ++j) {
                    blkids[j] = (short)(0xFF & lsb_bytes[j]);
                }
                if (sec.func_74764_b("Add")) {
                    len = 2048;
                    byte[] msb = sec.func_74770_j("Add");
                    if (len > msb.length) {
                        len = msb.length;
                    }
                    for (int j = 0; j < len; ++j) {
                        b = msb[j] & 0xFF;
                        if (b == 0) continue;
                        int n = j << 1;
                        blkids[n] = (short)(blkids[n] | (b & 0xF) << 8);
                        int n2 = (j << 1) + 1;
                        blkids[n2] = (short)(blkids[n2] | (b & 0xF0) << 4);
                    }
                }
            }
            this.blockdata[secnum] = sec.func_74770_j("Data");
            byte[] data16 = sec.func_74770_j("Data16");
            if (data16 != null && data16.length > 0) {
                this.have16bitBlockData = true;
                short[] blkdata = new short[4096];
                for (int b3 = 0; b3 < blkdata.length; ++b3) {
                    blkdata[b3] = (short)((0xFF & data16[2 * b3]) << 8 | 0xFF & data16[2 * b3 + 1]);
                }
                this.blockdata16[secnum] = blkdata;
                if (this.blockdata[secnum].length == 0) {
                    byte[] olddata = new byte[2048];
                    for (b = 0; b < olddata.length; ++b) {
                        olddata[b] = (byte)(blkdata[2 * b] & 0xF | (blkdata[2 * b + 1] & 0xF) << 4);
                    }
                    this.blockdata[secnum] = olddata;
                }
            }
            this.emitlight[secnum] = sec.func_74770_j("BlockLight");
            if (sec.func_74764_b("SkyLight")) {
                this.skylight[secnum] = sec.func_74770_j("SkyLight");
            }
            this.empty[secnum] = false;
        }
        this.biome = nbt.func_74764_b("Biomes") ? nbt.func_74770_j("Biomes") : new byte[256];
    }

    private static byte[] getValueArray(NibbleArray na) {
        if (getvalarray != null) {
            try {
                return (byte[])getvalarray.invoke((Object)na, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return na.field_76585_a;
    }

    public ChunkSnapshot(Chunk chunk, int worldheight) {
        this(worldheight, chunk.field_76635_g, chunk.field_76647_h, chunk.field_76637_e.func_72820_D(), chunk.field_111204_q);
        System.arraycopy(chunk.func_76605_m(), 0, this.biome, 0, 256);
        ExtendedBlockStorage[] ebs = chunk.func_76587_i();
        for (int i = 0; i < this.sectionCnt; ++i) {
            ExtendedBlockStorage eb;
            ExtendedBlockStorage extendedBlockStorage = eb = i < ebs.length ? ebs[i] : null;
            if (eb == null || eb.func_76663_a()) continue;
            this.empty[i] = false;
            byte[] baseids = eb.func_76658_g();
            short[] blockids = new short[4096];
            for (int j = 0; j < 4096; ++j) {
                blockids[j] = (short)(baseids[j] & 0xFF);
            }
            NibbleArray msb = eb.func_76660_i();
            if (msb != null) {
                byte[] extids = ChunkSnapshot.getValueArray(msb);
                for (int j = 0; j < extids.length; ++j) {
                    short b = (short)(extids[j] & 0xFF);
                    if (b == 0) continue;
                    int n = j << 1;
                    blockids[n] = (short)(blockids[n] | (b & 0xF) << 8);
                    int n2 = (j << 1) + 1;
                    blockids[n2] = (short)(blockids[n2] | (b & 0xF0) << 4);
                }
            }
            this.blockids[i] = blockids;
            this.blockdata[i] = new byte[2048];
            System.arraycopy(ChunkSnapshot.getValueArray(eb.func_76669_j()), 0, this.blockdata[i], 0, 2048);
            this.emitlight[i] = new byte[2048];
            System.arraycopy(ChunkSnapshot.getValueArray(eb.func_76661_k()), 0, this.emitlight[i], 0, 2048);
            if (eb.func_76671_l() != null) {
                this.skylight[i] = new byte[2048];
                System.arraycopy(ChunkSnapshot.getValueArray(eb.func_76671_l()), 0, this.skylight[i], 0, 2048);
                continue;
            }
            this.skylight[i] = emptyData;
        }
        System.arraycopy(chunk.field_76634_f, 0, this.hmap, 0, this.hmap.length);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getBlockTypeId(int x, int y, int z) {
        if (y > 255) {
            return 0;
        }
        return this.blockids[y >> 4][(y & 0xF) << 8 | z << 4 | x];
    }

    public int getBlockData(int x, int y, int z) {
        if (y > 255) {
            return 0;
        }
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.blockdata[y >> 4][off] >> ((x & 1) << 2) & 0xF;
    }

    public int getBlockSkyLight(int x, int y, int z) {
        if (y > 255) {
            return 15;
        }
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.skylight[y >> 4][off] >> ((x & 1) << 2) & 0xF;
    }

    public int getBlockEmittedLight(int x, int y, int z) {
        if (y > 255) {
            return 0;
        }
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.emitlight[y >> 4][off] >> ((x & 1) << 2) & 0xF;
    }

    public int getHighestBlockYAt(int x, int z) {
        return this.hmap[z << 4 | x];
    }

    public int getBiome(int x, int z) {
        return 0xFF & this.biome[z << 4 | x];
    }

    public final long getCaptureFullTime() {
        return this.captureFulltime;
    }

    public boolean isSectionEmpty(int sy) {
        return this.empty[sy];
    }

    public long getInhabitedTicks() {
        return this.inhabitedTicks;
    }

    public int getBlockDataFull(int bx, int y, int bz) {
        if (y > 255) {
            return 0;
        }
        if (this.have16bitBlockData) {
            int tmp = this.blockdata16[y >> 4][(y & 0xF) << 8 | bz << 4 | bx];
            if (tmp < 0) {
                tmp += 65536;
            }
            return tmp;
        }
        return this.getBlockData(bx, y, bz);
    }

    static {
        for (int i = 0; i < fullData.length; ++i) {
            ChunkSnapshot.fullData[i] = -1;
        }
        try {
            Method[] m;
            for (Method mm : m = NibbleArray.class.getDeclaredMethods()) {
                if (!mm.getName().equals("getValueArray")) continue;
                getvalarray = mm;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

