/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.exporter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.IndexedVector3D;
import org.dynmap.utils.IndexedVector3DList;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.PatchDefinition;
import org.dynmap.utils.PatchDefinitionFactory;

public class OBJExport {
    private final File destZipFile;
    private final HDShader shader;
    private final DynmapWorld world;
    private final DynmapCore core;
    private final String basename;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private static Charset UTF8 = Charset.forName("UTF-8");
    private ZipOutputStream zos;
    private double originX;
    private double originY;
    private double originZ;
    private double scale = 1.0;
    private boolean centerOrigin = true;
    private PatchDefinition[] defaultPathces;
    private HashSet<String> matIDs = new HashSet();
    private HashMap<String, List<Face>> facesByTexture = new HashMap();
    private static final int MODELSCALE = 16;
    private static final double BLKSIZE = 0.0625;
    public static final int GROUP_CHUNK = 0;
    public static final int GROUP_TEXTURE = 1;
    public static final int GROUP_BLOCKID = 2;
    public static final int GROUP_BLOCKIDMETA = 3;
    public static final int GROUP_COUNT = 4;
    private String[] group = new String[4];
    private boolean[] enabledGroups = new boolean[4];
    private String groupline = null;
    private IndexedVector3DList vertices;
    private IndexedVector3DList uvs;
    private HDBlockModels.HDScaledBlockModels models;
    public static final int ROT0 = 0;
    public static final int ROT90 = 1;
    public static final int ROT180 = 2;
    public static final int ROT270 = 3;
    public static final int HFLIP = 4;
    private static final double[][] pp = new double[][]{{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0}};

    public OBJExport(File dest, HDShader shader, DynmapWorld world, DynmapCore core, String basename) {
        this.destZipFile = dest;
        this.shader = shader;
        this.world = world;
        this.core = core;
        this.basename = basename;
        this.defaultPathces = new PatchDefinition[6];
        PatchDefinitionFactory fact = HDBlockModels.getPatchDefinitionFactory();
        for (BlockStep s : BlockStep.values()) {
            double[] p = pp[s.getFaceEntered()];
            int ord = s.ordinal();
            this.defaultPathces[ord] = fact.getPatch(p[0], p[1], p[2], p[3], p[4], p[5], p[6], p[7], p[8], 0.0, 1.0, 0.0, 1.0, 100.0, RenderPatchFactory.SideVisible.TOP, ord);
        }
        this.vertices = new IndexedVector3DList(new IndexedVector3DList.ListCallback(){

            @Override
            public void elementAdded(IndexedVector3DList list, IndexedVector3D newElement) {
                try {
                    OBJExport.this.addStringToExportedFile(String.format(Locale.US, "v %.4f %.4f %.4f\n", (newElement.x - OBJExport.this.originX) * OBJExport.this.scale, (newElement.y - OBJExport.this.originY) * OBJExport.this.scale, (newElement.z - OBJExport.this.originZ) * OBJExport.this.scale));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.uvs = new IndexedVector3DList(new IndexedVector3DList.ListCallback(){

            @Override
            public void elementAdded(IndexedVector3DList list, IndexedVector3D newElement) {
                try {
                    OBJExport.this.addStringToExportedFile(String.format(Locale.US, "vt %.4f %.4f\n", newElement.x, newElement.y));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.models = HDBlockModels.getModelsForScale(16);
    }

    public void setRenderBounds(int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (minx < maxx) {
            this.minX = minx;
            this.maxX = maxx;
        } else {
            this.minX = maxx;
            this.maxX = minx;
        }
        if (miny < maxy) {
            this.minY = miny;
            this.maxY = maxy;
        } else {
            this.minY = maxy;
            this.maxY = miny;
        }
        if (minz < maxz) {
            this.minZ = minz;
            this.maxZ = maxz;
        } else {
            this.minZ = maxz;
            this.maxZ = minz;
        }
        if (this.minY < 0) {
            this.minY = 0;
        }
        if (this.maxY >= this.world.worldheight) {
            this.maxY = this.world.worldheight - 1;
        }
        if (this.centerOrigin) {
            this.originX = (double)(this.maxX + this.minX) / 2.0;
            this.originY = this.minY;
            this.originZ = (double)(this.maxZ + this.minZ) / 2.0;
        }
    }

    public void setOrigin(double ox, double oy, double oz) {
        this.originX = ox;
        this.originY = oy;
        this.originZ = oz;
        this.centerOrigin = false;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processExport(DynmapCommandSender sender) {
        boolean good = false;
        try {
            this.zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.destZipFile)));
            ArrayList<DynmapChunk> requiredChunks = new ArrayList<DynmapChunk>();
            int mincx = this.minX >> 4;
            int maxcx = this.maxX + 15 >> 4;
            int mincz = this.minZ >> 4;
            int maxcz = this.maxZ + 15 >> 4;
            boolean[] edgebits = new boolean[6];
            this.startExportedFile(this.basename + ".obj");
            this.addStringToExportedFile("mtllib " + this.basename + ".mtl\n");
            for (int cx = mincx; cx <= maxcx; cx += 4) {
                for (int cz = mincz; cz <= maxcz; cz += 4) {
                    requiredChunks.clear();
                    for (int i = -1; i < 5; ++i) {
                        for (int j = -1; j < 5; ++j) {
                            if (cx + i > maxcx || cz + j > maxcz || cx + i < mincx || cz + j < mincz) continue;
                            requiredChunks.add(new DynmapChunk(cx + i, cz + j));
                        }
                    }
                    MapChunkCache cache = this.core.getServer().createMapChunkCache(this.world, requiredChunks, true, false, true, false);
                    if (cache == null) {
                        throw new IOException("Error loading chunk cache");
                    }
                    MapIterator iter = cache.getIterator(this.minX, this.minY, this.minZ);
                    for (int x = cx * 16; x < cx * 16 + 64 && x <= this.maxX; ++x) {
                        if (x < this.minX) {
                            x = this.minX;
                        }
                        edgebits[BlockStep.X_PLUS.ordinal()] = x == this.minX;
                        edgebits[BlockStep.X_MINUS.ordinal()] = x == this.maxX;
                        for (int z = cz * 16; z < cz * 16 + 64 && z <= this.maxZ; ++z) {
                            if (z < this.minZ) {
                                z = this.minZ;
                            }
                            edgebits[BlockStep.Z_PLUS.ordinal()] = z == this.minZ;
                            edgebits[BlockStep.Z_MINUS.ordinal()] = z == this.maxZ;
                            iter.initialize(x, this.minY, z);
                            this.updateGroup(0, "chunk" + (x >> 4) + "_" + (z >> 4));
                            edgebits[BlockStep.Y_MINUS.ordinal()] = true;
                            edgebits[BlockStep.Y_PLUS.ordinal()] = false;
                            int id = iter.getBlockTypeID();
                            if (id > 0) {
                                this.handleBlock(id, iter, edgebits);
                            }
                            edgebits[BlockStep.Y_MINUS.ordinal()] = false;
                            for (int y = this.minY + 1; y < this.maxY; ++y) {
                                iter.setY(y);
                                id = iter.getBlockTypeID();
                                if (id <= 0) continue;
                                this.handleBlock(id, iter, edgebits);
                            }
                            edgebits[BlockStep.Y_PLUS.ordinal()] = true;
                            iter.setY(this.maxY);
                            id = iter.getBlockTypeID();
                            if (id <= 0) continue;
                            this.handleBlock(id, iter, edgebits);
                        }
                    }
                    String grp = "";
                    for (String material : this.facesByTexture.keySet()) {
                        List<Face> faces = this.facesByTexture.get(material);
                        this.matIDs.add(material);
                        this.addStringToExportedFile(String.format("usemtl %s\n", material));
                        for (Face face : faces) {
                            if (face.groupLine != null && !face.groupLine.equals(grp)) {
                                grp = face.groupLine;
                                this.addStringToExportedFile(grp);
                            }
                            this.addStringToExportedFile(face.faceLine);
                        }
                    }
                    this.facesByTexture.clear();
                    this.vertices.resetSet(this.minX, this.minY, this.minZ, cx * 16 + 64, this.maxY, cz * 16 + 64);
                }
            }
            this.finishExportedFile();
            if (this.shader != null) {
                sender.sendMessage("Adding textures from shader " + this.shader.getName());
                this.shader.exportAsMaterialLibrary(sender, this);
                sender.sendMessage("Texture export completed");
            }
            this.zos.finish();
            this.zos.close();
            this.zos = null;
            good = true;
            sender.sendMessage("Export completed - " + this.destZipFile.getPath());
        }
        catch (IOException iox) {
            sender.sendMessage("Export failed: " + iox.getMessage());
        }
        finally {
            if (this.zos != null) {
                try {
                    this.zos.close();
                }
                catch (IOException iOException) {}
                this.zos = null;
                this.destZipFile.delete();
            }
        }
        return good;
    }

    public void startExportedFile(String fname) throws IOException {
        ZipEntry ze = new ZipEntry(fname);
        this.zos.putNextEntry(ze);
    }

    public void addBytesToExportedFile(byte[] buf, int off, int len) throws IOException {
        this.zos.write(buf, off, len);
    }

    public void addStringToExportedFile(String str) throws IOException {
        byte[] b = str.getBytes(UTF8);
        this.zos.write(b, 0, b.length);
    }

    public void finishExportedFile() throws IOException {
        this.zos.closeEntry();
    }

    private void handleBlock(int blkid, MapIterator map, boolean[] edgebits) throws IOException {
        CustomRendererData crd;
        HDBlockModels.CustomBlockModel cbm;
        int renderdata;
        BlockStep[] steps = BlockStep.values();
        int[] txtidx = null;
        int data = map.getBlockData();
        RenderPatch[] patches = this.models.getPatchModel(blkid, data, renderdata = HDBlockModels.getBlockRenderData(blkid, map));
        if (patches == null && (cbm = this.models.getCustomBlockModel(blkid, data)) != null && (crd = cbm.getMeshForBlock(map)) != null) {
            patches = crd.getCustomMesh();
        }
        if (patches != null) {
            steps = new BlockStep[patches.length];
            txtidx = new int[patches.length];
            for (int i = 0; i < txtidx.length; ++i) {
                txtidx[i] = ((PatchDefinition)patches[i]).getTextureIndex();
                steps[i] = ((PatchDefinition)patches[i]).step;
            }
        } else {
            short[] smod = this.models.getScaledModel(blkid, data, renderdata);
            if (smod != null) {
                patches = this.getScaledModelAsPatches(smod);
                steps = new BlockStep[patches.length];
                txtidx = new int[patches.length];
                for (int i = 0; i < patches.length; ++i) {
                    PatchDefinition pd = (PatchDefinition)patches[i];
                    steps[i] = pd.step;
                    txtidx[i] = pd.getTextureIndex();
                }
            }
        }
        this.updateGroup(2, "blk" + blkid);
        this.updateGroup(3, "blk" + blkid + "_" + data);
        String[] mats = this.shader.getCurrentBlockMaterials(blkid, data, renderdata, map, txtidx, steps);
        if (patches != null) {
            for (int i = 0; i < patches.length; ++i) {
                this.addPatch((PatchDefinition)patches[i], map.getX(), map.getY(), map.getZ(), mats[i]);
            }
        } else {
            boolean opaque = TexturePack.HDTextureMap.getTransparency(blkid) == TexturePack.BlockTransparency.OPAQUE;
            for (int face = 0; face < 6; ++face) {
                int id2 = map.getBlockTypeIDAt(BlockStep.oppositeValues[face]);
                if (opaque && id2 != 0 && !edgebits[face] && TexturePack.HDTextureMap.getTransparency(id2) == TexturePack.BlockTransparency.OPAQUE) continue;
                this.addPatch(this.defaultPathces[face], map.getX(), map.getY(), map.getZ(), mats[face]);
            }
        }
    }

    private int[] getTextureUVs(PatchDefinition pd, int rot) {
        int[] uv = new int[4];
        if (rot == 0) {
            uv[0] = this.uvs.getVectorIndex(pd.umin, pd.vmin, 0.0);
            uv[1] = this.uvs.getVectorIndex(pd.umax, pd.vmin, 0.0);
            uv[2] = this.uvs.getVectorIndex(pd.umax, pd.vmax, 0.0);
            uv[3] = this.uvs.getVectorIndex(pd.umin, pd.vmax, 0.0);
        } else if (rot == 1) {
            uv[0] = this.uvs.getVectorIndex(1.0 - pd.vmin, pd.umin, 0.0);
            uv[1] = this.uvs.getVectorIndex(1.0 - pd.vmin, pd.umax, 0.0);
            uv[2] = this.uvs.getVectorIndex(1.0 - pd.vmax, pd.umax, 0.0);
            uv[3] = this.uvs.getVectorIndex(1.0 - pd.vmax, pd.umin, 0.0);
        } else if (rot == 2) {
            uv[0] = this.uvs.getVectorIndex(1.0 - pd.umin, 1.0 - pd.vmin, 0.0);
            uv[1] = this.uvs.getVectorIndex(1.0 - pd.umax, 1.0 - pd.vmin, 0.0);
            uv[2] = this.uvs.getVectorIndex(1.0 - pd.umax, 1.0 - pd.vmax, 0.0);
            uv[3] = this.uvs.getVectorIndex(1.0 - pd.umin, 1.0 - pd.vmax, 0.0);
        } else if (rot == 3) {
            uv[0] = this.uvs.getVectorIndex(pd.vmin, 1.0 - pd.umin, 0.0);
            uv[1] = this.uvs.getVectorIndex(pd.vmin, 1.0 - pd.umax, 0.0);
            uv[2] = this.uvs.getVectorIndex(pd.vmax, 1.0 - pd.umax, 0.0);
            uv[3] = this.uvs.getVectorIndex(pd.vmax, 1.0 - pd.umin, 0.0);
        } else if (rot == 4) {
            uv[0] = this.uvs.getVectorIndex(1.0 - pd.umin, pd.vmin, 0.0);
            uv[1] = this.uvs.getVectorIndex(1.0 - pd.umax, pd.vmin, 0.0);
            uv[2] = this.uvs.getVectorIndex(1.0 - pd.umax, pd.vmax, 0.0);
            uv[3] = this.uvs.getVectorIndex(1.0 - pd.umin, pd.vmax, 0.0);
        } else {
            uv[0] = this.uvs.getVectorIndex(pd.umin, pd.vmin, 0.0);
            uv[1] = this.uvs.getVectorIndex(pd.umax, pd.vmin, 0.0);
            uv[2] = this.uvs.getVectorIndex(pd.umax, pd.vmax, 0.0);
            uv[3] = this.uvs.getVectorIndex(pd.umin, pd.vmax, 0.0);
        }
        return uv;
    }

    private void addPatch(PatchDefinition pd, double x, double y, double z, String material) throws IOException {
        if (material == null) {
            return;
        }
        int rot = 0;
        int rotidx = material.indexOf(64);
        if (rotidx >= 0) {
            rot = material.charAt(rotidx + 1) - 48;
            material = material.substring(0, rotidx);
        }
        int[] v = new int[4];
        int[] uv = this.getTextureUVs(pd, rot);
        double ux = pd.xu - pd.x0;
        double uy = pd.yu - pd.y0;
        double uz = pd.zu - pd.z0;
        double vx = pd.xv - pd.x0;
        double vy = pd.yv - pd.y0;
        double vz = pd.zv - pd.z0;
        v[0] = this.vertices.getVectorIndex((x += pd.x0) + ux * pd.umin + vx * pd.vmin, (y += pd.y0) + uy * pd.umin + vy * pd.vmin, (z += pd.z0) + uz * pd.umin + vz * pd.vmin);
        uv[0] = this.uvs.getVectorIndex(pd.umin, pd.vmin, 0.0);
        v[1] = this.vertices.getVectorIndex(x + ux * pd.umax + vx * pd.vmin, y + uy * pd.umax + vy * pd.vmin, z + uz * pd.umax + vz * pd.vmin);
        uv[1] = this.uvs.getVectorIndex(pd.umax, pd.vmin, 0.0);
        v[2] = this.vertices.getVectorIndex(x + ux * pd.umax + vx * pd.vmax, y + uy * pd.umax + vy * pd.vmax, z + uz * pd.umax + vz * pd.vmax);
        uv[2] = this.uvs.getVectorIndex(pd.umax, pd.vmax, 0.0);
        v[3] = this.vertices.getVectorIndex(x + ux * pd.umin + vx * pd.vmax, y + uy * pd.umin + vy * pd.vmax, z + uz * pd.umin + vz * pd.vmax);
        uv[3] = this.uvs.getVectorIndex(pd.umin, pd.vmax, 0.0);
        this.addPatchToFile(v, uv, pd.sidevis, material, rot);
    }

    private void addPatchToFile(int[] v, int[] uv, RenderPatchFactory.SideVisible sv, String material, int rot) throws IOException {
        int[] newuv;
        List<Face> faces = this.facesByTexture.get(material);
        if (faces == null) {
            faces = new ArrayList<Face>();
            this.facesByTexture.put(material, faces);
        }
        if (rot == 4) {
            newuv = new int[uv.length];
            for (int i = 0; i < uv.length; ++i) {
                newuv[i] = uv[i ^ 1];
            }
            uv = newuv;
        } else if (rot != 0) {
            newuv = new int[uv.length];
            for (int i = 0; i < uv.length; ++i) {
                newuv[i] = uv[(i + 4 - rot) % uv.length];
            }
            uv = newuv;
        }
        Face f = new Face();
        f.groupLine = this.updateGroup(1, material);
        switch (sv) {
            case TOP: {
                f.faceLine = String.format("f %d/%d %d/%d %d/%d %d/%d\n", v[0], uv[0], v[1], uv[1], v[2], uv[2], v[3], uv[3]);
                break;
            }
            case BOTTOM: {
                f.faceLine = String.format("f %d/%d %d/%d %d/%d %d/%d\n", v[3], uv[3], v[2], uv[2], v[1], uv[1], v[0], uv[0]);
                break;
            }
            case BOTH: {
                f.faceLine = String.format("f %d/%d %d/%d %d/%d %d/%d\n", v[0], uv[0], v[1], uv[1], v[2], uv[2], v[3], uv[3]);
                f.faceLine = f.faceLine + String.format("f %d/%d %d/%d %d/%d %d/%d\n", v[3], uv[3], v[2], uv[2], v[1], uv[1], v[0], uv[0]);
                break;
            }
            case FLIP: {
                f.faceLine = String.format("f %d/%d %d/%d %d/%d %d/%d\n", v[0], uv[0], v[1], uv[1], v[2], uv[2], v[3], uv[3]);
                f.faceLine = f.faceLine + String.format("f %d/%d %d/%d %d/%d %d/%d\n", v[3], uv[2], v[2], uv[3], v[1], uv[0], v[0], uv[1]);
            }
        }
        faces.add(f);
    }

    public Set<String> getMaterialIDs() {
        return this.matIDs;
    }

    private static final boolean getSubblock(short[] mod, int x, int y, int z) {
        if (x >= 0 && x < 16 && y >= 0 && y < 16 && z >= 0 && z < 16) {
            return mod[256 * y + 16 * z + x] != 0;
        }
        return false;
    }

    private int scanX(short[] tmod, int x, int y, int z) {
        int xlen = 0;
        while (OBJExport.getSubblock(tmod, x + xlen, y, z)) {
            ++xlen;
        }
        return xlen;
    }

    private int scanZ(short[] tmod, int x, int y, int z, int xlen) {
        int zlen = 0;
        while (this.scanX(tmod, x, y, z + zlen) >= xlen) {
            ++zlen;
        }
        return zlen;
    }

    private int scanY(short[] tmod, int x, int y, int z, int xlen, int zlen) {
        int ylen = 0;
        while (this.scanZ(tmod, x, y + ylen, z, xlen) >= zlen) {
            ++ylen;
        }
        return ylen;
    }

    private void addSubblock(short[] tmod, int x, int y, int z, List<RenderPatch> list) {
        int xlen = this.scanX(tmod, x, y, z);
        int zlen = this.scanZ(tmod, x, y, z, xlen);
        int ylen = this.scanY(tmod, x, y, z, xlen, zlen);
        CustomRenderer.addBox(HDBlockModels.getPatchDefinitionFactory(), list, 0.0625 * (double)x, 0.0625 * (double)(x + xlen), 0.0625 * (double)y, 0.0625 * (double)(y + ylen), 0.0625 * (double)z, 0.0625 * (double)(z + zlen), HDBlockModels.boxPatchList);
        for (int xx = 0; xx < xlen; ++xx) {
            for (int yy = 0; yy < ylen; ++yy) {
                for (int zz = 0; zz < zlen; ++zz) {
                    tmod[256 * (y + yy) + 16 * (z + zz) + (x + xx)] = 0;
                }
            }
        }
    }

    private PatchDefinition[] getScaledModelAsPatches(short[] mod) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        short[] tmod = Arrays.copyOf(mod, mod.length);
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    if (!OBJExport.getSubblock(tmod, x, y, z)) continue;
                    this.addSubblock(tmod, x, y, z, list);
                }
            }
        }
        PatchDefinition[] pd = new PatchDefinition[list.size()];
        for (int i = 0; i < pd.length; ++i) {
            pd[i] = (PatchDefinition)list.get(i);
        }
        return pd;
    }

    private String updateGroup(int grpIndex, String newgroup) {
        if (this.enabledGroups[grpIndex] && !newgroup.equals(this.group[grpIndex])) {
            this.group[grpIndex] = newgroup;
            String newline = "g";
            for (int i = 0; i < 4; ++i) {
                if (!this.enabledGroups[i]) continue;
                newline = newline + " " + this.group[i];
            }
            this.groupline = newline = newline + "\n";
        }
        return this.groupline;
    }

    public boolean getGroupEnabled(int grpIndex) {
        if (grpIndex < this.enabledGroups.length) {
            return this.enabledGroups[grpIndex];
        }
        return false;
    }

    public void setGroupEnabled(int grpIndex, boolean set) {
        if (grpIndex < this.enabledGroups.length) {
            this.enabledGroups[grpIndex] = set;
        }
    }

    public String getBaseName() {
        return this.basename;
    }

    private static class Face {
        String groupLine;
        String faceLine;

        private Face() {
        }
    }
}

