/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.handlers;

import codechicken.microblock.ItemSaw;
import com.enderio.core.EnderCore;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.handlers.ClientHandler;
import com.enderio.core.common.Handlers;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import team.chisel.item.chisel.ItemChisel;

@Handlers.Handler
public enum SpecialTooltipHandler {
    INSTANCE;

    private final List<ITooltipCallback> callbacks = Lists.newArrayList();
    private static final List<String> throwaway;

    public void addCallback(ITooltipCallback callback) {
        this.callbacks.add(callback);
    }

    @SubscribeEvent
    public void addTooltip(ItemTooltipEvent evt) {
        boolean doDurability;
        if (evt.itemStack == null) {
            return;
        }
        boolean shiftDown = SpecialTooltipHandler.showAdvancedTooltips();
        boolean debugMode = Minecraft.func_71410_x().field_71474_y.field_82882_x;
        boolean bl = ConfigHandler.showDurabilityTooltips == 3 ? debugMode : (ConfigHandler.showDurabilityTooltips == 2 ? shiftDown : (doDurability = ConfigHandler.showDurabilityTooltips == 1));
        if (doDurability) {
            this.addDurabilityTooltip(evt.toolTip, evt.itemStack);
        }
        if (evt.itemStack.func_77973_b() instanceof IAdvancedTooltipProvider) {
            IAdvancedTooltipProvider ttp = (IAdvancedTooltipProvider)evt.itemStack.func_77973_b();
            this.addInformation(ttp, evt.itemStack, evt.entityPlayer, evt.toolTip, false);
            return;
        }
        if (evt.itemStack.func_77973_b() instanceof IResourceTooltipProvider) {
            this.addInformation((IResourceTooltipProvider)evt.itemStack.func_77973_b(), evt);
            return;
        }
        Block blk = Block.func_149634_a((Item)evt.itemStack.func_77973_b());
        if (blk instanceof IAdvancedTooltipProvider) {
            this.addInformation((IAdvancedTooltipProvider)blk, evt.itemStack, evt.entityPlayer, evt.toolTip, false);
            return;
        }
        if (blk instanceof IResourceTooltipProvider) {
            this.addInformation((IResourceTooltipProvider)blk, evt);
            return;
        }
        for (ITooltipCallback callback : this.callbacks) {
            if (!callback.shouldHandleItem(evt.itemStack)) continue;
            this.addInformation(callback, evt.itemStack, evt.entityPlayer, evt.toolTip, false);
        }
    }

    public void addDurabilityTooltip(List<String> toolTip, ItemStack itemStack) {
        if (!itemStack.func_77984_f()) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemTool || item instanceof ItemArmor || item instanceof ItemSword || item instanceof ItemHoe || item instanceof ItemBow) {
            toolTip.add(ItemUtil.getDurabilityString(itemStack));
        }
        if (Loader.isModLoaded((String)"chisel") && item instanceof ItemChisel) {
            toolTip.add(ItemUtil.getDurabilityString(itemStack));
        }
        if (Loader.isModLoaded((String)"ForgeMultipart") && item instanceof ItemSaw) {
            toolTip.add(ItemUtil.getDurabilityString(itemStack));
        }
    }

    public void addInformation(IResourceTooltipProvider item, ItemTooltipEvent evt) {
        this.addInformation(item, evt.itemStack, evt.entityPlayer, evt.toolTip);
    }

    public void addInformation(IResourceTooltipProvider tt, ItemStack itemstack, EntityPlayer entityplayer, List list) {
        String name = tt.getUnlocalizedNameForTooltip(itemstack);
        if (SpecialTooltipHandler.showAdvancedTooltips()) {
            SpecialTooltipHandler.addCommonTooltipFromResources(list, name);
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, name);
        } else {
            SpecialTooltipHandler.addBasicTooltipFromResources(list, name);
            SpecialTooltipHandler.addCommonTooltipFromResources(list, name);
            if (SpecialTooltipHandler.hasDetailedTooltip(tt, itemstack)) {
                SpecialTooltipHandler.addShowDetailsTooltip(list);
            }
        }
    }

    public void addInformation(IAdvancedTooltipProvider tt, ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        tt.addCommonEntries(itemstack, entityplayer, list, flag);
        if (SpecialTooltipHandler.showAdvancedTooltips()) {
            tt.addDetailedEntries(itemstack, entityplayer, list, flag);
        } else {
            tt.addBasicEntries(itemstack, entityplayer, list, flag);
            if (SpecialTooltipHandler.hasDetailedTooltip(tt, itemstack, entityplayer, flag)) {
                SpecialTooltipHandler.addShowDetailsTooltip(list);
            }
        }
    }

    private static boolean hasDetailedTooltip(IResourceTooltipProvider tt, ItemStack stack) {
        throwaway.clear();
        String name = tt.getUnlocalizedNameForTooltip(stack);
        SpecialTooltipHandler.addDetailedTooltipFromResources(throwaway, name);
        return !throwaway.isEmpty();
    }

    private static boolean hasDetailedTooltip(IAdvancedTooltipProvider tt, ItemStack stack, EntityPlayer player, boolean flag) {
        throwaway.clear();
        tt.addDetailedEntries(stack, player, throwaway, flag);
        return !throwaway.isEmpty();
    }

    public static void addShowDetailsTooltip(List list) {
        list.add(EnumChatFormatting.WHITE + "" + EnumChatFormatting.ITALIC + EnderCore.lang.localize("tooltip.showDetails"));
    }

    public static boolean showAdvancedTooltips() {
        return ClientHandler.isShiftDown();
    }

    public static void addDetailedTooltipFromResources(List list, String unlocalizedName) {
        SpecialTooltipHandler.addTooltipFromResources(list, unlocalizedName.concat(".tooltip.detailed.line"));
    }

    public static void addBasicTooltipFromResources(List list, String unlocalizedName) {
        SpecialTooltipHandler.addTooltipFromResources(list, unlocalizedName.concat(".tooltip.basic.line"));
    }

    public static void addCommonTooltipFromResources(List list, String unlocalizedName) {
        SpecialTooltipHandler.addTooltipFromResources(list, unlocalizedName.concat(".tooltip.common.line"));
    }

    public static void addTooltipFromResources(List list, String keyBase) {
        boolean done = false;
        int line = 1;
        while (!done) {
            String key = keyBase + line;
            String val = EnderCore.lang.localizeExact(key);
            if (val == null || val.trim().length() < 0 || val.equals(key) || line > 12) {
                done = true;
                continue;
            }
            list.add(val);
            ++line;
        }
    }

    private static String getUnlocalizedNameForTooltip(ItemStack itemstack) {
        String unlocalizedNameForTooltip = null;
        if (itemstack.func_77973_b() instanceof IResourceTooltipProvider) {
            unlocalizedNameForTooltip = ((IResourceTooltipProvider)itemstack.func_77973_b()).getUnlocalizedNameForTooltip(itemstack);
        }
        if (unlocalizedNameForTooltip == null) {
            unlocalizedNameForTooltip = itemstack.func_77973_b().func_77667_c(itemstack);
        }
        return unlocalizedNameForTooltip;
    }

    public static void addCommonTooltipFromResources(List list, ItemStack itemstack) {
        if (itemstack.func_77973_b() == null) {
            return;
        }
        SpecialTooltipHandler.addCommonTooltipFromResources(list, SpecialTooltipHandler.getUnlocalizedNameForTooltip(itemstack));
    }

    public static void addDetailedTooltipFromResources(List list, ItemStack itemstack) {
        if (itemstack.func_77973_b() == null) {
            return;
        }
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, SpecialTooltipHandler.getUnlocalizedNameForTooltip(itemstack));
    }

    static {
        throwaway = new ArrayList<String>();
    }

    public static interface ITooltipCallback
    extends IAdvancedTooltipProvider {
        public boolean shouldHandleItem(ItemStack var1);
    }
}

