/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen;

import com.hbm.config.StructureConfig;
import com.hbm.main.StructureManager;
import com.hbm.world.gen.MapGenNTMFeatures;
import com.hbm.world.gen.component.BunkerComponents;
import com.hbm.world.gen.nbt.JigsawPiece;
import com.hbm.world.gen.nbt.NBTStructure;
import com.hbm.world.gen.nbt.SpawnCondition;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.event.world.WorldEvent;

public class NTMWorldGenerator
implements IWorldGenerator {
    private NBTStructure.GenStructure nbtGen = new NBTStructure.GenStructure();
    private final Random rand = new Random();
    private boolean hasPopulationEvent = false;

    public static boolean isInvalidBiome(BiomeGenBase biome) {
        return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER);
    }

    public static boolean isFlatBiome(BiomeGenBase biome) {
        return biome.field_76749_E <= 0.2f && !NTMWorldGenerator.isInvalidBiome(biome) && BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPARSE);
    }

    public NTMWorldGenerator() {
        NBTStructure.registerStructure(0, new SpawnCondition("spire"){
            {
                this.canSpawn = biome -> biome.field_76749_E <= 0.05f && !NTMWorldGenerator.isInvalidBiome(biome);
                this.structure = new JigsawPiece("spire", StructureManager.spire, -1);
                this.spawnWeight = StructureConfig.spireSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("features"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome);
                this.start = d -> new MapGenNTMFeatures.Start((World)d.getW(), (Random)d.getX(), (Integer)d.getY(), (Integer)d.getZ());
                this.spawnWeight = StructureConfig.featuresSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("bunker"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome);
                this.start = d -> new BunkerComponents.BunkerStart((World)d.getW(), (Random)d.getX(), (Integer)d.getY(), (Integer)d.getZ());
                this.spawnWeight = StructureConfig.bunkerSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("vertibird"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
                this.structure = new JigsawPiece("vertibird", StructureManager.vertibird, -3);
                this.spawnWeight = StructureConfig.vertibirdSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("crashed_vertibird"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
                this.structure = new JigsawPiece("crashed_vertibird", StructureManager.crashed_vertibird, -10);
                this.spawnWeight = StructureConfig.vertibirdCrashedSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("beached_patrol"){
            {
                this.canSpawn = biome -> BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
                this.structure = new JigsawPiece("beached_patrol", StructureManager.beached_patrol, -5);
                this.minHeight = 58;
                this.maxHeight = 67;
                this.spawnWeight = StructureConfig.beachedPatrolSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("aircraft_carrier"){
            {
                this.canSpawn = biome -> BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
                this.structure = new JigsawPiece("aircraft_carrier", StructureManager.aircraft_carrier, -6);
                this.maxHeight = 42;
                this.spawnWeight = StructureConfig.enableOceanStructures ? StructureConfig.aircraftCarrierSpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("oil_rig"){
            {
                this.canSpawn = biome -> BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && biome.field_76748_D >= -1.5f;
                this.structure = new JigsawPiece("oil_rig", StructureManager.oil_rig, -20);
                this.maxHeight = 12;
                this.minHeight = 11;
                this.spawnWeight = StructureConfig.enableOceanStructures ? StructureConfig.oilRigSpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("lighthouse"){
            {
                this.canSpawn = biome -> BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
                this.structure = new JigsawPiece("lighthouse", StructureManager.lighthouse, -40);
                this.maxHeight = 29;
                this.minHeight = 28;
                this.spawnWeight = StructureConfig.enableOceanStructures ? StructureConfig.lighthouseSpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("dish"){
            {
                this.canSpawn = biome -> BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS);
                this.structure = new JigsawPiece("dish", StructureManager.dish, -10);
                this.minHeight = 53;
                this.maxHeight = 65;
                this.spawnWeight = StructureConfig.dishSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("forestchem"){
            {
                this.canSpawn = biome -> biome.field_76749_E <= 0.3f && !NTMWorldGenerator.isInvalidBiome(biome);
                this.structure = new JigsawPiece("forest_chem", StructureManager.forest_chem, -9);
                this.spawnWeight = StructureConfig.forestChemSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("labolatory"){
            {
                this.canSpawn = biome -> NTMWorldGenerator.isFlatBiome(biome);
                this.structure = new JigsawPiece("laboratory", StructureManager.laboratory, -10);
                this.minHeight = 53;
                this.maxHeight = 65;
                this.spawnWeight = StructureConfig.laboratorySpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("forest_post"){
            {
                this.canSpawn = biome -> biome.field_76749_E <= 0.3f && !NTMWorldGenerator.isInvalidBiome(biome);
                this.structure = new JigsawPiece("forest_post", StructureManager.forest_post, -10);
                this.spawnWeight = StructureConfig.forestPostSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("radio"){
            {
                this.canSpawn = biome -> NTMWorldGenerator.isFlatBiome(biome);
                this.structure = new JigsawPiece("radio_house", StructureManager.radio_house, -6);
                this.spawnWeight = StructureConfig.radioSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("factory"){
            {
                this.canSpawn = biome -> NTMWorldGenerator.isFlatBiome(biome);
                this.structure = new JigsawPiece("factory", StructureManager.factory, -10);
                this.spawnWeight = StructureConfig.factorySpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("crane"){
            {
                this.canSpawn = biome -> NTMWorldGenerator.isFlatBiome(biome);
                this.structure = new JigsawPiece("crane", StructureManager.crane, -9);
                this.spawnWeight = StructureConfig.craneSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("broadcaster_tower"){
            {
                this.canSpawn = biome -> NTMWorldGenerator.isFlatBiome(biome);
                this.structure = new JigsawPiece("broadcaster_tower", StructureManager.broadcasting_tower, -9);
                this.spawnWeight = StructureConfig.broadcastingTowerSpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("plane1"){
            {
                this.canSpawn = biome -> biome.field_76749_E <= 0.3f && !NTMWorldGenerator.isInvalidBiome(biome);
                this.structure = new JigsawPiece("crashed_plane_1", StructureManager.plane1, -5);
                this.spawnWeight = StructureConfig.plane1SpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("plane2"){
            {
                this.canSpawn = biome -> biome.field_76749_E <= 0.3f && !NTMWorldGenerator.isInvalidBiome(biome);
                this.structure = new JigsawPiece("crashed_plane_2", StructureManager.plane2, -8);
                this.spawnWeight = StructureConfig.plane2SpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("desert_shack_1"){
            {
                this.canSpawn = biome -> BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
                this.structure = new JigsawPiece("desert_shack_1", StructureManager.desert_shack_1, -7);
                this.spawnWeight = StructureConfig.desertShack1SpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("desert_shack_2"){
            {
                this.canSpawn = biome -> BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
                this.structure = new JigsawPiece("desert_shack_2", StructureManager.desert_shack_2, -7);
                this.spawnWeight = StructureConfig.desertShack2SpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("desert_shack_3"){
            {
                this.canSpawn = biome -> BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
                this.structure = new JigsawPiece("desert_shack_3", StructureManager.desert_shack_3, -5);
                this.spawnWeight = StructureConfig.desertShack3SpawnWeight;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinA"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsA", StructureManager.ntmruinsA, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsASpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinB"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsB", StructureManager.ntmruinsB, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsBSpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinC"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsC", StructureManager.ntmruinsC, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsCSpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinD"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsD", StructureManager.ntmruinsD, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsDSpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinE"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsE", StructureManager.ntmruinsE, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsESpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinF"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsF", StructureManager.ntmruinsF, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsFSpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinG"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsG", StructureManager.ntmruinsG, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsGSpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinH"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsH", StructureManager.ntmruinsH, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsHSpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinI"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsI", StructureManager.ntmruinsI, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsISpawnWeight : 0;
            }
        });
        NBTStructure.registerStructure(0, new SpawnCondition("ruinJ"){
            {
                this.canSpawn = biome -> !NTMWorldGenerator.isInvalidBiome(biome) && biome.func_76738_d();
                this.structure = new JigsawPiece("NTMRuinsJ", StructureManager.ntmruinsJ, -1){
                    {
                        this.conformToTerrain = true;
                    }
                };
                this.spawnWeight = StructureConfig.enableRuins ? StructureConfig.ruinsJSpawnWeight : 0;
            }
        });
        NBTStructure.registerNullWeight(0, StructureConfig.plainsNullWeight, biome -> biome == BiomeGenBase.field_76772_c);
        NBTStructure.registerNullWeight(0, StructureConfig.oceanNullWeight, biome -> BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        this.nbtGen = (NBTStructure.GenStructure)TerrainGen.getModdedMapGen((MapGenBase)new NBTStructure.GenStructure(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CUSTOM);
        this.hasPopulationEvent = false;
    }

    private void setRandomSeed(World world, int chunkX, int chunkZ) {
        this.rand.setSeed(world.func_72905_C() + (long)world.field_73011_w.field_76574_g);
        long i = this.rand.nextLong() / 2L * 2L + 1L;
        long j = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i + (long)chunkZ * j ^ world.func_72905_C());
    }

    @SubscribeEvent
    public void generateStructures(PopulateChunkEvent.Pre event) {
        this.hasPopulationEvent = true;
        if (StructureConfig.enableStructures == 0) {
            return;
        }
        if (StructureConfig.enableStructures == 2 && !event.world.func_72912_H().func_76089_r()) {
            return;
        }
        this.setRandomSeed(event.world, event.chunkX, event.chunkZ);
        this.nbtGen.generateStructures(event.world, this.rand, event.chunkProvider, event.chunkX, event.chunkZ);
    }

    public void generate(Random unusedRandom, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.hasPopulationEvent) {
            return;
        }
        if (StructureConfig.enableStructures == 0) {
            return;
        }
        if (StructureConfig.enableStructures == 2 && !world.func_72912_H().func_76089_r()) {
            return;
        }
        this.setRandomSeed(world, chunkX, chunkZ);
        this.nbtGen.generateStructures(world, this.rand, chunkProvider, chunkX, chunkZ);
    }

    public SpawnCondition getStructureAt(World world, int chunkX, int chunkZ) {
        if (StructureConfig.enableStructures == 0) {
            return null;
        }
        if (StructureConfig.enableStructures == 2 && !world.func_72912_H().func_76089_r()) {
            return null;
        }
        this.setRandomSeed(world, chunkX, chunkZ);
        return this.nbtGen.getStructureAt(world, chunkX, chunkZ);
    }
}

