/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.wiaj;

import com.hbm.wiaj.JarScript;
import com.hbm.wiaj.actions.IJarAction;
import java.util.ArrayList;
import java.util.List;

public class JarScene {
    public List<IJarAction> actions = new ArrayList<IJarAction>();
    public JarScript script;
    public int actionNumber = 0;
    public IJarAction currentAction;
    public int currentActionStart = 0;

    public JarScene(JarScript script) {
        this.script = script;
    }

    public JarScene add(IJarAction action) {
        if (this.currentAction == null) {
            this.currentAction = action;
        }
        this.actions.add(action);
        return this;
    }

    public void tick() {
        if (this.currentAction == null) {
            return;
        }
        this.currentAction.act(this.script.world, this);
        int duration = this.currentAction.getDuration();
        if (this.currentActionStart + duration <= this.script.ticksElapsed) {
            ++this.actionNumber;
            this.currentActionStart = this.script.ticksElapsed;
            if (this.actionNumber < this.actions.size()) {
                this.currentAction = this.actions.get(this.actionNumber);
                this.tick();
            } else {
                this.currentAction = null;
            }
        }
    }

    public void reset() {
        this.currentAction = this.actions.get(0);
        this.actionNumber = 0;
        this.currentActionStart = this.script.ticksElapsed;
    }
}

