/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ColorUtil {
    public static HashMap<String, Integer> nameToColor = new HashMap(){
        {
            this.put("black", 0x1E1B1B);
            this.put("red", 11743532);
            this.put("green", 3887386);
            this.put("brown", 5320730);
            this.put("blue", 2437522);
            this.put("purple", 8073150);
            this.put("cyan", 2651799);
            this.put("silver", 0xABABAB);
            this.put("lightgray", 0xABABAB);
            this.put("gray", 0x434343);
            this.put("pink", 14188952);
            this.put("lime", 4312372);
            this.put("yellow", 14602026);
            this.put("lightblue", 6719955);
            this.put("magenta", 12801229);
            this.put("orange", 15435844);
            this.put("white", 0xF0F0F0);
        }
    };

    @SideOnly(value=Side.CLIENT)
    public static BufferedImage getImageFromStack(ItemStack stack) throws IOException {
        String iconName = stack.func_77973_b().func_77617_a(stack.func_77960_j()).func_94215_i();
        String domain = "minecraft";
        if (iconName.contains(":")) {
            String[] parts = iconName.split(":");
            domain = parts[0];
            iconName = parts[1];
        }
        ResourceLocation loc = new ResourceLocation(domain, "textures/items/" + iconName + ".png");
        return ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(loc).func_110527_b());
    }

    @SideOnly(value=Side.CLIENT)
    public static int getAverageColorFromStack(ItemStack stack) {
        try {
            BufferedImage tex = ColorUtil.getImageFromStack(stack);
            int r = 0;
            int g = 0;
            int b = 0;
            int pixels = 0;
            for (int i = 0; i < tex.getWidth(); ++i) {
                for (int j = 0; j < tex.getHeight(); ++j) {
                    Color pixel = new Color(tex.getRGB(i, j));
                    if (pixel.getAlpha() != 255) continue;
                    r += pixel.getRed();
                    g += pixel.getGreen();
                    b += pixel.getBlue();
                    ++pixels;
                }
            }
            int avgR = r / pixels;
            int avgG = g / pixels;
            int avgB = b / pixels;
            return avgR << 16 | avgG << 8 | avgB;
        }
        catch (Exception ex) {
            return 0xFFFFFF;
        }
    }

    public static int ir(int color) {
        return (color & 0xFF0000) >> 16;
    }

    public static int ig(int color) {
        return (color & 0xFF00) >> 8;
    }

    public static int ib(int color) {
        return (color & 0xFF) >> 0;
    }

    public static float fr(int color) {
        return (float)ColorUtil.ir(color) / 255.0f;
    }

    public static float fg(int color) {
        return (float)ColorUtil.ig(color) / 255.0f;
    }

    public static float fb(int color) {
        return (float)ColorUtil.ib(color) / 255.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getMedianBrightnessColorFromStack(ItemStack stack) {
        try {
            BufferedImage tex = ColorUtil.getImageFromStack(stack);
            HashMap<Integer, Color> brightMap = new HashMap<Integer, Color>();
            ArrayList<Integer> brightnesses = new ArrayList<Integer>();
            for (int i = 0; i < tex.getWidth(); ++i) {
                for (int j = 0; j < tex.getHeight(); ++j) {
                    Color pixel = new Color(tex.getRGB(i, j));
                    int brightness = pixel.getRed() * pixel.getRed() + pixel.getGreen() * pixel.getGreen() + pixel.getBlue() * pixel.getBlue();
                    brightnesses.add(brightness);
                    brightMap.put(brightness, pixel);
                }
            }
            Collections.sort(brightnesses);
            int median = (Integer)brightnesses.get(brightnesses.size() / 2);
            Color medianColor = (Color)brightMap.get(median);
            return medianColor.getRGB();
        }
        catch (Exception ex) {
            return 0xFFFFFF;
        }
    }

    public static boolean isColorColorful(int hex) {
        Color color = new Color(hex);
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        return (double)hsb[1] > 0.25 && (double)hsb[2] > 0.25;
    }

    public static int amplifyColor(int hex, int limit) {
        Color color = new Color(hex);
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int max = Math.max(Math.max(1, r), Math.max(g, b));
        r = r * limit / max;
        g = g * limit / max;
        b = b * limit / max;
        return new Color(r, g, b).getRGB();
    }

    public static int amplifyColor(int hex) {
        return ColorUtil.amplifyColor(hex, 255);
    }

    public static int lightenColor(int hex, double percent) {
        Color color = new Color(hex);
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        r = (int)((double)r + (double)(255 - r) * percent);
        g = (int)((double)g + (double)(255 - g) * percent);
        b = (int)((double)b + (double)(255 - b) * percent);
        return new Color(r, g, b).getRGB();
    }

    public static double getColorBrightness(int hex) {
        Color color = new Color(hex);
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        return hsb[2];
    }

    public static int getColorFromDye(ItemStack stack) {
        List<String> oreNames = ItemStackUtil.getOreDictNames(stack);
        for (String dict : oreNames) {
            String color;
            if (dict.length() <= 3 || !dict.startsWith("dye") || !nameToColor.containsKey(color = dict.substring(3).toLowerCase(Locale.US))) continue;
            return nameToColor.get(color);
        }
        return 0;
    }
}

