/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.fusion;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerFusionKlystron;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIFusionKlystron;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.fusion.TileEntityFusionTorus;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.NodeNet;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.KlystronNetwork;
import com.hbm.uninos.networkproviders.KlystronNetworkProvider;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFusionKlystron
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardReceiverMK2,
IControlReceiver,
IGUIProvider {
    protected GenNode klystronNode;
    public static final long MAX_OUTPUT = 1000000L;
    public static final int AIR_CONSUMPTION = 2500;
    public long outputTarget;
    public long output;
    public long power;
    public long maxPower;
    public float fan;
    public float prevFan;
    public float fanSpeed;
    public static final float FAN_ACCELERATION = 0.125f;
    public FluidTank compair = new FluidTank(Fluids.AIR, 150000);
    private AudioWrapper audio;
    AxisAlignedBB bb = null;

    public TileEntityFusionKlystron() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.fusionKlystron";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.maxPower = Math.max(1000000L, this.outputTarget * 100L);
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.maxPower);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos);
                this.trySubscribe(this.compair.getTankType(), this.field_145850_b, pos);
            }
            this.output = 0L;
            double powerFactor = TileEntityFusionTorus.getSpeedScaled(this.maxPower, this.power);
            double airFactor = TileEntityFusionTorus.getSpeedScaled(this.compair.getMaxFill(), this.compair.getFill());
            double factor = Math.min(powerFactor, airFactor);
            long powerReq = (long)Math.ceil((double)this.outputTarget * factor);
            int airReq = (int)Math.ceil(2500.0 * factor);
            if (this.outputTarget > 0L && this.power >= powerReq && this.compair.getFill() >= airReq) {
                this.output = powerReq;
                this.power -= powerReq;
                this.compair.setFill(this.compair.getFill() - airReq);
            }
            if (this.output < this.outputTarget / 50L) {
                this.output = 0L;
            }
            if (this.klystronNode == null || this.klystronNode.expired) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
                this.klystronNode = UniNodespace.getNode(this.field_145850_b, this.field_145851_c + dir.offsetX * 4, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 4, KlystronNetworkProvider.THE_PROVIDER);
                if (this.klystronNode == null) {
                    this.klystronNode = new GenNode<KlystronNetwork>(KlystronNetworkProvider.THE_PROVIDER, new BlockPos(this.field_145851_c + dir.offsetX * 4, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 4)).setConnections(new DirPos(this.field_145851_c + dir.offsetX * 5, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 5, dir));
                    UniNodespace.createNode(this.field_145850_b, this.klystronNode);
                }
            }
            if (this.klystronNode.net != null) {
                ((NodeNet)this.klystronNode.net).addProvider((TileEntityFusionKlystron)this);
            }
            if (this.klystronNode != null && this.klystronNode.net != null) {
                KlystronNetwork net = (KlystronNetwork)this.klystronNode.net;
                for (Map.Entry o : net.receiverEntries.entrySet()) {
                    TileEntityFusionTorus torus;
                    Map.Entry e = o;
                    if (!(e.getKey() instanceof TileEntityFusionTorus) || !(torus = (TileEntityFusionTorus)e.getKey()).isLoaded() || torus.func_145837_r()) continue;
                    torus.klystronEnergy += this.output;
                    break;
                }
            }
            this.networkPackNT(100);
        } else {
            double mult = TileEntityFusionTorus.getSpeedScaled(this.outputTarget, this.output);
            this.fanSpeed = this.output > 0L ? (float)((double)this.fanSpeed + 0.125 * mult) : (this.fanSpeed -= 0.125f);
            this.fanSpeed = MathHelper.func_76131_a((float)this.fanSpeed, (float)0.0f, (float)(5.0f * (float)mult));
            this.prevFan = this.fan;
            this.fan += this.fanSpeed;
            if (this.fan >= 360.0f) {
                this.fan -= 360.0f;
                this.prevFan -= 360.0f;
            }
            if (this.fanSpeed > 0.0f && MainRegistry.proxy.me().func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 2.5, (double)this.field_145849_e + 0.5) < 900.0) {
                float speed = this.fanSpeed / 5.0f;
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.fel", (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 2.5f, (float)this.field_145849_e + 0.5f, this.getVolume(speed), 15.0f, speed, 20);
                    this.audio.startSound();
                } else {
                    this.audio.updateVolume(this.getVolume(speed));
                    this.audio.updatePitch(speed);
                    this.audio.keepAlive();
                }
            } else if (this.audio != null) {
                if (this.audio.isPlaying()) {
                    this.audio.stopSound();
                }
                this.audio = null;
            }
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 4, dir), new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ * 3, rot.getOpposite())};
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
        if (!this.field_145850_b.field_72995_K && this.klystronNode != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.klystronNode);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.maxPower);
        buf.writeLong(this.outputTarget);
        buf.writeLong(this.output);
        this.compair.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.maxPower = buf.readLong();
        this.outputTarget = buf.readLong();
        this.output = buf.readLong();
        this.compair.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.outputTarget = nbt.func_74763_f("outputTarget");
        this.compair.readFromNBT(nbt, "t");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        nbt.func_74772_a("outputTarget", this.outputTarget);
        this.compair.writeToNBT(nbt, "t");
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.compair};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.compair};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFusionKlystron(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFusionKlystron(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)this.field_145848_d, (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 5));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 2.5, (double)this.field_145849_e + 0.5) < 400.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("amount")) {
            this.outputTarget = data.func_74763_f("amount");
            if (this.outputTarget < 0L) {
                this.outputTarget = 0L;
            }
            if (this.outputTarget > 1000000L) {
                this.outputTarget = 1000000L;
            }
        }
    }
}

