/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySteamEngine
extends TileEntityLoadedBase
implements IEnergyProviderMK2,
IFluidStandardTransceiver,
IBufPacketReceiver,
IConfigurableMachine,
IFluidCopiable {
    public long powerBuffer;
    public float rotor;
    public float lastRotor;
    private float syncRotor;
    public FluidTank[] tanks = new FluidTank[2];
    private int turnProgress;
    private float acceleration = 0.0f;
    private static int steamCap = 2000;
    private static int ldsCap = 20;
    private static double efficiency = 0.85;
    ByteBuf buf;

    public TileEntitySteamEngine() {
        this.tanks[0] = new FluidTank(Fluids.STEAM, steamCap);
        this.tanks[1] = new FluidTank(Fluids.SPENTSTEAM, ldsCap);
    }

    @Override
    public String getConfigName() {
        return "steamengine";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        steamCap = IConfigurableMachine.grab(obj, "I:steamCap", steamCap);
        ldsCap = IConfigurableMachine.grab(obj, "I:ldsCap", ldsCap);
        efficiency = IConfigurableMachine.grab(obj, "D:efficiency", efficiency);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:steamCap").value((long)steamCap);
        writer.name("I:ldsCap").value((long)ldsCap);
        writer.name("D:efficiency").value(efficiency);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.buf != null) {
                this.buf.release();
            }
            this.buf = Unpooled.buffer();
            this.powerBuffer = 0L;
            this.tanks[0].setTankType(Fluids.STEAM);
            this.tanks[1].setTankType(Fluids.SPENTSTEAM);
            this.tanks[0].serialize(this.buf);
            FT_Coolable trait = this.tanks[0].getTankType().getTrait(FT_Coolable.class);
            double eff = trait.getEfficiency(FT_Coolable.CoolingType.TURBINE) * efficiency;
            int inputOps = this.tanks[0].getFill() / trait.amountReq;
            int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / trait.amountProduced;
            int ops = Math.min(inputOps, outputOps);
            this.tanks[0].setFill(this.tanks[0].getFill() - ops * trait.amountReq);
            this.tanks[1].setFill(this.tanks[1].getFill() + ops * trait.amountProduced);
            this.powerBuffer = (long)((double)this.powerBuffer + (double)(ops * trait.heatEnergy) * eff);
            this.acceleration = ops > 0 ? (this.acceleration += 0.1f) : (this.acceleration -= 0.1f);
            this.acceleration = MathHelper.func_76131_a((float)this.acceleration, (float)0.0f, (float)40.0f);
            this.rotor += this.acceleration;
            if ((double)this.rotor >= 360.0) {
                this.rotor = (float)((double)this.rotor - 360.0);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.steamEngineOperate", this.getVolume(1.0f), 0.5f + this.acceleration / 80.0f);
            }
            this.buf.writeLong(this.powerBuffer);
            this.buf.writeFloat(this.rotor);
            this.tanks[1].serialize(this.buf);
            for (DirPos pos : this.getConPos()) {
                if (this.powerBuffer > 0L) {
                    this.tryProvide(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.networkPackNT(150);
        } else {
            this.lastRotor = this.rotor;
            if (this.turnProgress > 0) {
                double d = MathHelper.func_76138_g((double)((double)this.syncRotor - (double)this.rotor));
                this.rotor = (float)((double)this.rotor + d / (double)this.turnProgress);
                --this.turnProgress;
            } else {
                this.rotor = this.syncRotor;
            }
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 + dir.offsetX, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * 2 + dir.offsetZ, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ, rot)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.powerBuffer = nbt.func_74763_f("powerBuffer");
        this.acceleration = nbt.func_74760_g("acceleration");
        this.tanks[0].readFromNBT(nbt, "s");
        this.tanks[1].readFromNBT(nbt, "w");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerBuffer", this.powerBuffer);
        nbt.func_74776_a("acceleration", this.acceleration);
        this.tanks[0].writeToNBT(nbt, "s");
        this.tanks[1].writeToNBT(nbt, "w");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.DOWN && dir != ForgeDirection.UNKNOWN;
    }

    @Override
    public long getPower() {
        return this.powerBuffer;
    }

    @Override
    public long getMaxPower() {
        return this.powerBuffer;
    }

    @Override
    public void setPower(long power) {
        this.powerBuffer = power;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeBytes(this.buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.tanks[0].deserialize(buf);
        this.powerBuffer = buf.readLong();
        this.syncRotor = buf.readFloat();
        this.tanks[1].deserialize(buf);
        this.turnProgress = 3;
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

