/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.item.IDesignatorItem;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.missile.EntityMissileAntiBallistic;
import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.entity.missile.EntityMissileShuttle;
import com.hbm.entity.missile.EntityMissileStealth;
import com.hbm.entity.missile.EntityMissileTier0;
import com.hbm.entity.missile.EntityMissileTier1;
import com.hbm.entity.missile.EntityMissileTier2;
import com.hbm.entity.missile.EntityMissileTier3;
import com.hbm.entity.missile.EntityMissileTier4;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IBomb;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerLaunchPadLarge;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUILaunchPadLarge;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IRadarCommandReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.TrackerUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public abstract class TileEntityLaunchPadBase
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardReceiver,
IGUIProvider,
IRadarCommandReceiver,
SimpleComponent,
CompatHandler.OCComponent,
IFluidCopiable {
    public static final HashMap<RecipesCommon.ComparableStack, Class<? extends EntityMissileBaseNT>> missiles = new HashMap();
    public ItemStack toRender;
    public long power;
    public final long maxPower = 100000L;
    public int prevRedstonePower;
    public int redstonePower;
    public Set<BlockPos> activatedBlocks = new HashSet<BlockPos>(4);
    public int state = 0;
    public static final int STATE_MISSING = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_READY = 2;
    public FluidTank[] tanks = new FluidTank[2];

    public static void registerLaunchables() {
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_test), EntityMissileTier0.EntityMissileTest.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_micro), EntityMissileTier0.EntityMissileMicro.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_schrabidium), EntityMissileTier0.EntityMissileSchrabidium.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_bhole), EntityMissileTier0.EntityMissileBHole.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_taint), EntityMissileTier0.EntityMissileTaint.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_emp), EntityMissileTier0.EntityMissileEMP.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_generic), EntityMissileTier1.EntityMissileGeneric.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_decoy), EntityMissileTier1.EntityMissileDecoy.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_incendiary), EntityMissileTier1.EntityMissileIncendiary.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_cluster), EntityMissileTier1.EntityMissileCluster.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_buster), EntityMissileTier1.EntityMissileBunkerBuster.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_strong), EntityMissileTier2.EntityMissileStrong.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_incendiary_strong), EntityMissileTier2.EntityMissileIncendiaryStrong.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_cluster_strong), EntityMissileTier2.EntityMissileClusterStrong.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_buster_strong), EntityMissileTier2.EntityMissileBusterStrong.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_emp_strong), EntityMissileTier2.EntityMissileEMPStrong.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_burst), EntityMissileTier3.EntityMissileBurst.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_inferno), EntityMissileTier3.EntityMissileInferno.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_rain), EntityMissileTier3.EntityMissileRain.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_drill), EntityMissileTier3.EntityMissileDrill.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_shuttle), EntityMissileShuttle.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_nuclear), EntityMissileTier4.EntityMissileNuclear.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_nuclear_cluster), EntityMissileTier4.EntityMissileMirv.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_volcano), EntityMissileTier4.EntityMissileVolcano.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_doomsday), EntityMissileTier4.EntityMissileDoomsday.class);
        missiles.put(new RecipesCommon.ComparableStack(ModItems.missile_stealth), EntityMissileStealth.class);
    }

    public TileEntityLaunchPadBase() {
        super(7);
        this.tanks[0] = new FluidTank(Fluids.NONE, 24000);
        this.tanks[1] = new FluidTank(Fluids.NONE, 24000);
    }

    @Override
    public String getName() {
        return "container.launchPad";
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && this.isMissileValid(stack);
    }

    public abstract DirPos[] getConPos();

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    if (this.tanks[0].getTankType() != Fluids.NONE) {
                        this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    }
                    if (this.tanks[1].getTankType() == Fluids.NONE) continue;
                    this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            if (this.redstonePower > 0 && this.prevRedstonePower <= 0) {
                this.launchFromDesignator();
            }
            this.prevRedstonePower = this.redstonePower;
            this.power = Library.chargeTEFromItems(this.slots, 2, this.power, 100000L);
            this.tanks[0].loadTank(3, 4, this.slots);
            this.tanks[1].loadTank(5, 6, this.slots);
            if (this.isMissileValid() && this.slots[0].func_77973_b() instanceof ItemMissile) {
                ItemMissile missile = (ItemMissile)this.slots[0].func_77973_b();
                this.setFuel(missile);
            }
            this.networkPackNT(250);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.state);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
        if (this.slots[0] != null) {
            buf.writeBoolean(true);
            buf.writeInt(Item.func_150891_b((Item)this.slots[0].func_77973_b()));
            buf.writeShort((int)((short)this.slots[0].func_77960_j()));
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.state = buf.readInt();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.toRender = buf.readBoolean() ? new ItemStack(Item.func_150899_d((int)buf.readInt()), 1, (int)buf.readShort()) : null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
        this.redstonePower = nbt.func_74762_e("redstonePower");
        this.prevRedstonePower = nbt.func_74762_e("prevRedstonePower");
        NBTTagCompound activatedBlocks = nbt.func_74775_l("activatedBlocks");
        this.activatedBlocks.clear();
        for (int i = 0; i < activatedBlocks.func_150296_c().size() / 3; ++i) {
            this.activatedBlocks.add(new BlockPos(activatedBlocks.func_74762_e("x" + i), activatedBlocks.func_74762_e("y" + i), activatedBlocks.func_74762_e("z" + i)));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
        nbt.func_74768_a("redstonePower", this.redstonePower);
        nbt.func_74768_a("prevRedstonePower", this.prevRedstonePower);
        NBTTagCompound activatedBlocks = new NBTTagCompound();
        int i = 0;
        for (BlockPos p : this.activatedBlocks) {
            activatedBlocks.func_74768_a("x" + i, p.getX());
            activatedBlocks.func_74768_a("y" + i, p.getY());
            activatedBlocks.func_74768_a("z" + i, p.getZ());
            ++i;
        }
        nbt.func_74782_a("activatedBlocks", (NBTBase)activatedBlocks);
    }

    public void updateRedstonePower(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        boolean powered = this.field_145850_b.func_72864_z(x, y, z);
        boolean contained = this.activatedBlocks.contains(pos);
        if (!contained && powered) {
            this.activatedBlocks.add(pos);
            if (this.redstonePower == -1) {
                this.redstonePower = 0;
            }
            ++this.redstonePower;
        } else if (contained && !powered) {
            this.activatedBlocks.remove(pos);
            --this.redstonePower;
            if (this.redstonePower == 0) {
                this.redstonePower = -1;
            }
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.DOWN;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerLaunchPadLarge(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUILaunchPadLarge(player.field_71071_by, this);
    }

    public void setFuel(ItemMissile missile) {
        switch (missile.fuel) {
            case ETHANOL_PEROXIDE: {
                this.tanks[0].setTankType(Fluids.ETHANOL);
                this.tanks[1].setTankType(Fluids.PEROXIDE);
                break;
            }
            case KEROSENE_PEROXIDE: {
                this.tanks[0].setTankType(Fluids.KEROSENE);
                this.tanks[1].setTankType(Fluids.PEROXIDE);
                break;
            }
            case KEROSENE_LOXY: {
                this.tanks[0].setTankType(Fluids.KEROSENE);
                this.tanks[1].setTankType(Fluids.OXYGEN);
                break;
            }
            case JETFUEL_LOXY: {
                this.tanks[0].setTankType(Fluids.KEROSENE_REFORM);
                this.tanks[1].setTankType(Fluids.OXYGEN);
            }
        }
    }

    public boolean isMissileValid() {
        return this.slots[0] != null && this.isMissileValid(this.slots[0]);
    }

    public boolean isMissileValid(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemMissile && ((ItemMissile)stack.func_77973_b()).launchable;
    }

    public boolean hasFuel() {
        if (this.power < 75000L) {
            return false;
        }
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemMissile) {
            ItemMissile missile = (ItemMissile)this.slots[0].func_77973_b();
            if (this.tanks[0].getFill() < missile.fuelCap) {
                return false;
            }
            return this.tanks[1].getFill() >= missile.fuelCap;
        }
        return false;
    }

    public Entity instantiateMissile(int targetX, int targetZ) {
        if (this.slots[0] == null) {
            return null;
        }
        Class<? extends EntityMissileBaseNT> clazz = missiles.get(new RecipesCommon.ComparableStack(this.slots[0]).makeSingular());
        if (clazz != null) {
            try {
                EntityMissileBaseNT missile = clazz.getConstructor(World.class, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE).newInstance(this.field_145850_b, Float.valueOf((float)this.field_145851_c + 0.5f), Float.valueOf((float)this.field_145848_d + (float)this.getLaunchOffset()), Float.valueOf((float)this.field_145849_e + 0.5f), targetX, targetZ);
                if (GeneralConfig.enableExtendedLogging) {
                    MainRegistry.logger.log(Level.INFO, "[MISSILE] Tried to launch missile at " + this.field_145851_c + " / " + this.field_145848_d + " / " + this.field_145849_e + " to " + this.field_145851_c + " / " + this.field_145849_e + "!");
                }
                missile.func_70096_w().func_75692_b(3, (Object)((byte)MathHelper.func_76125_a((int)(this.func_145832_p() - 10), (int)2, (int)5)));
                return missile;
            }
            catch (Exception missile) {
                // empty catch block
            }
        }
        if (this.slots[0].func_77973_b() == ModItems.missile_anti_ballistic) {
            EntityMissileAntiBallistic missile = new EntityMissileAntiBallistic(this.field_145850_b);
            missile.field_70165_t = (double)this.field_145851_c + 0.5;
            missile.field_70163_u = (double)this.field_145848_d + this.getLaunchOffset();
            missile.field_70161_v = (double)this.field_145849_e + 0.5;
            return missile;
        }
        return null;
    }

    public void finalizeLaunch(Entity missile) {
        this.field_145850_b.func_72838_d(missile);
        TrackerUtil.setTrackingRange(this.field_145850_b, missile, 500);
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, "hbm:weapon.missileTakeOff", 2.0f, 1.0f);
        this.power -= 75000L;
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemMissile) {
            ItemMissile item = (ItemMissile)this.slots[0].func_77973_b();
            this.tanks[0].setFill(this.tanks[0].getFill() - item.fuelCap);
            this.tanks[1].setFill(this.tanks[1].getFill() - item.fuelCap);
        }
        this.func_70298_a(0, 1);
    }

    public IBomb.BombReturnCode launchFromDesignator() {
        if (!this.canLaunch()) {
            return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
        }
        boolean needsDesignator = this.needsDesignator(this.slots[0].func_77973_b());
        int targetX = this.field_145851_c;
        int targetZ = this.field_145849_e;
        if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IDesignatorItem) {
            IDesignatorItem designator = (IDesignatorItem)this.slots[1].func_77973_b();
            if (needsDesignator) {
                if (!designator.isReady(this.field_145850_b, this.slots[1], this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
                }
                Vec3 coords = designator.getCoords(this.field_145850_b, this.slots[1], this.field_145851_c, this.field_145848_d, this.field_145849_e);
                targetX = (int)Math.floor(coords.field_72450_a);
                targetZ = (int)Math.floor(coords.field_72449_c);
            }
        } else if (needsDesignator) {
            return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
        }
        return this.launchToCoordinate(targetX, targetZ);
    }

    public IBomb.BombReturnCode launchToEntity(Entity entity) {
        if (!this.canLaunch()) {
            return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
        }
        Entity e = this.instantiateMissile((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70161_v));
        if (e != null) {
            if (e instanceof EntityMissileAntiBallistic) {
                EntityMissileAntiBallistic abm = (EntityMissileAntiBallistic)e;
                abm.tracking = entity;
            }
            this.finalizeLaunch(e);
            return IBomb.BombReturnCode.LAUNCHED;
        }
        return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
    }

    public IBomb.BombReturnCode launchToCoordinate(int targetX, int targetZ) {
        if (!this.canLaunch()) {
            return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
        }
        Entity e = this.instantiateMissile(targetX, targetZ);
        if (e != null) {
            this.finalizeLaunch(e);
            return IBomb.BombReturnCode.LAUNCHED;
        }
        return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
    }

    @Override
    public boolean sendCommandPosition(int x, int y, int z) {
        return this.launchToCoordinate(x, z) == IBomb.BombReturnCode.LAUNCHED;
    }

    @Override
    public boolean sendCommandEntity(Entity target) {
        return this.launchToEntity(target) == IBomb.BombReturnCode.LAUNCHED;
    }

    public boolean needsDesignator(Item item) {
        return item != ModItems.missile_anti_ballistic;
    }

    public boolean canLaunch() {
        return this.isMissileValid() && this.hasFuel() && this.isReadyForLaunch();
    }

    public int getFuelState() {
        return this.getGaugeState(0);
    }

    public int getOxidizerState() {
        return this.getGaugeState(1);
    }

    public int getGaugeState(int tank) {
        if (this.slots[0] == null) {
            return 0;
        }
        if (this.slots[0].func_77973_b() instanceof ItemMissile) {
            ItemMissile missile = (ItemMissile)this.slots[0].func_77973_b();
            ItemMissile.MissileFuel fuel = missile.fuel;
            if (fuel == ItemMissile.MissileFuel.SOLID) {
                return 0;
            }
            return this.tanks[tank].getFill() >= missile.fuelCap ? 1 : -1;
        }
        return 0;
    }

    public abstract boolean isReadyForLaunch();

    public abstract double getLaunchOffset();

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_launch_pad";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[0].getTankType().getUnlocalizedName(), this.tanks[1].getFill(), this.tanks[1].getMaxFill(), this.tanks[1].getTankType().getUnlocalizedName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] canLaunch(Context context, Arguments args) {
        return new Object[]{this.canLaunch()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTier(Context context, Arguments args) {
        if (!this.isMissileValid()) {
            return new Object[0];
        }
        ItemMissile missile = (ItemMissile)this.slots[0].func_77973_b();
        if (missile.tier == ItemMissile.MissileTier.TIER0) {
            return new Object[]{0};
        }
        if (missile.tier == ItemMissile.MissileTier.TIER1) {
            return new Object[]{1};
        }
        if (missile.tier == ItemMissile.MissileTier.TIER2) {
            return new Object[]{2};
        }
        if (missile.tier == ItemMissile.MissileTier.TIER3) {
            return new Object[]{3};
        }
        if (missile.tier == ItemMissile.MissileTier.TIER4) {
            return new Object[]{4};
        }
        return new Object[]{5};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] launch(Context context, Arguments args) {
        if (this.canLaunch()) {
            return new Object[]{this.sendCommandPosition(args.checkInteger(0), -1, args.checkInteger(1))};
        }
        return new Object[]{false};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPos(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getEnergyInfo", "getFluid", "canLaunch", "getTier", "launch", "getPos"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getEnergyInfo": {
                return this.getEnergyInfo(context, args);
            }
            case "getFluid": {
                return this.getFluid(context, args);
            }
            case "canLaunch": {
                return this.canLaunch(context, args);
            }
            case "getTier": {
                return this.getTier(context, args);
            }
            case "launch": {
                return this.launch(context, args);
            }
            case "getPos": {
                return this.getPos(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public int[] getFluidIDToCopy() {
        return new int[]{this.tanks[0].getTankType().getID(), this.tanks[1].getTankType().getID()};
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

