/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.tileentity.machine.TileEntityMachineLPW2;
import com.hbm.util.BobMathUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderLPW2
extends TileEntitySpecialRenderer
implements IItemRendererProvider {
    public void func_147500_a(TileEntity te, double x, double y, double z, float interp) {
        if (!(te instanceof TileEntityMachineLPW2)) {
            return;
        }
        TileEntityMachineLPW2 rocket = (TileEntityMachineLPW2)te;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        switch (te.func_145832_p() - 10) {
            case 2: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        long time = te.func_145831_w().func_82737_E();
        double t = rocket.lastTime + (rocket.time - rocket.lastTime) * (double)interp;
        double swayTimer = t / 3.0 % (Math.PI * 4);
        double sway = (Math.sin(swayTimer) + Math.sin(swayTimer * 2.0) + Math.sin(swayTimer * 4.0) + 2.23255) * 0.5;
        double bellTimer = t / 5.0 % (Math.PI * 4);
        double h = (Math.sin(bellTimer + Math.PI) + Math.sin(bellTimer * 1.5)) / 1.90596;
        double v = (Math.sin(bellTimer) + Math.sin(bellTimer * 1.5)) / 1.90596;
        double pistonTimer = t / 5.0 % (Math.PI * 2);
        double piston = BobMathUtil.sps(pistonTimer);
        double rotorTimer = t / 5.0 % 50.26548245743669;
        double rotor = (BobMathUtil.sps(rotorTimer) + rotorTimer / 2.0 - 1.0) / 25.1327412287;
        double turbine = t % 100.0 / 100.0;
        this.func_147499_a(ResourceManager.lpw2_tex);
        ResourceManager.lpw2.renderPart("Frame");
        RenderLPW2.renderMainAssembly(sway, h, v, piston, rotor, turbine);
        GL11.glPushMatrix();
        GL11.glTranslated((double)-2.9375, (double)0.0, (double)2.375);
        GL11.glRotated((double)(sway * 10.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)2.9375, (double)0.0, (double)-2.375);
        ResourceManager.lpw2.renderPart("WireLeft");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)2.9375, (double)0.0, (double)2.375);
        GL11.glRotated((double)(sway * -10.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-2.9375, (double)0.0, (double)-2.375);
        ResourceManager.lpw2.renderPart("WireRight");
        GL11.glPopMatrix();
        double coverTimer = t / 5.0 % (Math.PI * 4);
        double cover = (Math.sin(coverTimer) + Math.sin(coverTimer * 2.0) + Math.sin(coverTimer * 4.0)) * 0.5;
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-cover * 0.125));
        ResourceManager.lpw2.renderPart("Cover");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)3.5);
        GL11.glScaled((double)1.0, (double)1.0, (double)((3.0 + cover * 0.125) / 3.0));
        GL11.glTranslated((double)0.0, (double)0.0, (double)-3.5);
        ResourceManager.lpw2.renderPart("SuspensionCoverFront");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-5.5);
        GL11.glScaled((double)1.0, (double)1.0, (double)((1.5 - cover * 0.125) / 1.5));
        GL11.glTranslated((double)0.0, (double)0.0, (double)5.5);
        ResourceManager.lpw2.renderPart("SuspensionCoverBack");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-9.0);
        GL11.glScaled((double)1.0, (double)1.0, (double)((1.25 - sway * 0.125) / 1.25));
        GL11.glTranslated((double)0.0, (double)0.0, (double)9.0);
        ResourceManager.lpw2.renderPart("SuspensionBackOuter");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-9.5);
        GL11.glScaled((double)1.0, (double)1.0, (double)((1.75 - sway * 0.125) / 1.75));
        GL11.glTranslated((double)0.0, (double)0.0, (double)9.5);
        ResourceManager.lpw2.renderPart("SuspensionBackCenter");
        GL11.glPopMatrix();
        double serverTimer = t / 2.0 % (Math.PI * 4);
        double sx = (Math.sin(serverTimer + Math.PI) + Math.sin(serverTimer * 1.5)) / 1.90596;
        double sy = (Math.sin(serverTimer) + Math.sin(serverTimer * 1.5)) / 1.90596;
        double serverSway = 0.015625;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(sx * serverSway), (double)0.0, (double)(sy * serverSway));
        ResourceManager.lpw2.renderPart("Server1");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-sy * serverSway), (double)0.0, (double)(sx * serverSway));
        ResourceManager.lpw2.renderPart("Server2");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(sy * serverSway), (double)0.0, (double)(-sx * serverSway));
        ResourceManager.lpw2.renderPart("Server3");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-sx * serverSway), (double)0.0, (double)(-sy * serverSway));
        ResourceManager.lpw2.renderPart("Server4");
        GL11.glPopMatrix();
        double errorTimer = (double)((float)time + interp) / 3.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(sy * serverSway), (double)0.0, (double)(sx * serverSway));
        ResourceManager.lpw2.renderPart("Monitor");
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.lpw2_error_tex);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glTranslated((double)0.0, (double)((BobMathUtil.sps(errorTimer) + errorTimer / 2.0) % 1.0), (double)0.0);
        ResourceManager.lpw2.renderPart("Screen");
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }

    public static void renderMainAssembly(double sway, double h, double v, double piston, double rotor, double turbine) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-sway * 0.125));
        ResourceManager.lpw2.renderPart("Center");
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)3.5, (double)0.0);
        GL11.glPushMatrix();
        GL11.glRotated((double)(rotor * 360.0), (double)0.0, (double)0.0, (double)-1.0);
        GL11.glTranslated((double)0.0, (double)-3.5, (double)0.0);
        ResourceManager.lpw2.renderPart("Rotor");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)(turbine * 360.0), (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-3.5, (double)0.0);
        ResourceManager.lpw2.renderPart("TurbineFront");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)(turbine * 360.0), (double)0.0, (double)0.0, (double)-1.0);
        GL11.glTranslated((double)0.0, (double)-3.5, (double)0.0);
        ResourceManager.lpw2.renderPart("TurbineBack");
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(piston * 0.375 + 0.375));
        ResourceManager.lpw2.renderPart("Piston");
        GL11.glPopMatrix();
        RenderLPW2.renderBell(h, v);
        GL11.glPopMatrix();
        RenderLPW2.renderShroud(h, v);
    }

    public static void renderBell(double h, double v) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)3.5, (double)2.75);
        double magnitude = 2.0;
        GL11.glRotated((double)(v * magnitude), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(h * magnitude), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-3.5, (double)-2.75);
        ResourceManager.lpw2.renderPart("Engine");
        GL11.glPopMatrix();
    }

    public static void renderShroud(double h, double v) {
        double magnitude = 0.125;
        double rotation = 5.0;
        double offset = 10.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)(-h * magnitude), (double)0.0);
        ResourceManager.lpw2.renderPart("ShroudH");
        RenderLPW2.renderFlap(112.5, rotation * v + offset);
        RenderLPW2.renderFlap(67.5, rotation * v + offset);
        RenderLPW2.renderFlap(292.5, rotation * -v + offset);
        RenderLPW2.renderFlap(247.5, rotation * -v + offset);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(v * magnitude), (double)0.0, (double)0.0);
        ResourceManager.lpw2.renderPart("ShroudV");
        RenderLPW2.renderFlap(22.5, rotation * h + offset);
        RenderLPW2.renderFlap(-22.5, rotation * h + offset);
        RenderLPW2.renderFlap(202.5, rotation * -h + offset);
        RenderLPW2.renderFlap(157.5, rotation * -h + offset);
        GL11.glPopMatrix();
        double length = 0.6875;
        GL11.glPushMatrix();
        GL11.glTranslated((double)-2.625, (double)0.0, (double)0.0);
        GL11.glScaled((double)((length + v * magnitude) / length), (double)1.0, (double)1.0);
        GL11.glTranslated((double)2.625, (double)0.0, (double)0.0);
        ResourceManager.lpw2.renderPart("SuspensionLeft");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)2.625, (double)0.0, (double)0.0);
        GL11.glScaled((double)((length - v * magnitude) / length), (double)1.0, (double)1.0);
        GL11.glTranslated((double)-2.625, (double)0.0, (double)0.0);
        ResourceManager.lpw2.renderPart("SuspensionRight");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)6.125, (double)0.0);
        GL11.glScaled((double)1.0, (double)((length + h * magnitude) / length), (double)1.0);
        GL11.glTranslated((double)0.0, (double)-6.125, (double)0.0);
        ResourceManager.lpw2.renderPart("SuspensionTop");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.875, (double)0.0);
        GL11.glScaled((double)1.0, (double)((length - h * magnitude) / length), (double)1.0);
        GL11.glTranslated((double)0.0, (double)-0.875, (double)0.0);
        ResourceManager.lpw2.renderPart("SuspensionBottom");
        GL11.glPopMatrix();
    }

    public static void renderFlap(double position, double rotation) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)3.5, (double)0.0);
        GL11.glRotated((double)position, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-3.5, (double)0.0);
        GL11.glTranslated((double)0.0, (double)6.96875, (double)8.5);
        GL11.glRotated((double)rotation, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-6.96875, (double)-8.5);
        ResourceManager.lpw2.renderPart("Flap");
        GL11.glPopMatrix();
    }

    @Override
    public Item getItemForRenderer() {
        return Item.func_150898_a((Block)ModBlocks.machine_lpw2);
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                GL11.glTranslated((double)1.0, (double)-1.0, (double)0.0);
                GL11.glScaled((double)1.6, (double)1.6, (double)1.6);
            }

            @Override
            public void renderCommon() {
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glShadeModel((int)7425);
                RenderLPW2.this.func_147499_a(ResourceManager.lpw2_tex);
                ResourceManager.lpw2.renderAll();
                GL11.glShadeModel((int)7424);
            }
        };
    }
}

