/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.main.ModEventHandlerClient;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class ParticleRocketFlame
extends EntityFX {
    protected int age;
    protected int maxAge;
    private float customRed;
    private float customGreen;
    private float customBlue;
    protected double pressure = 1.0;

    public ParticleRocketFlame(TextureManager p_i1213_1_, World p_i1218_1_, double p_i1218_2_, double p_i1218_4_, double p_i1218_6_) {
        super(p_i1218_1_, p_i1218_2_, p_i1218_4_, p_i1218_6_);
        this.field_70550_a = ModEventHandlerClient.particleBase;
        this.maxAge = 300 + this.field_70146_Z.nextInt(50);
        this.field_70544_f = 1.0f;
    }

    public ParticleRocketFlame setScale(float scale) {
        this.field_70544_f = scale;
        return this;
    }

    public ParticleRocketFlame setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public ParticleRocketFlame setCustomColor(float red, float green, float blue) {
        this.customRed = red;
        this.customGreen = green;
        this.customBlue = blue;
        return this;
    }

    public ParticleRocketFlame setAtmosphericPressure(double pressure) {
        this.pressure = pressure;
        if (pressure < 0.08) {
            double factor = (0.08 - pressure) * 20.0;
            this.field_70159_w += (this.field_70146_Z.nextDouble() - 0.5) * factor;
            this.field_70181_x += (this.field_70146_Z.nextDouble() - 0.5) * factor;
            this.field_70179_y += (this.field_70146_Z.nextDouble() - 0.5) * factor;
        }
        if (pressure < 0.05) {
            this.maxAge /= 4;
        } else if (pressure < 0.2) {
            this.maxAge /= 2;
        }
        return this;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        ++this.age;
        if (this.age == this.maxAge) {
            this.func_70106_y();
        }
        this.field_70159_w *= 0.91;
        this.field_70181_x *= 0.91;
        this.field_70179_y *= 0.91;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_70539_a(Tessellator p_70539_1_, float interp, float sX, float sY, float sZ, float dX, float dZ) {
        if (this.age == 0) {
            return;
        }
        Random urandom = new Random(this.func_145782_y());
        for (int i = 0; i < 10; ++i) {
            float add = urandom.nextFloat() * 0.3f;
            float dark = 1.0f - Math.min((float)this.age / ((float)this.maxAge * 0.25f), 1.0f);
            this.field_70552_h = this.customRed != 0.0f ? this.customRed * dark + add : 1.0f * dark + add;
            this.field_70553_i = this.customGreen != 0.0f ? this.customGreen * dark + add : 0.6f * dark + add;
            this.field_70551_j = this.customBlue != 0.0f ? this.customBlue * dark + add : 0.0f + add;
            this.field_82339_as = (float)Math.pow(1.0f - Math.min((float)this.age / (float)this.maxAge, 1.0f), 0.5);
            p_70539_1_.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * 0.75f);
            p_70539_1_.func_78375_b(0.0f, 1.0f, 0.0f);
            p_70539_1_.func_78380_c(240);
            float spread = (float)Math.pow((float)this.age / (float)this.maxAge * 4.0f, 1.5) + 1.0f;
            float scale = (urandom.nextFloat() * 0.5f + 0.1f + (float)this.age / (float)this.maxAge * 2.0f) * this.field_70544_f;
            float pX = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)interp - field_70556_an + (urandom.nextGaussian() - 1.0) * (double)0.2f * (double)(spread *= this.field_70544_f));
            float pY = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)interp - field_70554_ao + (urandom.nextGaussian() - 1.0) * 0.5 * (double)spread);
            float pZ = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)interp - field_70555_ap + (urandom.nextGaussian() - 1.0) * (double)0.2f * (double)spread);
            p_70539_1_.func_78374_a((double)(pX - sX * scale - dX * scale), (double)(pY - sY * scale), (double)(pZ - sZ * scale - dZ * scale), (double)this.field_70550_a.func_94212_f(), (double)this.field_70550_a.func_94210_h());
            p_70539_1_.func_78374_a((double)(pX - sX * scale + dX * scale), (double)(pY + sY * scale), (double)(pZ - sZ * scale + dZ * scale), (double)this.field_70550_a.func_94212_f(), (double)this.field_70550_a.func_94206_g());
            p_70539_1_.func_78374_a((double)(pX + sX * scale + dX * scale), (double)(pY + sY * scale), (double)(pZ + sZ * scale + dZ * scale), (double)this.field_70550_a.func_94209_e(), (double)this.field_70550_a.func_94206_g());
            p_70539_1_.func_78374_a((double)(pX + sX * scale - dX * scale), (double)(pY - sY * scale), (double)(pZ + sZ * scale - dZ * scale), (double)this.field_70550_a.func_94209_e(), (double)this.field_70550_a.func_94210_h());
        }
    }
}

