/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.module;

import com.hbm.items.special.ItemBedrockOreNew;
import com.hbm.util.BufferUtil;
import com.hbm.util.ItemStackUtil;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ModulePatternMatcher {
    public static final String MODE_EXACT = "exact";
    public static final String MODE_WILDCARD = "wildcard";
    public static final String MODE_BEDROCK = "bedrock";
    public String[] modes;

    public ModulePatternMatcher() {
        this.modes = new String[1];
    }

    public ModulePatternMatcher(int count) {
        this.modes = new String[count];
    }

    public void initPatternSmart(World world, ItemStack stack, int i) {
        if (world.field_72995_K) {
            return;
        }
        if (stack == null) {
            this.modes[i] = null;
            return;
        }
        List<String> names = ItemStackUtil.getOreDictNames(stack);
        if (this.iterateAndCheck(names, i, "ingot")) {
            return;
        }
        if (this.iterateAndCheck(names, i, "block")) {
            return;
        }
        if (this.iterateAndCheck(names, i, "dust")) {
            return;
        }
        if (this.iterateAndCheck(names, i, "nugget")) {
            return;
        }
        if (this.iterateAndCheck(names, i, "plate")) {
            return;
        }
        this.modes[i] = stack.func_77973_b() instanceof ItemBedrockOreNew ? MODE_BEDROCK : (stack.func_77981_g() ? MODE_EXACT : MODE_WILDCARD);
    }

    private boolean iterateAndCheck(List<String> names, int i, String prefix) {
        for (String s : names) {
            if (!s.startsWith(prefix)) continue;
            this.modes[i] = s;
            return true;
        }
        return false;
    }

    public void initPatternStandard(World world, ItemStack stack, int i) {
        if (world.field_72995_K) {
            return;
        }
        if (stack == null) {
            this.modes[i] = null;
            return;
        }
        this.modes[i] = stack.func_77973_b() instanceof ItemBedrockOreNew ? MODE_BEDROCK : (stack.func_77981_g() ? MODE_EXACT : MODE_WILDCARD);
    }

    public void nextMode(World world, ItemStack pattern, int i) {
        if (world.field_72995_K) {
            return;
        }
        if (pattern == null) {
            this.modes[i] = null;
            return;
        }
        if (this.modes[i] == null) {
            this.modes[i] = MODE_EXACT;
        } else if (MODE_EXACT.equals(this.modes[i])) {
            this.modes[i] = pattern.func_77973_b() instanceof ItemBedrockOreNew ? MODE_BEDROCK : MODE_WILDCARD;
        } else if (MODE_BEDROCK.equals(this.modes[i])) {
            this.modes[i] = MODE_WILDCARD;
        } else if (MODE_WILDCARD.equals(this.modes[i])) {
            List<String> names = ItemStackUtil.getOreDictNames(pattern);
            this.modes[i] = names.isEmpty() ? MODE_EXACT : names.get(0);
        } else {
            List<String> names = ItemStackUtil.getOreDictNames(pattern);
            if (names.size() < 2 || this.modes[i].equals(names.get(names.size() - 1))) {
                this.modes[i] = MODE_EXACT;
            } else {
                for (int j = 0; j < names.size() - 1; ++j) {
                    if (!this.modes[i].equals(names.get(j))) continue;
                    this.modes[i] = names.get(j + 1);
                    return;
                }
            }
        }
    }

    public boolean isValidForFilter(ItemStack filter, int index, ItemStack input) {
        String mode = this.modes[index];
        if (mode == null) {
            mode = MODE_EXACT;
            this.modes[index] = MODE_EXACT;
        }
        switch (mode) {
            case "exact": {
                return input.func_77969_a(filter);
            }
            case "wildcard": {
                return input.func_77973_b() == filter.func_77973_b();
            }
            case "bedrock": {
                if (input.func_77973_b() != filter.func_77973_b()) {
                    return false;
                }
                if (!(input.func_77973_b() instanceof ItemBedrockOreNew)) {
                    return false;
                }
                return ((ItemBedrockOreNew)input.func_77973_b()).getGrade(input.func_77960_j()) == ((ItemBedrockOreNew)filter.func_77973_b()).getGrade(filter.func_77960_j());
            }
        }
        List<String> keys = ItemStackUtil.getOreDictNames(input);
        return keys.contains(mode);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        for (int i = 0; i < this.modes.length; ++i) {
            this.modes[i] = nbt.func_74764_b("mode" + i) ? nbt.func_74779_i("mode" + i) : null;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        for (int i = 0; i < this.modes.length; ++i) {
            if (this.modes[i] == null) continue;
            nbt.func_74778_a("mode" + i, this.modes[i]);
        }
    }

    public void serialize(ByteBuf buf) {
        for (int i = 0; i < this.modes.length; ++i) {
            BufferUtil.writeString(buf, this.modes[i]);
        }
    }

    public void deserialize(ByteBuf buf) {
        for (int i = 0; i < this.modes.length; ++i) {
            this.modes[i] = BufferUtil.readString(buf);
        }
    }

    public static String getLabel(String mode) {
        switch (mode) {
            case "exact": {
                return EnumChatFormatting.YELLOW + "Item and meta match";
            }
            case "wildcard": {
                return EnumChatFormatting.YELLOW + "Item matches";
            }
            case "bedrock": {
                return EnumChatFormatting.YELLOW + "Item and bedrock grade match";
            }
        }
        return EnumChatFormatting.YELLOW + "Ore dict key matches: " + mode;
    }
}

