/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.module;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.FuelHandler;
import com.hbm.items.ModItems;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.util.ItemStackUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ModuleBurnTime {
    private static final int modLog = 0;
    private static final int modWood = 1;
    private static final int modCoal = 2;
    private static final int modLignite = 3;
    private static final int modCoke = 4;
    private static final int modSolid = 5;
    private static final int modRocket = 6;
    private static final int modBalefire = 7;
    private double[] modTime = new double[8];
    private double[] modHeat = new double[8];

    public ModuleBurnTime() {
        for (int i = 0; i < this.modTime.length; ++i) {
            this.modTime[i] = 1.0;
            this.modHeat[i] = 1.0;
        }
    }

    public void readIfPresent(JsonObject obj) {
        this.modTime[0] = IConfigurableMachine.grab(obj, "D:timeLog", this.modTime[0]);
        this.modTime[1] = IConfigurableMachine.grab(obj, "D:timeWood", this.modTime[1]);
        this.modTime[2] = IConfigurableMachine.grab(obj, "D:timeCoal", this.modTime[2]);
        this.modTime[3] = IConfigurableMachine.grab(obj, "D:timeLignite", this.modTime[3]);
        this.modTime[4] = IConfigurableMachine.grab(obj, "D:timeCoke", this.modTime[4]);
        this.modTime[5] = IConfigurableMachine.grab(obj, "D:timeSolid", this.modTime[5]);
        this.modTime[6] = IConfigurableMachine.grab(obj, "D:timeRocket", this.modTime[6]);
        this.modTime[7] = IConfigurableMachine.grab(obj, "D:timeBalefire", this.modTime[7]);
        this.modHeat[0] = IConfigurableMachine.grab(obj, "D:heatLog", this.modHeat[0]);
        this.modHeat[1] = IConfigurableMachine.grab(obj, "D:heatWood", this.modHeat[1]);
        this.modHeat[2] = IConfigurableMachine.grab(obj, "D:heatCoal", this.modHeat[2]);
        this.modHeat[3] = IConfigurableMachine.grab(obj, "D:heatLignite", this.modHeat[3]);
        this.modHeat[4] = IConfigurableMachine.grab(obj, "D:heatCoke", this.modHeat[4]);
        this.modHeat[5] = IConfigurableMachine.grab(obj, "D:heatSolid", this.modHeat[5]);
        this.modHeat[6] = IConfigurableMachine.grab(obj, "D:heatRocket", this.modHeat[6]);
        this.modHeat[7] = IConfigurableMachine.grab(obj, "D:heatBalefie", this.modHeat[7]);
    }

    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("D:timeLog").value(this.modTime[0]);
        writer.name("D:timeWood").value(this.modTime[1]);
        writer.name("D:timeCoal").value(this.modTime[2]);
        writer.name("D:timeLignite").value(this.modTime[3]);
        writer.name("D:timeCoke").value(this.modTime[4]);
        writer.name("D:timeSolid").value(this.modTime[5]);
        writer.name("D:timeRocket").value(this.modTime[6]);
        writer.name("D:timeBalefire").value(this.modTime[7]);
        writer.name("D:heatLog").value(this.modHeat[0]);
        writer.name("D:heatWood").value(this.modHeat[1]);
        writer.name("D:heatCoal").value(this.modHeat[2]);
        writer.name("D:heatLignite").value(this.modHeat[3]);
        writer.name("D:heatCoke").value(this.modHeat[4]);
        writer.name("D:heatSolid").value(this.modHeat[5]);
        writer.name("D:heatRocket").value(this.modHeat[6]);
        writer.name("D:heatBalefie").value(this.modHeat[7]);
    }

    public int getBurnTime(ItemStack stack) {
        int fuel = FuelHandler.getBurnTimeFromCache(stack);
        if (fuel == 0) {
            return 0;
        }
        return (int)((double)fuel * this.getMod(stack, this.modTime));
    }

    public int getBurnHeat(int base, ItemStack stack) {
        return (int)((double)base * this.getMod(stack, this.modHeat));
    }

    public double getMod(ItemStack stack, double[] mod) {
        if (stack == null) {
            return 0.0;
        }
        if (stack.func_77973_b() == ModItems.solid_fuel) {
            return mod[5];
        }
        if (stack.func_77973_b() == ModItems.solid_fuel_presto) {
            return mod[5];
        }
        if (stack.func_77973_b() == ModItems.solid_fuel_presto_triplet) {
            return mod[5];
        }
        if (stack.func_77973_b() == ModItems.solid_fuel_bf) {
            return mod[7];
        }
        if (stack.func_77973_b() == ModItems.solid_fuel_presto_bf) {
            return mod[7];
        }
        if (stack.func_77973_b() == ModItems.solid_fuel_presto_triplet_bf) {
            return mod[7];
        }
        if (stack.func_77973_b() == ModItems.rocket_fuel) {
            return mod[6];
        }
        List<String> names = ItemStackUtil.getOreDictNames(stack);
        for (String name : names) {
            if (name.contains("Coke")) {
                return mod[4];
            }
            if (name.contains("Coal")) {
                return mod[2];
            }
            if (name.contains("Lignite")) {
                return mod[3];
            }
            if (name.startsWith("log")) {
                return mod[0];
            }
            if (!name.contains("Wood")) continue;
            return mod[1];
        }
        return 1.0;
    }

    public List<String> getDesc() {
        ArrayList<String> desc = new ArrayList<String>();
        desc.addAll(this.getTimeDesc());
        desc.addAll(this.getHeatDesc());
        return desc;
    }

    public List<String> getTimeDesc() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EnumChatFormatting.GOLD + "Burn time bonuses:");
        this.addIf(list, "Logs", this.modTime[0]);
        this.addIf(list, "Wood", this.modTime[1]);
        this.addIf(list, "Coal", this.modTime[2]);
        this.addIf(list, "Lignite", this.modTime[3]);
        this.addIf(list, "Coke", this.modTime[4]);
        this.addIf(list, "Solid Fuel", this.modTime[5]);
        this.addIf(list, "Rocket Fuel", this.modTime[6]);
        this.addIf(list, "Balefire", this.modTime[7]);
        if (list.size() == 1) {
            list.clear();
        }
        return list;
    }

    public List<String> getHeatDesc() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EnumChatFormatting.RED + "Burn heat bonuses:");
        this.addIf(list, "Logs", this.modHeat[0]);
        this.addIf(list, "Wood", this.modHeat[1]);
        this.addIf(list, "Coal", this.modHeat[2]);
        this.addIf(list, "Lignite", this.modHeat[3]);
        this.addIf(list, "Coke", this.modHeat[4]);
        this.addIf(list, "Solid Fuel", this.modHeat[5]);
        this.addIf(list, "Rocket Fuel", this.modHeat[6]);
        this.addIf(list, "Balefire", this.modHeat[7]);
        if (list.size() == 1) {
            list.clear();
        }
        return list;
    }

    private void addIf(List<String> list, String name, double mod) {
        if (mod != 1.0) {
            list.add(EnumChatFormatting.YELLOW + "- " + name + ": " + this.getPercent(mod));
        }
    }

    private String getPercent(double mod) {
        String num = (int)((mod -= 1.0) * 100.0) + "%";
        num = mod < 0.0 ? EnumChatFormatting.RED + num : EnumChatFormatting.GREEN + "+" + num;
        return num;
    }

    public double[] getModHeat() {
        return this.modHeat;
    }

    public double[] getModTime() {
        return this.modTime;
    }

    public ModuleBurnTime setLogTimeMod(double mod) {
        this.modTime[0] = mod;
        return this;
    }

    public ModuleBurnTime setWoodTimeMod(double mod) {
        this.modTime[1] = mod;
        return this;
    }

    public ModuleBurnTime setCoalTimeMod(double mod) {
        this.modTime[2] = mod;
        return this;
    }

    public ModuleBurnTime setLigniteTimeMod(double mod) {
        this.modTime[3] = mod;
        return this;
    }

    public ModuleBurnTime setCokeTimeMod(double mod) {
        this.modTime[4] = mod;
        return this;
    }

    public ModuleBurnTime setSolidTimeMod(double mod) {
        this.modTime[5] = mod;
        return this;
    }

    public ModuleBurnTime setRocketTimeMod(double mod) {
        this.modTime[6] = mod;
        return this;
    }

    public ModuleBurnTime setBalefireTimeMod(double mod) {
        this.modTime[7] = mod;
        return this;
    }

    public ModuleBurnTime setLogHeatMod(double mod) {
        this.modHeat[0] = mod;
        return this;
    }

    public ModuleBurnTime setWoodHeatMod(double mod) {
        this.modHeat[1] = mod;
        return this;
    }

    public ModuleBurnTime setCoalHeatMod(double mod) {
        this.modHeat[2] = mod;
        return this;
    }

    public ModuleBurnTime setLigniteHeatMod(double mod) {
        this.modHeat[3] = mod;
        return this;
    }

    public ModuleBurnTime setCokeHeatMod(double mod) {
        this.modHeat[4] = mod;
        return this;
    }

    public ModuleBurnTime setSolidHeatMod(double mod) {
        this.modHeat[5] = mod;
        return this;
    }

    public ModuleBurnTime setRocketHeatMod(double mod) {
        this.modHeat[6] = mod;
        return this;
    }

    public ModuleBurnTime setBalefireHeatMod(double mod) {
        this.modHeat[7] = mod;
        return this;
    }
}

