/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.factory;

import com.hbm.entity.effect.EntityFireLingering;
import com.hbm.entity.projectile.EntityBulletBaseMK4;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCrossSmooth;
import com.hbm.explosion.vanillant.standard.ExplosionEffectWeapon;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.Crosshair;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.Receiver;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import com.hbm.items.weapon.sedna.factory.Lego;
import com.hbm.items.weapon.sedna.factory.Orchestras;
import com.hbm.items.weapon.sedna.impl.ItemGunStinger;
import com.hbm.items.weapon.sedna.mags.MagazineFullReload;
import com.hbm.items.weapon.sedna.mags.MagazineSingleReload;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.render.anim.AnimationEnums;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.util.DamageResistanceHandler;
import com.hbm.util.EntityDamageUtil;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class XFactoryRocket {
    public static BulletConfig[] rocket_template;
    public static BulletConfig[] rocket_rpzb;
    public static BulletConfig[] rocket_qd;
    public static BulletConfig[] rocket_ml;
    public static Consumer<Entity> LAMBDA_STANDARD_ACCELERATE;
    public static Consumer<Entity> LAMBDA_STEERING_ACCELERATE;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE_HEAT;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE_DEMO;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE_INC;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE_PHOSPHORUS;
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_STINGER_SECONDARY_PRESS;
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_STINGER_SECONDARY_RELEASE;
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_MISSILE_LAUNCHER_PRIMARY_PRESS;
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_RECOIL_ROCKET;
    public static BiFunction<ItemStack, AnimationEnums.GunAnimation, BusAnimation> LAMBDA_PANZERSCHRECK_ANIMS;
    public static BiFunction<ItemStack, AnimationEnums.GunAnimation, BusAnimation> LAMBDA_QUADRO_ANIMS;
    public static BiFunction<ItemStack, AnimationEnums.GunAnimation, BusAnimation> LAMBDA_MISSILE_LAUNCHER_ANIMS;

    public static void spawnFire(EntityBulletBaseMK4 bullet, MovingObjectPosition mop, boolean phosphorus, int duration) {
        MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && bullet.field_70173_aa < 3) {
            return;
        }
        World world = bullet.field_70170_p;
        Lego.standardExplode(bullet, mop, 3.0f);
        EntityFireLingering fire = new EntityFireLingering(world).setArea(6.0f, 2.0f).setDuration(duration).setType(phosphorus ? EntityFireLingering.TYPE_PHOSPHORUS : EntityFireLingering.TYPE_DIESEL);
        fire.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
        world.func_72838_d((Entity)fire);
        bullet.func_70106_y();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                block2: for (int dz = -2; dz <= 2; ++dz) {
                    int z;
                    int y;
                    int x = (int)Math.floor(mop.field_72307_f.field_72450_a) + dx;
                    if (!world.func_147439_a(x, y = (int)Math.floor(mop.field_72307_f.field_72448_b) + dy, z = (int)Math.floor(mop.field_72307_f.field_72449_c) + dz).isAir((IBlockAccess)bullet.field_70170_p, x, y, z)) continue;
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        if (!world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isFlammable((IBlockAccess)world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite())) continue;
                        world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                        continue block2;
                    }
                }
            }
        }
    }

    public static BulletConfig makeRPZB(BulletConfig original) {
        return original.clone();
    }

    public static BulletConfig makeQD(BulletConfig original) {
        return original.clone().setLife(400).setOnUpdate(LAMBDA_STEERING_ACCELERATE);
    }

    public static BulletConfig makeML(BulletConfig original) {
        return original.clone();
    }

    public static void init() {
        rocket_template = new BulletConfig[5];
        BulletConfig baseRocket = new BulletConfig().setLife(300).setSelfDamageDelay(10).setVel(0.0f).setGrav(0.0).setOnEntityHit(null).setOnRicochet(null).setOnUpdate(LAMBDA_STANDARD_ACCELERATE);
        XFactoryRocket.rocket_template[0] = baseRocket.clone().setItem(GunFactory.EnumAmmo.ROCKET_HE).setOnImpact(LAMBDA_STANDARD_EXPLODE);
        XFactoryRocket.rocket_template[1] = baseRocket.clone().setItem(GunFactory.EnumAmmo.ROCKET_HEAT).setDamage(0.5f).setOnImpact(LAMBDA_STANDARD_EXPLODE_HEAT);
        XFactoryRocket.rocket_template[2] = baseRocket.clone().setItem(GunFactory.EnumAmmo.ROCKET_DEMO).setDamage(0.75f).setOnImpact(LAMBDA_STANDARD_EXPLODE_DEMO);
        XFactoryRocket.rocket_template[3] = baseRocket.clone().setItem(GunFactory.EnumAmmo.ROCKET_INC).setDamage(0.75f).setOnImpact(LAMBDA_STANDARD_EXPLODE_INC);
        XFactoryRocket.rocket_template[4] = baseRocket.clone().setItem(GunFactory.EnumAmmo.ROCKET_PHOSPHORUS).setDamage(0.75f).setOnImpact(LAMBDA_STANDARD_EXPLODE_PHOSPHORUS);
        rocket_rpzb = new BulletConfig[rocket_template.length];
        rocket_qd = new BulletConfig[rocket_template.length];
        rocket_ml = new BulletConfig[rocket_template.length];
        for (int i = 0; i < rocket_template.length; ++i) {
            XFactoryRocket.rocket_rpzb[i] = XFactoryRocket.makeRPZB(rocket_template[i]);
            XFactoryRocket.rocket_qd[i] = XFactoryRocket.makeQD(rocket_template[i]);
            XFactoryRocket.rocket_ml[i] = XFactoryRocket.makeML(rocket_template[i]);
        }
        ModItems.gun_panzerschreck = new ItemGunBaseNT(ItemGunBaseNT.WeaponQuality.A_SIDE, new GunConfig().dura(300.0f).draw(7).inspect(40).crosshair(Crosshair.L_CIRCUMFLEX).rec(new Receiver(0).dmg(25.0f).delay(5).reload(50).jam(40).sound("hbm:weapon.rpgShoot", 1.0f, 1.0f).mag(new MagazineSingleReload(0, 1).addConfigs(rocket_rpzb)).offset(1.0, -0.09375, -0.1875).setupStandardFire().recoil(LAMBDA_RECOIL_ROCKET)).setupStandardConfiguration().anim(LAMBDA_PANZERSCHRECK_ANIMS).orchestra(Orchestras.ORCHESTRA_PANERSCHRECK)).setDefaultAmmo(GunFactory.EnumAmmo.ROCKET_HE, 3).func_77655_b("gun_panzerschreck");
        ModItems.gun_stinger = new ItemGunStinger(ItemGunBaseNT.WeaponQuality.A_SIDE, new GunConfig().dura(300.0f).draw(7).inspect(40).crosshair(Crosshair.L_BOX_OUTLINE).rec(new Receiver(0).dmg(35.0f).delay(5).reload(50).jam(40).sound("hbm:weapon.rpgShoot", 1.0f, 1.0f).mag(new MagazineSingleReload(0, 1).addConfigs(rocket_rpzb)).offset(1.0, -0.09375, -0.1875).setupLockonFire().recoil(LAMBDA_RECOIL_ROCKET)).setupStandardConfiguration().ps(LAMBDA_STINGER_SECONDARY_PRESS).rs(LAMBDA_STINGER_SECONDARY_RELEASE).anim(LAMBDA_PANZERSCHRECK_ANIMS).orchestra(Orchestras.ORCHESTRA_STINGER)).setDefaultAmmo(GunFactory.EnumAmmo.ROCKET_HEAT, 3).func_77655_b("gun_stinger");
        ModItems.gun_quadro = new ItemGunBaseNT(ItemGunBaseNT.WeaponQuality.A_SIDE, new GunConfig().dura(400.0f).draw(7).inspect(40).crosshair(Crosshair.L_CIRCUMFLEX).hideCrosshair(false).rec(new Receiver(0).dmg(40.0f).spreadHipfire(0.0f).delay(10).reload(55).jam(40).sound("hbm:weapon.rpgShoot", 1.0f, 1.0f).mag(new MagazineFullReload(0, 4).addConfigs(rocket_qd)).offset(1.0, -0.09375, -0.1875).setupStandardFire().recoil(LAMBDA_RECOIL_ROCKET)).setupStandardConfiguration().anim(LAMBDA_QUADRO_ANIMS).orchestra(Orchestras.ORCHESTRA_QUADRO)).setDefaultAmmo(GunFactory.EnumAmmo.ROCKET_HE, 4).func_77655_b("gun_quadro");
        ModItems.gun_missile_launcher = new ItemGunBaseNT(ItemGunBaseNT.WeaponQuality.A_SIDE, new GunConfig().dura(500.0f).draw(20).inspect(40).crosshair(Crosshair.L_CIRCUMFLEX).hideCrosshair(false).rec(new Receiver(0).dmg(50.0f).spreadHipfire(0.0f).delay(5).reload(48).jam(33).sound("hbm:weapon.rpgShoot", 1.0f, 1.0f).mag(new MagazineSingleReload(0, 1).addConfigs(rocket_ml)).offset(1.0, -0.09375, -0.1875).setupStandardFire().recoil(LAMBDA_RECOIL_ROCKET)).setupStandardConfiguration().pp(LAMBDA_MISSILE_LAUNCHER_PRIMARY_PRESS).anim(LAMBDA_MISSILE_LAUNCHER_ANIMS).orchestra(Orchestras.ORCHESTRA_MISSILE_LAUNCHER)).setDefaultAmmo(GunFactory.EnumAmmo.ROCKET_HEAT, 5).func_77655_b("gun_missile_launcher");
    }

    static {
        LAMBDA_STANDARD_ACCELERATE = entity -> {
            EntityBulletBaseMK4 bullet = (EntityBulletBaseMK4)((Object)entity);
            if (bullet.accel < 7.0) {
                bullet.accel += 0.4;
            }
        };
        LAMBDA_STEERING_ACCELERATE = entity -> {
            EntityBulletBaseMK4 bullet = (EntityBulletBaseMK4)((Object)entity);
            if (bullet.accel < 4.0) {
                bullet.accel += 0.4;
            }
            if (bullet.getThrower() == null || !(bullet.getThrower() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)bullet.getThrower();
            if (Vec3.func_72443_a((double)(bullet.field_70165_t - player.field_70165_t), (double)(bullet.field_70163_u - player.field_70163_u), (double)(bullet.field_70161_v - player.field_70161_v)).func_72433_c() > 100.0) {
                return;
            }
            if (player.func_70694_bm() == null || !(player.func_70694_bm().func_77973_b() instanceof ItemGunBaseNT) || !ItemGunBaseNT.getIsAiming(player.func_70694_bm())) {
                return;
            }
            MovingObjectPosition mop = Library.rayTrace(player, 200.0, 1.0f);
            if (mop == null || mop.field_72307_f == null) {
                return;
            }
            Vec3 vec = Vec3.func_72443_a((double)(mop.field_72307_f.field_72450_a - bullet.field_70165_t), (double)(mop.field_72307_f.field_72448_b - bullet.field_70163_u), (double)(mop.field_72307_f.field_72449_c - bullet.field_70161_v));
            if (vec.func_72433_c() < 3.0) {
                return;
            }
            vec = vec.func_72432_b();
            double speed = Vec3.func_72443_a((double)bullet.field_70159_w, (double)bullet.field_70181_x, (double)bullet.field_70179_y).func_72433_c();
            bullet.field_70159_w = vec.field_72450_a * speed;
            bullet.field_70181_x = vec.field_72448_b * speed;
            bullet.field_70179_y = vec.field_72449_c * speed;
        };
        LAMBDA_STANDARD_EXPLODE = (bullet, mop) -> {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && bullet.field_70173_aa < 3) {
                return;
            }
            Lego.standardExplode(bullet, mop, 5.0f);
            bullet.func_70106_y();
        };
        LAMBDA_STANDARD_EXPLODE_HEAT = (bullet, mop) -> {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && bullet.field_70173_aa < 3) {
                return;
            }
            Lego.standardExplode(bullet, mop, 3.5f);
            bullet.func_70106_y();
            MovingObjectPosition.MovingObjectType cfr_ignored_1 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)mop.field_72308_g;
                BulletConfig cfr_ignored_2 = bullet.config;
                EntityDamageUtil.attackEntityFromNT(living, BulletConfig.getDamage(bullet, bullet.getThrower(), DamageResistanceHandler.DamageClass.EXPLOSIVE), bullet.damage * 3.0f, true, true, 0.5, 5.0f, 0.2f);
            } else {
                MovingObjectPosition.MovingObjectType cfr_ignored_3 = mop.field_72313_a;
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    BulletConfig cfr_ignored_4 = bullet.config;
                    mop.field_72308_g.func_70097_a(BulletConfig.getDamage(bullet, bullet.getThrower(), DamageResistanceHandler.DamageClass.EXPLOSIVE), bullet.damage * 3.0f);
                }
            }
        };
        LAMBDA_STANDARD_EXPLODE_DEMO = (bullet, mop) -> {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && bullet.field_70173_aa < 3) {
                return;
            }
            ExplosionVNT vnt = new ExplosionVNT(bullet.field_70170_p, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, 5.0f, (Entity)bullet.getThrower());
            vnt.setBlockAllocator(new BlockAllocatorStandard());
            vnt.setBlockProcessor(new BlockProcessorStandard());
            vnt.setEntityProcessor(new EntityProcessorCrossSmooth(1.0, bullet.damage));
            vnt.setPlayerProcessor(new PlayerProcessorStandard());
            vnt.setSFX(new ExplosionEffectWeapon(10, 2.5f, 1.0f));
            vnt.explode();
            bullet.func_70106_y();
        };
        LAMBDA_STANDARD_EXPLODE_INC = (bullet, mop) -> XFactoryRocket.spawnFire(bullet, mop, false, 300);
        LAMBDA_STANDARD_EXPLODE_PHOSPHORUS = (bullet, mop) -> XFactoryRocket.spawnFire(bullet, mop, true, 600);
        LAMBDA_STINGER_SECONDARY_PRESS = (stack, ctx) -> ItemGunStinger.setIsLockingOn(stack, true);
        LAMBDA_STINGER_SECONDARY_RELEASE = (stack, ctx) -> ItemGunStinger.setIsLockingOn(stack, false);
        LAMBDA_MISSILE_LAUNCHER_PRIMARY_PRESS = (stack, ctx) -> {
            int target;
            if (ItemGunBaseNT.getIsAiming(stack) && (target = ItemGunStinger.getLockonTarget(ctx.getPlayer(), 150.0, 20.0)) != -1) {
                ItemGunBaseNT.setLockonTarget(stack, target);
                ItemGunBaseNT.setIsLockedOn(stack, true);
            }
            Lego.LAMBDA_STANDARD_CLICK_PRIMARY.accept((ItemStack)stack, (ItemGunBaseNT.LambdaContext)ctx);
            ItemGunBaseNT.setIsLockedOn(stack, false);
        };
        LAMBDA_RECOIL_ROCKET = (stack, ctx) -> {};
        LAMBDA_PANZERSCHRECK_ANIMS = (stack, type) -> {
            boolean empty = ((ItemGunBaseNT)stack.func_77973_b()).getConfig((ItemStack)stack, 0).getReceivers((ItemStack)stack)[0].getMagazine((ItemStack)stack).getAmount((ItemStack)stack, (IInventory)MainRegistry.proxy.me().field_71071_by) <= 0;
            switch (type) {
                case EQUIP: {
                    return new BusAnimation().addBus("EQUIP", new BusAnimationSequence().addPos(60.0, 0.0, 0.0, 0).addPos(0.0, 0.0, 0.0, 500, BusAnimationKeyframe.IType.SIN_DOWN));
                }
                case RELOAD: {
                    return new BusAnimation().addBus("RELOAD", new BusAnimationSequence().addPos(90.0, 0.0, 0.0, 750, BusAnimationKeyframe.IType.SIN_FULL).addPos(90.0, 0.0, 0.0, 1000).addPos(0.0, 0.0, 0.0, 750, BusAnimationKeyframe.IType.SIN_FULL)).addBus("ROCKET", new BusAnimationSequence().addPos(0.0, -3.0, -6.0, 0).addPos(0.0, -3.0, -6.0, 750).addPos(0.0, 0.0, -6.5, 500, BusAnimationKeyframe.IType.SIN_DOWN).addPos(0.0, 0.0, 0.0, 350, BusAnimationKeyframe.IType.SIN_UP));
                }
                case JAMMED: {
                    empty = false;
                }
                case INSPECT: {
                    return new BusAnimation().addBus("RELOAD", new BusAnimationSequence().addPos(90.0, 0.0, 0.0, 750, BusAnimationKeyframe.IType.SIN_FULL).addPos(90.0, 0.0, 0.0, 500).addPos(0.0, 0.0, 0.0, 750, BusAnimationKeyframe.IType.SIN_FULL)).addBus("ROCKET", new BusAnimationSequence().addPos(0.0, empty ? -3.0 : 0.0, 0.0, 0));
                }
            }
            return null;
        };
        LAMBDA_QUADRO_ANIMS = (stack, type) -> {
            switch (type) {
                case EQUIP: {
                    return new BusAnimation().addBus("EQUIP", new BusAnimationSequence().addPos(60.0, 0.0, 0.0, 0).addPos(0.0, 0.0, 0.0, 500, BusAnimationKeyframe.IType.SIN_DOWN));
                }
                case CYCLE: {
                    return new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addPos(0.0, 0.0, -0.5, 50).addPos(0.0, 0.0, 0.0, 50));
                }
                case RELOAD: {
                    return new BusAnimation().addBus("RELOAD_ROTATE", new BusAnimationSequence().addPos(0.0, 0.0, 60.0, 500, BusAnimationKeyframe.IType.SIN_FULL).addPos(0.0, 0.0, 60.0, 1500).addPos(0.0, 0.0, 0.0, 750, BusAnimationKeyframe.IType.SIN_FULL)).addBus("RELOAD_PUSH", new BusAnimationSequence().addPos(-1.0, -1.0, 0.0, 0).addPos(-1.0, -1.0, 0.0, 500).addPos(-1.0, 0.0, 0.0, 350).addPos(0.0, 0.0, 0.0, 1000));
                }
                case JAMMED: 
                case INSPECT: {
                    return new BusAnimation().addBus("RELOAD_ROTATE", new BusAnimationSequence().addPos(0.0, 0.0, 60.0, 750, BusAnimationKeyframe.IType.SIN_FULL).addPos(0.0, 0.0, 60.0, 500).addPos(0.0, 0.0, 0.0, 750, BusAnimationKeyframe.IType.SIN_FULL));
                }
            }
            return null;
        };
        LAMBDA_MISSILE_LAUNCHER_ANIMS = (stack, type) -> {
            switch (type) {
                case EQUIP: {
                    return new BusAnimation().addBus("EQUIP", new BusAnimationSequence().addPos(60.0, 0.0, 0.0, 0).addPos(0.0, 0.0, 0.0, 1000, BusAnimationKeyframe.IType.SIN_DOWN));
                }
                case RELOAD: {
                    return new BusAnimation().addBus("BARREL", new BusAnimationSequence().addPos(0.0, 0.0, 1.5, 150).addPos(0.0, 0.0, 1.5, 2100).addPos(0.0, 0.0, 0.0, 150)).addBus("OPEN", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 250).addPos(90.0, 0.0, 0.0, 500, BusAnimationKeyframe.IType.SIN_FULL).addPos(90.0, 0.0, 0.0, 1000).addPos(0.0, 0.0, 0.0, 500, BusAnimationKeyframe.IType.SIN_FULL)).addBus("EQUIP", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 2250).addPos(-1.0, 0.0, 0.0, 150, BusAnimationKeyframe.IType.SIN_DOWN).addPos(0.0, 0.0, 0.0, 150, BusAnimationKeyframe.IType.SIN_UP)).addBus("MISSILE", new BusAnimationSequence().addPos(-10.0, 0.0, 0.0, 0).addPos(-10.0, 0.0, 0.0, 750).addPos(3.0, 0.0, 2.0, 0).addPos(0.0, 0.0, -6.0, 350, BusAnimationKeyframe.IType.SIN_FULL).addPos(0.0, 0.0, 0.0, 350, BusAnimationKeyframe.IType.SIN_UP));
                }
                case JAMMED: 
                case INSPECT: {
                    return new BusAnimation().addBus("BARREL", new BusAnimationSequence().addPos(0.0, 0.0, 1.5, 150).addPos(0.0, 0.0, 1.5, 1350).addPos(0.0, 0.0, 0.0, 150)).addBus("OPEN", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 250).addPos(90.0, 0.0, 0.0, 500, BusAnimationKeyframe.IType.SIN_FULL).addPos(90.0, 0.0, 0.0, 250).addPos(0.0, 0.0, 0.0, 500, BusAnimationKeyframe.IType.SIN_FULL)).addBus("EQUIP", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 1500).addPos(-1.0, 0.0, 0.0, 150, BusAnimationKeyframe.IType.SIN_DOWN).addPos(0.0, 0.0, 0.0, 150, BusAnimationKeyframe.IType.SIN_UP));
                }
            }
            return null;
        };
    }
}

