/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna;

import com.hbm.config.GeneralConfig;
import com.hbm.handler.HbmKeybinds;
import com.hbm.interfaces.IItemHUD;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.gui.GUIWeaponTable;
import com.hbm.items.IEquipReceiver;
import com.hbm.items.IKeybindReceiver;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ArmorTrenchmaster;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.Receiver;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import com.hbm.items.weapon.sedna.hud.IHUDComponent;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.items.weapon.sedna.mags.MagazineInfinite;
import com.hbm.items.weapon.sedna.mods.XWeaponModManager;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.HbmAnimationPacket;
import com.hbm.render.anim.AnimationEnums;
import com.hbm.render.util.RenderScreenOverlay;
import com.hbm.sound.AudioWrapper;
import com.hbm.util.BobMathUtil;
import com.hbm.util.EnumUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemGunBaseNT
extends Item
implements IKeybindReceiver,
IItemHUD,
IEquipReceiver {
    public long[] lastShot;
    public double shotRand = 0.0;
    public static List<Item> secrets = new ArrayList<Item>();
    public List<RecipesCommon.ComparableStack> recognizedMods = new ArrayList<RecipesCommon.ComparableStack>();
    public ItemStack defaultAmmo;
    public boolean isDefaultExpensive = false;
    public static final DecimalFormatSymbols SYMBOLS_US = new DecimalFormatSymbols(Locale.US);
    public static final DecimalFormat FORMAT_DMG = new DecimalFormat("#.##", SYMBOLS_US);
    public static float recoilVertical = 0.0f;
    public static float recoilHorizontal = 0.0f;
    public static float recoilDecay = 0.75f;
    public static float recoilRebound = 0.25f;
    public static float offsetVertical = 0.0f;
    public static float offsetHorizontal = 0.0f;
    public static final String O_GUNCONFIG = "O_GUNCONFIG_";
    public static final String KEY_DRAWN = "drawn";
    public static final String KEY_AIMING = "aiming";
    public static final String KEY_MODE = "mode_";
    public static final String KEY_WEAR = "wear_";
    public static final String KEY_TIMER = "timer_";
    public static final String KEY_STATE = "state_";
    public static final String KEY_PRIMARY = "mouse1_";
    public static final String KEY_SECONDARY = "mouse2_";
    public static final String KEY_TERTIARY = "mouse3_";
    public static final String KEY_RELOAD = "reload_";
    public static final String KEY_LASTANIM = "lastanim_";
    public static final String KEY_ANIMTIMER = "animtimer_";
    public static final String KEY_LOCKONTARGET = "lockontarget";
    public static final String KEY_LOCKEDON = "lockedon";
    public static final String KEY_CANCELRELOAD = "cancel";
    public static final String KEY_EQUIPPED = "eqipped";
    public static ConcurrentHashMap<EntityLivingBase, AudioWrapper> loopedSounds = new ConcurrentHashMap();
    public static float prevAimingProgress;
    public static float aimingProgress;
    protected GunConfig[] configs_DNA;
    public Function<ItemStack, String> LAMBDA_NAME_MUTATOR;
    public WeaponQuality quality;

    public static void setupRecoil(float vertical, float horizontal, float decay, float rebound) {
        recoilVertical += vertical;
        recoilHorizontal += horizontal;
        recoilDecay = decay;
        recoilRebound = rebound;
    }

    public static void setupRecoil(float vertical, float horizontal) {
        ItemGunBaseNT.setupRecoil(vertical, horizontal, 0.75f, 0.25f);
    }

    public GunConfig getConfig(ItemStack stack, int index) {
        GunConfig cfg = this.configs_DNA[index];
        if (stack == null) {
            return cfg;
        }
        return XWeaponModManager.eval(cfg, stack, O_GUNCONFIG + index, this, index);
    }

    public int getConfigCount() {
        return this.configs_DNA.length;
    }

    public ItemGunBaseNT(WeaponQuality quality, GunConfig ... cfg) {
        this.func_77625_d(1);
        this.configs_DNA = cfg;
        this.quality = quality;
        this.lastShot = new long[cfg.length];
        for (int i = 0; i < cfg.length; ++i) {
            cfg[i].index = i;
        }
        if (quality == WeaponQuality.A_SIDE || quality == WeaponQuality.SPECIAL || quality == WeaponQuality.UTILITY) {
            this.func_77637_a(MainRegistry.weaponTab);
        }
        if (quality == WeaponQuality.LEGENDARY || quality == WeaponQuality.SECRET) {
            secrets.add(this);
        }
        this.func_111206_d("hbm:gun_darter");
    }

    public ItemGunBaseNT setDefaultAmmo(GunFactory.EnumAmmo ammo, int amount) {
        this.defaultAmmo = new ItemStack(ModItems.ammo_standard, amount, ammo.ordinal());
        return this;
    }

    public ItemGunBaseNT setDefaultAmmoExpensive(GunFactory.EnumAmmo ammo, int amount) {
        this.isDefaultExpensive = true;
        return this.setDefaultAmmo(ammo, amount);
    }

    public ItemGunBaseNT setNameMutator(Function<ItemStack, String> lambda) {
        this.LAMBDA_NAME_MUTATOR = lambda;
        return this;
    }

    public String func_77653_i(ItemStack stack) {
        String unloc;
        if (this.LAMBDA_NAME_MUTATOR != null && (unloc = this.LAMBDA_NAME_MUTATOR.apply(stack)) != null) {
            return StatCollector.func_74838_a((String)(unloc + ".name")).trim();
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        int configs = this.configs_DNA.length;
        for (int i = 0; i < configs; ++i) {
            GunConfig config = this.getConfig(stack, i);
            for (Receiver rec : config.getReceivers(stack)) {
                IMagazine mag = rec.getMagazine(stack);
                if (!(mag instanceof MagazineInfinite)) {
                    list.add(I18nUtil.resolveKey("gui.weapon.ammo", new Object[0]) + ": " + mag.getIconForHUD(stack, player).func_82833_r() + " " + mag.reportAmmoStateForHUD(stack, player));
                }
                float dmg = rec.getBaseDamage(stack);
                list.add(I18nUtil.resolveKey("gui.weapon.baseDamage", new Object[0]) + ": " + FORMAT_DMG.format(dmg));
                if (!(mag.getType(stack, (IInventory)player.field_71071_by) instanceof BulletConfig)) continue;
                BulletConfig bullet = (BulletConfig)mag.getType(stack, (IInventory)player.field_71071_by);
                int min = (int)((float)bullet.projectilesMin * rec.getSplitProjectiles(stack));
                int max = (int)((float)bullet.projectilesMax * rec.getSplitProjectiles(stack));
                list.add(I18nUtil.resolveKey("gui.weapon.damageWithAmmo", new Object[0]) + ": " + FORMAT_DMG.format(dmg * bullet.damageMult) + (min > 1 ? " x" + (min != max ? min + "-" + max : Integer.valueOf(min)) : ""));
            }
            float maxDura = config.getDurability(stack);
            if (maxDura > 0.0f) {
                int dura = MathHelper.func_76125_a((int)((int)((maxDura - ItemGunBaseNT.getWear(stack, i)) * 100.0f / maxDura)), (int)0, (int)100);
                list.add(I18nUtil.resolveKey("gui.weapon.condition", new Object[0]) + ": " + dura + "%");
            }
            for (ItemStack upgrade : XWeaponModManager.getUpgradeItems(stack, i)) {
                list.add(EnumChatFormatting.YELLOW + upgrade.func_82833_r());
            }
        }
        switch (this.quality) {
            case A_SIDE: {
                list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("gui.weapon.quality.aside", new Object[0]));
                break;
            }
            case B_SIDE: {
                list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("gui.weapon.quality.bside", new Object[0]));
                break;
            }
            case LEGENDARY: {
                list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("gui.weapon.quality.legendary", new Object[0]));
                break;
            }
            case SPECIAL: {
                list.add(EnumChatFormatting.AQUA + I18nUtil.resolveKey("gui.weapon.quality.special", new Object[0]));
                break;
            }
            case UTILITY: {
                list.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("gui.weapon.quality.utility", new Object[0]));
                break;
            }
            case SECRET: {
                list.add((BobMathUtil.getBlink() ? EnumChatFormatting.DARK_RED : EnumChatFormatting.RED) + I18nUtil.resolveKey("gui.weapon.quality.secret", new Object[0]));
                break;
            }
            case DEBUG: {
                list.add((BobMathUtil.getBlink() ? EnumChatFormatting.YELLOW : EnumChatFormatting.GOLD) + I18nUtil.resolveKey("gui.weapon.quality.debug", new Object[0]));
            }
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GUIWeaponTable && !this.recognizedMods.isEmpty()) {
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("gui.weapon.accepts", new Object[0]) + ":");
            for (RecipesCommon.ComparableStack comp : this.recognizedMods) {
                list.add(EnumChatFormatting.RED + "  " + comp.toStack().func_82833_r());
            }
        }
    }

    @Override
    public boolean canHandleKeybind(EntityPlayer player, ItemStack stack, HbmKeybinds.EnumKeybind keybind) {
        return keybind == HbmKeybinds.EnumKeybind.GUN_PRIMARY || keybind == HbmKeybinds.EnumKeybind.GUN_SECONDARY || keybind == HbmKeybinds.EnumKeybind.GUN_TERTIARY || keybind == HbmKeybinds.EnumKeybind.RELOAD;
    }

    @Override
    public void handleKeybind(EntityPlayer player, ItemStack stack, HbmKeybinds.EnumKeybind keybind, boolean newState) {
        this.handleKeybind((EntityLivingBase)player, (IInventory)player.field_71071_by, stack, keybind, newState);
    }

    public void handleKeybind(EntityLivingBase entity, IInventory inventory, ItemStack stack, HbmKeybinds.EnumKeybind keybind, boolean newState) {
        if (!GeneralConfig.enableGuns) {
            return;
        }
        int configs = this.configs_DNA.length;
        for (int i = 0; i < configs; ++i) {
            GunConfig config = this.getConfig(stack, i);
            LambdaContext ctx = new LambdaContext(config, entity, inventory, i);
            if (keybind == HbmKeybinds.EnumKeybind.GUN_PRIMARY && newState && !ItemGunBaseNT.getPrimary(stack, i)) {
                if (config.getPressPrimary(stack) != null) {
                    config.getPressPrimary(stack).accept(stack, ctx);
                }
                ItemGunBaseNT.setPrimary(stack, i, newState);
                continue;
            }
            if (keybind == HbmKeybinds.EnumKeybind.GUN_PRIMARY && !newState && ItemGunBaseNT.getPrimary(stack, i)) {
                if (config.getReleasePrimary(stack) != null) {
                    config.getReleasePrimary(stack).accept(stack, ctx);
                }
                ItemGunBaseNT.setPrimary(stack, i, newState);
                continue;
            }
            if (keybind == HbmKeybinds.EnumKeybind.GUN_SECONDARY && newState && !ItemGunBaseNT.getSecondary(stack, i)) {
                if (config.getPressSecondary(stack) != null) {
                    config.getPressSecondary(stack).accept(stack, ctx);
                }
                ItemGunBaseNT.setSecondary(stack, i, newState);
                continue;
            }
            if (keybind == HbmKeybinds.EnumKeybind.GUN_SECONDARY && !newState && ItemGunBaseNT.getSecondary(stack, i)) {
                if (config.getReleaseSecondary(stack) != null) {
                    config.getReleaseSecondary(stack).accept(stack, ctx);
                }
                ItemGunBaseNT.setSecondary(stack, i, newState);
                continue;
            }
            if (keybind == HbmKeybinds.EnumKeybind.GUN_TERTIARY && newState && !ItemGunBaseNT.getTertiary(stack, i)) {
                if (config.getPressTertiary(stack) != null) {
                    config.getPressTertiary(stack).accept(stack, ctx);
                }
                ItemGunBaseNT.setTertiary(stack, i, newState);
                continue;
            }
            if (keybind == HbmKeybinds.EnumKeybind.GUN_TERTIARY && !newState && ItemGunBaseNT.getTertiary(stack, i)) {
                if (config.getReleaseTertiary(stack) != null) {
                    config.getReleaseTertiary(stack).accept(stack, ctx);
                }
                ItemGunBaseNT.setTertiary(stack, i, newState);
                continue;
            }
            if (keybind == HbmKeybinds.EnumKeybind.RELOAD && newState && !ItemGunBaseNT.getReloadKey(stack, i)) {
                if (config.getPressReload(stack) != null) {
                    config.getPressReload(stack).accept(stack, ctx);
                }
                ItemGunBaseNT.setReloadKey(stack, i, newState);
                continue;
            }
            if (keybind != HbmKeybinds.EnumKeybind.RELOAD || newState || !ItemGunBaseNT.getReloadKey(stack, i)) continue;
            if (config.getReleaseReload(stack) != null) {
                config.getReleaseReload(stack).accept(stack, ctx);
            }
            ItemGunBaseNT.setReloadKey(stack, i, newState);
        }
    }

    @Override
    public void onEquip(EntityPlayer player, ItemStack stack) {
        for (int i = 0; i < this.configs_DNA.length; ++i) {
            if (ItemGunBaseNT.getLastAnim(stack, i) == AnimationEnums.GunAnimation.EQUIP) {
                if (ItemGunBaseNT.getAnimTimer(stack, i) < 5) continue;
            }
            ItemGunBaseNT.playAnimation(player, stack, AnimationEnums.GunAnimation.EQUIP, i);
            ItemGunBaseNT.setPrimary(stack, i, false);
            ItemGunBaseNT.setSecondary(stack, i, false);
            ItemGunBaseNT.setTertiary(stack, i, false);
            ItemGunBaseNT.setReloadKey(stack, i, false);
        }
    }

    public static void playAnimation(EntityPlayer player, ItemStack stack, AnimationEnums.GunAnimation type, int index) {
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo(new HbmAnimationPacket(type.ordinal(), 0, index), (EntityPlayerMP)player);
            ItemGunBaseNT.setLastAnim(stack, index, type);
            ItemGunBaseNT.setAnimTimer(stack, index, 0);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        int i;
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        int confNo = this.configs_DNA.length;
        GunConfig[] configs = new GunConfig[confNo];
        LambdaContext[] ctx = new LambdaContext[confNo];
        for (i = 0; i < confNo; ++i) {
            configs[i] = this.getConfig(stack, i);
            ctx[i] = new LambdaContext(configs[i], (EntityLivingBase)entity, (IInventory)(player != null ? player.field_71071_by : null), i);
        }
        if (world.field_72995_K) {
            if (isHeld && player == MainRegistry.proxy.me()) {
                int i2;
                prevAimingProgress = aimingProgress;
                boolean aiming = ItemGunBaseNT.getIsAiming(stack);
                float aimSpeed = 0.25f;
                if (aiming && aimingProgress < 1.0f) {
                    aimingProgress += aimSpeed;
                }
                if (!aiming && aimingProgress > 0.0f) {
                    aimingProgress -= aimSpeed;
                }
                aimingProgress = MathHelper.func_76131_a((float)aimingProgress, (float)0.0f, (float)1.0f);
                for (i2 = 0; i2 < confNo; ++i2) {
                    if (configs[i2].getSmokeHandler(stack) == null) continue;
                    configs[i2].getSmokeHandler(stack).accept(stack, ctx[i2]);
                }
                for (i2 = 0; i2 < confNo; ++i2) {
                    BiConsumer<ItemStack, LambdaContext> orchestra = configs[i2].getOrchestra(stack);
                    if (orchestra == null) continue;
                    orchestra.accept(stack, ctx[i2]);
                }
            }
            return;
        }
        if (player != null) {
            boolean wasHeld = ItemGunBaseNT.getIsEquipped(stack);
            if (!wasHeld && isHeld && player != null) {
                this.onEquip(player, stack);
            }
        }
        ItemGunBaseNT.setIsEquipped(stack, isHeld);
        if (!isHeld) {
            for (i = 0; i < confNo; ++i) {
                GunState current = ItemGunBaseNT.getState(stack, i);
                if (current != GunState.JAMMED) {
                    ItemGunBaseNT.setState(stack, i, GunState.DRAWING);
                    ItemGunBaseNT.setTimer(stack, i, configs[i].getDrawDuration(stack));
                }
                ItemGunBaseNT.setLastAnim(stack, i, AnimationEnums.GunAnimation.CYCLE);
            }
            ItemGunBaseNT.setIsAiming(stack, false);
            ItemGunBaseNT.setReloadCancel(stack, false);
            return;
        }
        block4: for (i = 0; i < confNo; ++i) {
            int k = 0;
            while (true) {
                BiConsumer<ItemStack, LambdaContext> orchestra;
                if (k != 0) {
                    if (k >= 2 || !ArmorTrenchmaster.isTrenchMaster(player)) continue block4;
                    if (ItemGunBaseNT.getState(stack, i) != GunState.RELOADING) continue block4;
                }
                if ((orchestra = configs[i].getOrchestra(stack)) != null) {
                    orchestra.accept(stack, ctx[i]);
                }
                ItemGunBaseNT.setAnimTimer(stack, i, ItemGunBaseNT.getAnimTimer(stack, i) + 1);
                int timer = ItemGunBaseNT.getTimer(stack, i);
                if (timer > 0) {
                    ItemGunBaseNT.setTimer(stack, i, timer - 1);
                }
                if (timer <= 1) {
                    configs[i].getDecider(stack).accept(stack, ctx[i]);
                }
                ++k;
            }
        }
    }

    public static boolean getIsDrawn(ItemStack stack) {
        return ItemGunBaseNT.getValueBool(stack, KEY_DRAWN);
    }

    public static void setIsDrawn(ItemStack stack, boolean value) {
        ItemGunBaseNT.setValueBool(stack, KEY_DRAWN, value);
    }

    public static int getTimer(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueInt(stack, KEY_TIMER + index);
    }

    public static void setTimer(ItemStack stack, int index, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_TIMER + index, value);
    }

    public static GunState getState(ItemStack stack, int index) {
        return (GunState)((Object)EnumUtil.grabEnumSafely(GunState.class, ItemGunBaseNT.getValueByte(stack, KEY_STATE + index)));
    }

    public static void setState(ItemStack stack, int index, GunState value) {
        ItemGunBaseNT.setValueByte(stack, KEY_STATE + index, (byte)value.ordinal());
    }

    public static int getMode(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MODE + index);
    }

    public static void setMode(ItemStack stack, int index, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_MODE + index, value);
    }

    public static boolean getIsAiming(ItemStack stack) {
        return ItemGunBaseNT.getValueBool(stack, KEY_AIMING);
    }

    public static void setIsAiming(ItemStack stack, boolean value) {
        ItemGunBaseNT.setValueBool(stack, KEY_AIMING, value);
    }

    public static float getWear(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueFloat(stack, KEY_WEAR + index);
    }

    public static void setWear(ItemStack stack, int index, float value) {
        ItemGunBaseNT.setValueFloat(stack, KEY_WEAR + index, value);
    }

    public static int getLockonTarget(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, KEY_LOCKONTARGET);
    }

    public static void setLockonTarget(ItemStack stack, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_LOCKONTARGET, value);
    }

    public static boolean getIsLockedOn(ItemStack stack) {
        return ItemGunBaseNT.getValueBool(stack, KEY_LOCKEDON);
    }

    public static void setIsLockedOn(ItemStack stack, boolean value) {
        ItemGunBaseNT.setValueBool(stack, KEY_LOCKEDON, value);
    }

    public static AnimationEnums.GunAnimation getLastAnim(ItemStack stack, int index) {
        return (AnimationEnums.GunAnimation)((Object)EnumUtil.grabEnumSafely(AnimationEnums.GunAnimation.class, ItemGunBaseNT.getValueInt(stack, KEY_LASTANIM + index)));
    }

    public static void setLastAnim(ItemStack stack, int index, AnimationEnums.GunAnimation value) {
        ItemGunBaseNT.setValueInt(stack, KEY_LASTANIM + index, value.ordinal());
    }

    public static int getAnimTimer(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueInt(stack, KEY_ANIMTIMER + index);
    }

    public static void setAnimTimer(ItemStack stack, int index, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_ANIMTIMER + index, value);
    }

    public static boolean getPrimary(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueBool(stack, KEY_PRIMARY + index);
    }

    public static void setPrimary(ItemStack stack, int index, boolean value) {
        ItemGunBaseNT.setValueBool(stack, KEY_PRIMARY + index, value);
    }

    public static boolean getSecondary(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueBool(stack, KEY_SECONDARY + index);
    }

    public static void setSecondary(ItemStack stack, int index, boolean value) {
        ItemGunBaseNT.setValueBool(stack, KEY_SECONDARY + index, value);
    }

    public static boolean getTertiary(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueBool(stack, KEY_TERTIARY + index);
    }

    public static void setTertiary(ItemStack stack, int index, boolean value) {
        ItemGunBaseNT.setValueBool(stack, KEY_TERTIARY + index, value);
    }

    public static boolean getReloadKey(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueBool(stack, KEY_RELOAD + index);
    }

    public static void setReloadKey(ItemStack stack, int index, boolean value) {
        ItemGunBaseNT.setValueBool(stack, KEY_RELOAD + index, value);
    }

    public static boolean getReloadCancel(ItemStack stack) {
        return ItemGunBaseNT.getValueBool(stack, KEY_CANCELRELOAD);
    }

    public static void setReloadCancel(ItemStack stack, boolean value) {
        ItemGunBaseNT.setValueBool(stack, KEY_CANCELRELOAD, value);
    }

    public static boolean getIsEquipped(ItemStack stack) {
        return ItemGunBaseNT.getValueBool(stack, KEY_EQUIPPED);
    }

    public static void setIsEquipped(ItemStack stack, boolean value) {
        ItemGunBaseNT.setValueBool(stack, KEY_EQUIPPED, value);
    }

    public static int getValueInt(ItemStack stack, String name) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(name);
        }
        return 0;
    }

    public static void setValueInt(ItemStack stack, String name, int value) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.func_77978_p().func_74768_a(name, value);
    }

    public static float getValueFloat(ItemStack stack, String name) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74760_g(name);
        }
        return 0.0f;
    }

    public static void setValueFloat(ItemStack stack, String name, float value) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.func_77978_p().func_74776_a(name, value);
    }

    public static byte getValueByte(ItemStack stack, String name) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74771_c(name);
        }
        return 0;
    }

    public static void setValueByte(ItemStack stack, String name, byte value) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.func_77978_p().func_74774_a(name, value);
    }

    public static boolean getValueBool(ItemStack stack, String name) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74767_n(name);
        }
        return false;
    }

    public static void setValueBool(ItemStack stack, String name, boolean value) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.func_77978_p().func_74757_a(name, value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Pre event, RenderGameOverlayEvent.ElementType type, EntityPlayer player, ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        if (type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            GunConfig config = gun.getConfig(stack, 0);
            if (config.getHideCrosshair(stack) && aimingProgress >= 1.0f) {
                return;
            }
            RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, config.getCrosshair(stack));
        }
        int confNo = this.configs_DNA.length;
        for (int i = 0; i < confNo; ++i) {
            IHUDComponent[] components = gun.getConfig(stack, i).getHUDComponents(stack);
            if (components == null) continue;
            for (IHUDComponent component : components) {
                int bottomOffset = 0;
                component.renderHUDComponent(event, type, player, stack, bottomOffset, i);
                bottomOffset += component.getComponentHeight(player, stack);
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static class SmokeNode {
        public double forward = 0.0;
        public double side = 0.0;
        public double lift = 0.0;
        public double alpha;
        public double width = 1.0;

        public SmokeNode(double alpha) {
            this.alpha = alpha;
        }
    }

    public static class LambdaContext {
        public final GunConfig config;
        public final EntityLivingBase entity;
        public final IInventory inventory;
        public final int configIndex;

        public LambdaContext(GunConfig config, EntityLivingBase player, IInventory inventory, int configIndex) {
            this.config = config;
            this.entity = player;
            this.inventory = inventory;
            this.configIndex = configIndex;
        }

        public EntityPlayer getPlayer() {
            if (!(this.entity instanceof EntityPlayer)) {
                return null;
            }
            return (EntityPlayer)this.entity;
        }
    }

    public static enum GunState {
        DRAWING,
        IDLE,
        COOLDOWN,
        RELOADING,
        JAMMED;

    }

    public static enum WeaponQuality {
        A_SIDE,
        B_SIDE,
        LEGENDARY,
        SPECIAL,
        UTILITY,
        SECRET,
        DEBUG;

    }
}

