/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.main.MainRegistry;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public abstract class ItemStructureTool
extends Item
implements ILookOverlay {
    File file = new File(MainRegistry.configHbmDir, "structureOutput.txt");
    FileWriter writer;

    public void writeToFile(String message) {
        if (!GeneralConfig.enableDebugMode) {
            return;
        }
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            if (this.writer == null) {
                this.writer = new FileWriter(this.file, true);
            }
            this.writer.write(message);
            this.writer.flush();
        }
        catch (IOException e) {
            System.out.print("ItemStructureWand encountered an IOException!");
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        BlockPos anchor = ItemStructureTool.getAnchor(stack);
        if (anchor == null) {
            list.add(EnumChatFormatting.RED + "No anchor set! Right click an anchor to get started.");
        }
        if (GeneralConfig.enableDebugMode) {
            list.add(EnumChatFormatting.GREEN + "Will write to \"structureOutput.txt\" in hbmConfig.");
        }
    }

    public static BlockPos getAnchor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return new BlockPos(stack.field_77990_d.func_74762_e("anchorX"), stack.field_77990_d.func_74762_e("anchorY"), stack.field_77990_d.func_74762_e("anchorZ"));
    }

    public static void setAnchor(ItemStack stack, int x, int y, int z) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("anchorX", x);
        stack.field_77990_d.func_74768_a("anchorY", y);
        stack.field_77990_d.func_74768_a("anchorZ", z);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block b = world.func_147439_a(x, y, z);
        if (b == ModBlocks.structure_anchor) {
            ItemStructureTool.setAnchor(stack, x, y, z);
            return true;
        }
        if (ItemStructureTool.getAnchor(stack) == null) {
            return false;
        }
        if (!this.dualUse() && world.field_72995_K) {
            this.doTheThing(stack, world, x, y, z);
        } else if (!stack.field_77990_d.func_74764_b("x")) {
            stack.field_77990_d.func_74768_a("x", x);
            stack.field_77990_d.func_74768_a("y", y);
            stack.field_77990_d.func_74768_a("z", z);
        } else {
            if (world.field_72995_K) {
                this.doTheThing(stack, world, x, y, z);
            }
            stack.field_77990_d.func_82580_o("x");
            stack.field_77990_d.func_82580_o("y");
            stack.field_77990_d.func_82580_o("z");
        }
        return true;
    }

    protected boolean dualUse() {
        return false;
    }

    protected abstract void doTheThing(ItemStack var1, World var2, int var3, int var4, int var5);

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        ArrayList<String> text = new ArrayList<String>();
        BlockPos anchor = ItemStructureTool.getAnchor(stack);
        if (anchor == null) {
            text.add(EnumChatFormatting.RED + "No Anchor");
        } else {
            int dX = x - anchor.getX();
            int dY = y - anchor.getY();
            int dZ = z - anchor.getZ();
            text.add(EnumChatFormatting.YELLOW + "Position: " + dX + " / " + dY + " / " + dZ);
            if (this.dualUse() && stack.field_77990_d.func_74764_b("x")) {
                int sX = Math.abs(x - stack.field_77990_d.func_74762_e("x")) + 1;
                int sY = Math.abs(y - stack.field_77990_d.func_74762_e("y")) + 1;
                int sZ = Math.abs(z - stack.field_77990_d.func_74762_e("z")) + 1;
                text.add(EnumChatFormatting.GOLD + "Selection: " + sX + " / " + sY + " / " + sZ);
            }
        }
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            text.add("B: " + world.func_147439_a(x, y, z).func_149739_a() + ", M: " + world.func_72805_g(x, y, z));
        }
        ILookOverlay.printGeneric(event, this.func_77653_i(stack), 0xFFFF00, 0x404000, text);
    }
}

