/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.hbm.dim.CelestialBody;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.items.armor.JetpackFueledBase;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.util.ArmorUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class JetpackBreak
extends JetpackFueledBase {
    public static int maxFuel = 1200;

    public JetpackBreak(FluidType fuel, int maxFuel) {
        super(fuel, maxFuel);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "hbm:textures/models/JetPackBlue.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        HbmPlayerProps props = HbmPlayerProps.getData(player);
        float gravity = CelestialBody.getGravity((EntityLivingBase)player);
        if (!world.field_72995_K && JetpackBreak.getFuel(stack) > 0 && (props.isJetpackActive() || !player.field_70122_E && !player.func_70093_af() && props.enableBackpack && gravity > 0.0f)) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "jetpack");
            data.func_74768_a("player", player.func_145782_y());
            PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, player.field_70165_t, player.field_70163_u, player.field_70161_v), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0));
        }
        if (JetpackBreak.getFuel(stack) > 0) {
            boolean playerShouldHover;
            boolean playerTriesToHover = player.func_70093_af() && props.isJetpackActive();
            boolean bl = playerShouldHover = playerTriesToHover || !player.func_70093_af();
            if (props.isJetpackActive() && !playerTriesToHover) {
                player.field_70143_R = 0.0f;
                if (gravity == 0.0f) {
                    Vec3 look = player.func_70040_Z();
                    player.field_70159_w += look.field_72450_a * 0.05;
                    player.field_70181_x += look.field_72448_b * 0.05;
                    player.field_70179_y += look.field_72449_c * 0.05;
                } else if (player.field_70181_x < 0.4) {
                    player.field_70181_x += 0.1 * (double)Math.max(gravity / 1.6f, 1.0f);
                }
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "hbm:weapon.flamethrowerShoot", 0.25f, 1.5f);
                this.useUpFuel(player, stack, 5);
                ArmorUtil.resetFlightTime(player);
            } else if (playerShouldHover && !player.field_70122_E && props.enableBackpack && gravity > 0.0f) {
                player.field_70143_R = 0.0f;
                float thrustMultiplier = Math.max(gravity / 1.6f, 1.0f);
                if (player.field_70181_x < (double)(-1.0f * thrustMultiplier)) {
                    player.field_70181_x += 0.2 * (double)thrustMultiplier;
                } else if (player.field_70181_x < -0.1 * (double)thrustMultiplier) {
                    player.field_70181_x += 0.1 * (double)thrustMultiplier;
                } else if (player.field_70181_x < 0.0) {
                    player.field_70181_x = 0.0;
                }
                player.field_70159_w *= 1.025;
                player.field_70179_y *= 1.025;
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "hbm:weapon.flamethrowerShoot", 0.25f, 1.5f);
                this.useUpFuel(player, stack, 10);
                ArmorUtil.resetFlightTime(player);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add("Regular jetpack that will automatically hover mid-air.");
        list.add("Sneaking will stop hover mode.");
        list.add("Hover mode will consume less fuel and increase air-mobility.");
        super.func_77624_a(stack, player, list, ext);
    }
}

