/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.FusionRecipe;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import com.hbm.items.ModItems;
import java.io.IOException;
import net.minecraft.item.ItemStack;

public class FusionRecipes
extends GenericRecipes<FusionRecipe> {
    public static final FusionRecipes INSTANCE = new FusionRecipes();

    @Override
    public int inputItemLimit() {
        return 0;
    }

    @Override
    public int inputFluidLimit() {
        return 3;
    }

    @Override
    public int outputItemLimit() {
        return 1;
    }

    @Override
    public int outputFluidLimit() {
        return 11;
    }

    @Override
    public String getFileName() {
        return "hbmFusion.json";
    }

    @Override
    public FusionRecipe instantiateRecipe(String name) {
        return new FusionRecipe(name);
    }

    @Override
    public void registerDefaults() {
        long solenoid = 25000L;
        double breederCapacity = 10000.0;
        this.register((FusionRecipe)new FusionRecipe("fus.dd").setInputEnergy(750000L).setOutputEnergy(1000000L).setOutputFlux(breederCapacity / 200.0).setRGB(1.0f, 0.2f, 0.2f).setNamed().setIcon(new ItemStack(ModItems.gas_full, 1, Fluids.DEUTERIUM.getID())).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.DEUTERIUM, 20)).outputFluids(new FluidStack(Fluids.HELIUM4, 1000)));
        this.register((FusionRecipe)new FusionRecipe("fus.do").setInputEnergy(250000L).setOutputEnergy(1250000L).setOutputFlux(breederCapacity / 200.0).setNamed().setIcon(new ItemStack(ModItems.gas_full, 1, Fluids.OXYGEN.getID())).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.DEUTERIUM, 10), new FluidStack(Fluids.OXYGEN, 10)).outputItems(new ItemStack(ModItems.pellet_charged)));
        this.register((FusionRecipe)new FusionRecipe("fus.dt").setInputEnergy(750000L).setOutputEnergy(3750000L).setOutputFlux(breederCapacity / 100.0).setNamed().setIcon(new ItemStack(ModItems.gas_full, 1, Fluids.HELIUM4.getID())).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.DEUTERIUM, 10), new FluidStack(Fluids.TRITIUM, 10)).outputFluids(new FluidStack(Fluids.HELIUM4, 1000)));
        this.register((FusionRecipe)new FusionRecipe("fus.tcl").setInputEnergy(2500000L).setOutputEnergy(6250000L).setOutputFlux(breederCapacity / 20.0).setRGB(0.8f, 0.6f, 0.4f).setNamed().setIcon(new ItemStack(ModItems.powder_chlorophyte)).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.TRITIUM, 10), new FluidStack(Fluids.CHLORINE, 10)).outputItems(new ItemStack(ModItems.powder_chlorophyte)));
        this.register((FusionRecipe)new FusionRecipe("fus.h3").setInputEnergy(500000L).setOutputEnergy(3750000L).setOutputFlux(0.0).setRGB(0.2f, 0.2f, 1.0f).setNamed().setIcon(new ItemStack(ModItems.gas_full, 1, Fluids.HELIUM3.getID())).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.HELIUM3, 20)).outputFluids(new FluidStack(Fluids.HELIUM4, 1000)));
        this.register((FusionRecipe)new FusionRecipe("fus.th4").setInputEnergy(875000L).setOutputEnergy(4000000L).setOutputFlux(breederCapacity / 20.0).setRGB(0.2f, 0.2f, 1.0f).setNamed().setIcon(new ItemStack(ModItems.gas_full, 1, Fluids.TRITIUM.getID())).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.TRITIUM, 10), new FluidStack(Fluids.HELIUM4, 10)).outputItems(new ItemStack(ModItems.pellet_charged)));
        this.register((FusionRecipe)new FusionRecipe("fus.cl").setInputEnergy(3750000L).setOutputEnergy(10000000L).setOutputFlux(breederCapacity / 10.0).setRGB(1.0f, 0.6f, 0.2f).setNamed().setIcon(new ItemStack(ModItems.powder_chlorophyte)).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.CHLORINE, 20)).outputItems(new ItemStack(ModItems.powder_chlorophyte)));
        this.register((FusionRecipe)new FusionRecipe("fus.dhc").setInputEnergy(10000000L).setOutputEnergy(25000000L).setOutputFlux(breederCapacity / 5.0).setRGB(0.2f, 0.8f, 0.8f).setNamed().setIcon(new ItemStack(ModItems.fluid_icon, 1, Fluids.DHC.getID())).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.DHC, 20)).outputItems(new ItemStack(ModItems.powder_chlorophyte)));
        this.register((FusionRecipe)new FusionRecipe("fus.bf").setInputEnergy(1000000L).setOutputEnergy(12500000L).setOutputFlux(breederCapacity / 5.0).setRGB(0.2f, 1.0f, 0.2f).setNamed().setIcon(new ItemStack(ModItems.fluid_icon, 1, Fluids.BALEFIRE.getID())).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.BALEFIRE, 15), new FluidStack(Fluids.AMAT, 5)).outputItems(new ItemStack(ModItems.powder_balefire)));
        this.register((FusionRecipe)new FusionRecipe("fus.stellar").setInputEnergy(10000000L).setOutputEnergy(50000000L).setOutputFlux(breederCapacity / 1.0).setRGB(1.0f, 0.4f, 0.1f).setNamed().setIcon(new ItemStack(ModItems.fluid_icon, 1, Fluids.STELLAR_FLUX.getID())).setPower(solenoid).setDuration(100).inputFluids(new FluidStack(Fluids.STELLAR_FLUX, 10)).outputItems(new ItemStack(ModItems.powder_gold)));
    }

    @Override
    public void readExtraData(JsonElement element, FusionRecipe recipe) {
        JsonObject obj = (JsonObject)element;
        recipe.ignitionTemp = obj.get("ignitionTemp").getAsLong();
        recipe.outputTemp = obj.get("outputTemp").getAsLong();
        recipe.neutronFlux = obj.get("outputFlux").getAsDouble();
        recipe.r = obj.get("r").getAsFloat();
        recipe.g = obj.get("g").getAsFloat();
        recipe.b = obj.get("b").getAsFloat();
    }

    @Override
    public void writeExtraData(FusionRecipe recipe, JsonWriter writer) throws IOException {
        writer.name("ignitionTemp").value(recipe.ignitionTemp);
        writer.name("outputTemp").value(recipe.outputTemp);
        writer.name("outputFlux").value(recipe.neutronFlux);
        writer.name("r").value((double)recipe.r);
        writer.name("g").value((double)recipe.g);
        writer.name("b").value((double)recipe.b);
    }
}

