/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerPneumoTube;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.render.util.GaugeUtil;
import com.hbm.tileentity.network.TileEntityPneumoTube;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIPneumoTube
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/storage/gui_pneumatic_pipe.png");
    private static ResourceLocation texture_endpoint = new ResourceLocation("hbm:textures/gui/storage/gui_pneumatic_endpoint.png");
    public TileEntityPneumoTube tube;
    public boolean endpointOnly;

    public GUIPneumoTube(InventoryPlayer invPlayer, TileEntityPneumoTube tedf, boolean endpointOnly) {
        super(new ContainerPneumoTube(invPlayer, tedf));
        this.tube = tedf;
        this.endpointOnly = endpointOnly;
        this.field_146999_f = 176;
        this.field_147000_g = 185;
    }

    public void func_73863_a(int x, int y, float interp) {
        super.func_73863_a(x, y, interp);
        if (!this.endpointOnly) {
            this.tube.compair.renderTankInfo(this, x, y, this.field_147003_i + 7, this.field_147009_r + 16, 18, 18);
            this.drawCustomInfoStat(x, y, this.field_147003_i + 7, this.field_147009_r + 52, 18, 18, x, y, (this.tube.redstone ? EnumChatFormatting.GREEN + "ON " : EnumChatFormatting.RED + "OFF ") + EnumChatFormatting.RESET + "with Redstone");
            String[] stringArray = new String[2];
            stringArray[0] = "Compressor: " + this.tube.compair.getPressure() + " PU";
            stringArray[1] = "Max range: " + TileEntityPneumoTube.getRangeFromPressure(this.tube.compair.getPressure()) + "m";
            this.drawCustomInfoStat(x, y, this.field_147003_i + 6, this.field_147009_r + 36, 20, 8, x, y, stringArray);
            this.drawCustomInfoStat(x, y, this.field_147003_i + 151, this.field_147009_r + 16, 18, 18, x, y, EnumChatFormatting.YELLOW + "Receiver order:", this.tube.receiveOrder == 0 ? "Round robin" : "Random");
            this.drawCustomInfoStat(x, y, this.field_147003_i + 151, this.field_147009_r + 52, 18, 18, x, y, EnumChatFormatting.YELLOW + "Provider slot order:", this.tube.sendOrder == 0 ? "First to last" : (this.tube.sendOrder == 1 ? "Last to first" : "Random"));
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null) {
            for (int i = 0; i < 15; ++i) {
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
                if (!this.func_146981_a(slot, x, y) || this.tube.pattern.modes[i] == null) continue;
                this.func_146283_a(Arrays.asList(EnumChatFormatting.RED + "Right click to change", ModulePatternMatcher.getLabel(this.tube.pattern.modes[i])), x, y - 30);
            }
        }
    }

    protected void func_73864_a(int x, int y, int i) {
        super.func_73864_a(x, y, i);
        if (!this.endpointOnly) {
            this.click(x, y, 7, 52, 18, 18, "redstone");
            this.click(x, y, 6, 36, 20, 8, "pressure");
            this.click(x, y, 151, 16, 18, 18, "receive");
            this.click(x, y, 151, 52, 18, 18, "send");
        }
        this.click(x, y, 128, 30, 14, 26, "whitelist");
    }

    public void click(int x, int y, int left, int top, int sizeX, int sizeY, String name) {
        if (this.checkClick(x, y, left, top, sizeX, sizeY)) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a(name, true);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.tube.field_145851_c, this.tube.field_145848_d, this.tube.field_145849_e));
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = this.tube.func_145818_k_() ? this.tube.func_145825_b() : I18n.func_135052_a((String)this.tube.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 5, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.endpointOnly ? texture_endpoint : texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tube.whitelist) {
            this.func_73729_b(this.field_147003_i + 139, this.field_147009_r + 33, 176, 0, 3, 6);
        } else {
            this.func_73729_b(this.field_147003_i + 139, this.field_147009_r + 47, 176, 0, 3, 6);
        }
        if (!this.endpointOnly) {
            if (this.tube.redstone) {
                this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 52, 179, 0, 18, 18);
            }
            this.func_73729_b(this.field_147003_i + 151, this.field_147009_r + 16, 197, 18 * this.tube.receiveOrder, 18, 18);
            this.func_73729_b(this.field_147003_i + 151, this.field_147009_r + 52, 215, 18 * this.tube.sendOrder, 18, 18);
            this.func_73729_b(this.field_147003_i + 6 + 4 * (this.tube.compair.getPressure() - 1), this.field_147009_r + 36, 179, 18, 4, 8);
            GaugeUtil.drawSmoothGauge(this.field_147003_i + 16, this.field_147009_r + 25, this.field_73735_i, (double)this.tube.compair.getFill() / (double)this.tube.compair.getMaxFill(), 5.0, 2.0, 1.0, 13265987, 11223587);
        }
    }
}

